-- Sound Specialization
--
-- author  Jumpster
-- 
-- date  25/05/12
-- 
-- Copyright (C) GIANTS Software GmbH and Jumpster, All Rights Reserved.
--
-- Script zum abspielen von extra Sounds in einem Mod.
--
-- kontakt: skype: martin-jumpster


Sound = {};

function Sound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Sound:load(xmlFile)
    hornSoundFile = Utils.getFilename("sounds/MgSound.wav", self.baseDirectory);
    self.hornSoundId = createSample("LizardHornSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;
end;

function Sound:delete()
    delete(self.burnerSoundId);
end;

function Sound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Sound:keyEvent(unicode, sym, modifier, isDown)
end;

function Sound:update(dt)
	if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.SoundBinding) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
end;

function Sound:draw()
    g_currentMission:addHelpButtonText(g_i18n:getText("Sound"), InputBinding.SoundBinding);
end;

