--
-- IndoorSound
-- Specialization for IndoorSound
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
--

IndoorSound = {};

function IndoorSound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function IndoorSound:load(xmlFile)

	self.indoorSounds = {};
	self.indoorSounds.sounds = {};
	self.indoorSounds.customSounds = {};
	i = 0;
	while true do 
		local key = string.format("vehicle.indoorSounds.sound(%d)", i);
		if not hasXMLProperty(xmlFile, key .. "#id") then
			break;
		end;
		
		local id = getXMLString(xmlFile, key .. "#id");
		
		local sound = {};
		sound.id = self[id];
		sound.name = id;
		if sound.id == nil then
			print("IndoorSounds: Sound '" .. id .. "' does not exist");
			break;
		end;		
		sound.outdoor = getSampleVolume(sound.id);
		sound.indoorFactor = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#percent"), 0.5);
		sound.indoor = sound.outdoor * sound.indoorFactor;
		
		local volumeId = getXMLString(xmlFile, key .. "#volume");
		if volumeId ~= nil then
			sound.volumeId = volumeId;
		end;
		
		local customSound = getXMLString(xmlFile, key .. "#customSound");
		if customSound ~= nil and customSound ~= "" then
			customSound = Utils.getFilename(customSound, self.baseDirectory);
			sound.customSound = createSample("customSound"..i);
			sound.customSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#customVolume"), 1);
			sound.customSoundLoops = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#customLoop"), 1);
			loadSample(sound.customSound, customSound, false);
			table.insert(self.indoorSounds.customSounds, sound);
		else
			table.insert(self.indoorSounds.sounds, sound);
		end;
		
		i = i + 1;
	end;
	
	self.indoorSounds.indoorCamIndex = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.indoorSounds#camIndex"), 1);	
	self.indoorSounds.lastCamIndex = 1;
end;

function IndoorSound:delete()
	for _, sound in pairs(self.indoorSounds.customSounds) do
		if self.indoorSounds.indoorCamIndex == self.indoorSounds.lastCamIndex then
			delete(sound.id);	
		else
			delete(sound.customSound);	
		end;
	end;
end;

function IndoorSound:readStream(streamId, connection)
end;

function IndoorSound:writeStream(streamId, connection)
end;

function IndoorSound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function IndoorSound:keyEvent(unicode, sym, modifier, isDown)
end;

function IndoorSound:update(dt)
end;

function IndoorSound:updateTick(dt)
	if self.isEntered then
		local sound = self.indoorSounds;
		if sound.lastCamIndex ~= self.camIndex then
			if self.camIndex == sound.indoorCamIndex then
				for _, sound in pairs(sound.customSounds) do
					stopSample(sound.id);
					self[sound.name] = sound.customSound;	
					playSample(sound.customSound, sound.customSoundLoops, sound.customSoundVolume, 0);
				end;
				for _, sound in pairs(sound.sounds) do
					setSampleVolume(sound.id, sound.indoor);
					if sound.volumeId ~= nil then
						self[sound.volumeId] = sound.indoor;
					end;
				end;
				sound.lastCamIndex = self.camIndex;
			else
				for _, sound in pairs(sound.customSounds) do
					stopSample(sound.customSound);
					self[sound.name] = sound.id;	
					playSample(sound.id, sound.customSoundLoops, sound.customSoundVolume, 0);
				end;
				for _, sound in pairs(sound.sounds) do
					setSampleVolume(sound.id, sound.outdoor);	
					if sound.volumeId ~= nil then
						self[sound.volumeId] = sound.outdoor;
					end;
				end;			
				sound.lastCamIndex = self.camIndex;
			end;
		end;
	end;
end;

function IndoorSound:draw()	
end;