--
-- self
-- for all self
--
-- @author by Boembchen
-- @date  27/10/10
--
-- Copyright (C) 

magnum = {};

function magnum .prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function magnum:load(xmlFile)

   
	
	self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.bottomArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArm"));
	
	self.frontAxle = {};
	self.frontAxle.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#rotNode"));
	self.frontAxle.steeringPush = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#steeringPush"));
	self.frontAxle.steeringPushLeftAttach = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#steeringPushLeftAttach"));
	self.frontAxle.steeringPushRightAttach = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#steeringPushRightAttach"));
	
	self.numAnimatedWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.animatedWheels#count"), 0);
	self.animatedWheel = {};
    for i=1, self.numAnimatedWheels do
        local objname = string.format("vehicle.animatedWheels.wheel" .. "%d", i);
		self.animatedWheel[i] = {};
        self.animatedWheel[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		self.animatedWheel[i].wheel = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#wheelIndex"));
		self.animatedWheel[i].fenderAttach = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#fenderAttach"));
    end;
	
	
    self.key = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.key#index"));
	self.engineRunTime = 0;
end;

function magnum:keyEvent(unicode, sym, modifier, isDown)
end;


function magnum:update(dt)

    
	if self.frontAxle.rotNode ~= nil and self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
		local ax, ay, az = getWorldTranslation(self.wheels[1].repr);
        local bx, by, bz = getWorldTranslation(self.wheels[2].repr);
		
		local yDiff = by-ay;
		local xDiff = 2 * 0.88;
		
		local angle = 0;
		if yDiff ~= 0 then
			angle = yDiff/math.tan(xDiff);
		end;

		setRotation(self.frontAxle.rotNode,0,0,angle);
	end;
	
	for i=1, self.numAnimatedWheels do
		if self.wheels[i].repr ~= nil then
			local x,y,z = getRotation(self.wheels[i].driveNode);
			local x2,y2,z2 = getRotation(self.wheels[i].repr);
			setRotation(self.animatedWheel[i].wheel, x,y,z);
			setRotation(self.animatedWheel[i].rotNode, x2,y2,z2);
		end;
	end;
	
	if self.frontAxle.steeringPushLeftAttach ~= nil and self.animatedWheel[1].fenderAttach ~= nil then
		local ax, ay, az = getWorldTranslation(self.frontAxle.steeringPushLeftAttach);
        local bx, by, bz = getWorldTranslation(self.animatedWheel[1].fenderAttach);
        local cx, cy, cz = getWorldTranslation(self.frontAxle.rotNode);
		
		local zDiff = bz-az;
		local xDiff = bx-ax;
		
		local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.steeringPushLeftAttach), bx-ax, by-ay, bz-az);
        setDirection(self.frontAxle.steeringPushLeftAttach, x, y, z, 0, 1, 0);
		
		local x2,y2,z2 = getRotation(self.frontAxle.steeringPushLeftAttach);
		setRotation(self.frontAxle.steeringPushLeftAttach,x2,y2+4.71,z2);

		local x,y,z = getRotation(self.animatedWheel[1].rotNode);
		self.translation = -0.2094 * math.tan(y);
		setTranslation(self.frontAxle.steeringPush,(self.translation)*0.81,0,0);	
	end;
	
	if self.frontAxle.steeringPushRightAttach ~= nil and self.animatedWheel[2].fenderAttach ~= nil and self.frontAxle.steeringPush ~= nil then
		local ax, ay, az = getWorldTranslation(self.frontAxle.steeringPushRightAttach);
        local bx, by, bz = getWorldTranslation(self.animatedWheel[2].fenderAttach);
		--local cx, cy, cz = getWorldTranslation(self.frontAxle.rotNode);
		
		local zDiff = bz-az;
		local xDiff = bx-ax;
		
		
		local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.steeringPushRightAttach), bx-ax, by-ay, bz-az);
        setDirection(self.frontAxle.steeringPushRightAttach, x, y, z, 0, 1, 0);
		
		local x2,y2,z2 = getRotation(self.frontAxle.steeringPushRightAttach);
		setRotation(self.frontAxle.steeringPushRightAttach,x2,y2-4.71,z2);
	end;
	if self.key ~= nil then
		if self.isMotorStarted and self.engineRunTime < 1500 then
			setRotation(self.key, Utils.degToRad(-74.51489),Utils.degToRad(-29.51921) ,Utils.degToRad(60.65189));
		elseif self.isMotorStarted then
			setRotation(self.key, Utils.degToRad(-60.11575),Utils.degToRad(-14.71329) ,Utils.degToRad(23.84418));
		else
			setRotation(self.key, Utils.degToRad(-57.08946),Utils.degToRad(2.67945) ,Utils.degToRad(-4.13145));
		end;
	end;
	Cylindered.updateMovingPart(self, self.movingParts[1]);
end;
function magnum:updateTick(dt)

    if self:getIsActive() then	
		
		
		if self.backHydraulic ~= nil then
			-- set correct rotation on rootArm
			local x, y, z = getRotation(self.backHydraulic.bottomArm);
			setRotation(self.backHydraulic.rootArm, x, y, z);			
		end;
		
    end;
end;
function magnum:draw()
end;

function magnum:onEnter()  
end;

function magnum:onLeave()   
end;

function magnum:delete() 
end;

function magnum:mouseEvent(posX, posY, isDown, isUp, button)
end;