--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.77, 0.22, 0.02, "END: HUD on");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.77, 0.22, 0.02, "END: HUD off");
		renderText(0.72, 0.86, 0.025, "-- John Deere 6430 --");			
		renderText(0.72, 0.83, 0.02, "Home: Beacon on/off");
		renderText(0.72, 0.81, 0.02, "5: Front lift");
		renderText(0.72, 0.79, 0.02, "6: Frontloader console on/off");			
		renderText(0.72, 0.77, 0.02, "7: Attacher up");
		renderText(0.72, 0.75, 0.02, "8: Attacher down");
		renderText(0.72, 0.73, 0.02, "9: Tyres");
		renderText(0.72, 0.71, 0.02, "Numpad 1: Turn singnal Left");
		renderText(0.72, 0.69, 0.02, "Numpad 2: Hazard");
		renderText(0.72, 0.67, 0.02, "Numpad 3: Turn singnal right");
		renderText(0.72, 0.65, 0.02, "Numpad 5: Front worklight");
		renderText(0.72, 0.63, 0.02, "Numpad 6: Back worklight");
		renderText(0.72, 0.61, 0.02, "Page up, Page down: ESlimiter");
		renderText(0.72, 0.59, 0.02, "SPACE: for IC controlpanel system");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




