-- gives the baler damage until it cant be used anymore.
-- schaden an der Ballenpresse, bis diese nicht mehr benutzt werden kann


--2013 by acert (find me at modhoster)


BalerDamage = {};

function BalerDamage.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function BalerDamage:load(xmlFile)
	self.SetBaleCount= SpecializationUtil.callSpecializationsFunction("SetBaleCount");
	self.TotalBalesCount = 0;
	self.CurrentBales = 0;
	self.TotalwasToFast = 0;
	self.DamageSoundEnabled = false;
	self.isDamaged = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.isDamaged#value"), 1);
	self.isDamagedByToFast = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.isDamagedByToFast#value"), 1);

	local DamageSound = getXMLString(xmlFile, "vehicle.DamageSound#file");
           if DamageSound ~= nil and DamageSound ~= "" then
               DamageSound = Utils.getFilename(DamageSound, self.baseDirectory);
               self.DamageSound = createSample("DamageSound");
               self.DamageSoundEnabled = false;
               loadSample(self.DamageSound, DamageSound, false);
               self.DamageSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.DamageSound#pitchOffset"), 1);
               self.DamageSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.DamageSound#volume"), 1.0);
           end;	
end;

function BalerDamage:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
   local TotalBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#TotalBalesCount"),0);
   self.TotalBalesCount = TotalBalesCount;
   local TotalwasToFast =  Utils.getNoNil(getXMLInt(xmlFile, key.."#TotalwasToFast"),0);
   self.TotalwasToFast = TotalwasToFast; 
   return BaseMission.VEHICLE_LOAD_OK;
end;

function BalerDamage:getSaveAttributesAndNodes(nodeIdent)
   local TotalwasToFast= Utils.getNoNil(self.TotalwasToFast, 0);
   local attributes = 'TotalwasToFast="'..string.format("%.1f",TotalwasToFast)..'"';
   local TotalBalesCount= Utils.getNoNil(self.TotalBalesCount, 0);
   local attributes = 'TotalBalesCount="'..string.format("%.1f",TotalBalesCount)..'"';
   
   return attributes, nil;
end;

function BalerDamage:delete()
	if self.DamageSound ~= nil then
           delete(self.DamageSound);
    end;
end;

function BalerDamage:readStream(streamId, connection)
    self.TotalBalesCount = streamReadInt32(streamId);
    self.KroneComprimaNoRopesBalesCount = streamReadInt32(streamId);
    self.CurrentBales = streamReadInt32(streamId);
end;

function BalerDamage:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.TotalBalesCount);
    streamWriteInt32(streamId, self.NoRopesBalesCount);
    streamWriteInt32(streamId, self.CurrentBalesCount);
end;

function BalerDamage:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BalerDamage:keyEvent(unicode, sym, modifier, isDown)
end;

function BalerDamage:update(dt)
 if self:getIsActive() then
	if self.TotalBalesCount == self.isDamaged then
		self.BalerIsDestroyed = true
	end
	if self.TotalwasToFast == self.isDamagedByToFast then
		self.BalerIsDestroyed = true
	end

	if 	self.BalerIsDestroyed == true then
		self.isTurnedOn = false
		g_currentMission:addWarning(g_i18n:getText("DAMAGE"), 0.018, 0.033);
	end;
	
	
	if self.isTurnedOn then
		local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 29
		if toFast then
			self.TotalwasToFast = self.TotalwasToFast +1;
		end;	
	end;
end;	
			
                   if not self.DamageSoundEnabled and self:getIsActiveForSound() and self.BalerIsDestroyed and not self.isTurnedOn then
                       playSample(self.DamageSound, 0, self.DamageSoundVolume, 0);
                       setSamplePitch(self.DamageSound, self.DamageSoundPitchOffset);
                       self.DamageSoundEnabled = true;
                   end;
end;

function BalerDamage:onLeave()
	self.BalerIsDestroyed = false	
	stopSample(self.DamageSound)
end;

function BalerDamage:onDetach()
	self.BalerIsDestroyed = false
	stopSample(self.DamageSound)	
end;

function BalerDamage:updateTick(dt)	
end;

function BalerDamage:draw()
end;

function BalerDamage.dropBale(self, baleIndex)
	if self.CurrentBales ~= nil and self.TotalBalesCount ~= nil then
		self.CurrentBales = self.CurrentBales +1;
		self.TotalBalesCount = self.TotalBalesCount +1;
	end;
end;

Baler.dropBale = Utils.appendedFunction(Baler.dropBale, BalerDamage.dropBale);