--
-- TwinWheel
-- Specialization for TwinWheel
--
--@poc@lypse

TwinWheel = {};

function TwinWheel.prerequisitesPresent(specializations)
    return true
end;

function TwinWheel:load(xmlFile)

	self.setTwinWheelState = SpecializationUtil.callSpecializationsFunction("setTwinWheelState");


self.numjumWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.jumWheels#count"), 0);
    self.jumWheels = {};
    for i=1, self.numjumWheels do
        local jumWheelnamei = string.format("vehicle.jumWheels.jumWheel" .. "%d", i);
        self.jumWheels[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, jumWheelnamei .. "#index"));
        setVisibility(self.jumWheels[i], false);        
    end;
    self.jumelagesActive = false;	


    self.numTwinWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twinWheels#count"), 0);
    self.twinWheels = {};
    for i=1, self.numTwinWheels do
        local twinWheelnamei = string.format("vehicle.twinWheels.twinWheel" .. "%d", i);
        self.twinWheels[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, twinWheelnamei .. "#index"));
        setVisibility(self.twinWheels[i], false);        
    end;
	self.twinWheelsActive = false;  
 
	self.numSmallWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.smallWheels#count"), 0);
    self.smallWheels = {};
    for i=1, self.numSmallWheels do
        local smallWheelnamei = string.format("vehicle.smallWheels.smallWheel" .. "%d", i);
        self.smallWheels[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, smallWheelnamei .. "#index"));
        setVisibility(self.smallWheels[i], true);       
    end; 
        self.smallWheelsActive = false;

        self.TwinWheelMode = 0;
	


		
end;

function TwinWheel:delete()
end;

function TwinWheel:readStream(streamId, connection)
	self:setTwinWheelState(streamReadInt8(streamId), true);
end;

function TwinWheel:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.TwinWheelMode);
end;

function TwinWheel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TwinWheel:keyEvent(unicode, sym, modifier, isDown)
end;

function TwinWheel:update(dt)
      
                    

if self.isEntered then
  if self.isMotorStarted then
	if self:getIsActive() then
		if self:getIsActiveForInput() then			
			if InputBinding.hasEvent(InputBinding.MXJUMELAGES) then
				 self:setTwinWheelState(self.TwinWheelMode + 1);  
                                     if self.TwinWheelMode > 2 then  
                                        self:setTwinWheelState(0, true);
                                    end;
			end;
		end;
	end;
  end;
end;
end;

function TwinWheel:updateTick(dt)
end;

function TwinWheel:draw()
g_currentMission:addExtraPrintText(g_i18n:getText("MXJUMELAGES"));
end;




function TwinWheel:setTwinWheelState(TwinWheelstate, noEventSend)
	TwinWheelStateEvent.sendEvent(self, TwinWheelstate, noEventSend);
	   self.TwinWheelMode = TwinWheelstate;
	                 if self.TwinWheelMode == 0 then 
                         self.smallWheelsActive = true;                                           
                          self.jumelagesActive = false;                          
                          self.twinWheelsActive = false;                                                         
                         elseif self.TwinWheelMode == 1 then
                           self.smallWheelsActive = true;                                           
                          self.jumelagesActive = false;                          
                          self.twinWheelsActive = true;
                         elseif self.TwinWheelMode == 2 then
                          self.smallWheelsActive = true;                                           
                          self.jumelagesActive = true;                          
                          self.twinWheelsActive = true;
                        end; 
                       

        for k, jumWheel in pairs(self.jumWheels) do
				setVisibility(jumWheel, self.jumelagesActive);
			end;
           
                        for i, twinWheel in pairs(self.twinWheels) do
				setVisibility(twinWheel, self.twinWheelsActive);
			end;
  
                        for j, smallWheel in pairs(self.smallWheels) do
				setVisibility(smallWheel, self.smallWheelsActive);
			end;
      
end;

