--
-- Options
-- Specialization for seperate Options
--
-- @author @poc@lypse
-- 
--

Options = {};

function Options.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Options:load(xmlFile)

self.starfire = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.starfire#index"));
-- Essuie glace
 local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;
-- Clignotant

       turn1SoundFile = Utils.getFilename("turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
	
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
-- Retro

       self.mirrorsEnabled = false;
	self.leftMirrorGlass = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMirrorGlass#index"));
	self.rightMirrorGlass = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMirrorGlass#index"));	
	self.leftMirror = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMirror#index"));
	self.rightMirror = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMirror#index"));
	
	if self.mirrorRotationOffsetXleft == nil then
		self.mirrorRotationOffsetXleft = 0;
	end;
	
	if self.mirrorRotationOffsetYleft == nil then
		self.mirrorRotationOffsetYleft = 0;
	end;

	if self.mirrorRotationOffsetXright == nil then
		self.mirrorRotationOffsetXright = 0;
	end;

	if self.mirrorRotationOffsetYright == nil then
		self.mirrorRotationOffsetYright = 0;
	end;
	
-- relevage
        self.lifter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifter#index"));
	self.lifterAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterAttacher#index"));
	self.lifterArmLower = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterArmLower#index"));
	self.lifterArmLowerAttacherJoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterArmLowerAttacherJoint#index"));
	self.push1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.push1#index"));
	self.push2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.push2#index"));
	self.hydraulics1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics1#index"));
	self.hydraulics2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics2#index"));
	self.hydraulicsJoint1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicsJoint1#index"));
	self.hydraulicsJoint2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicsJoint2#index"));
        
	self.lifterStartAngle = 0;
	
	self.startAngel1 = 0;
	self.startAngel2 = 0;
	self.startTranslation = 0;
	self.liftInitialized = false;
--Fenetre et porte
self.doRotate = SpecializationUtil.callSpecializationsFunction("doRotate");

    self.rotatingParts = {};
    local rotatingPartsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rotatingParts#count"), 0);	
	for i=1, rotatingPartsCount do
		local namei = string.format("vehicle.rotatingParts.rotatingPart%d", i);
		local rotatingPart = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		
		self.rotatingParts[i] = {};
		self.rotatingParts[i].node = rotatingPart;
		
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#minRot"));
        self.rotatingParts[i].minRot = {};
        self.rotatingParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#maxRot"));
		self.rotatingParts[i].maxRot = {};
        self.rotatingParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		self.rotatingParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile, namei .. "#rotTime"), 2)*1000;
	end;
	
	self.isLeftDoorOpen = false;
	self.isRightDoorOpen = false;
	self.isRearWindowOpen = false;	
--

  

   
   
  
 self.shiftmode = 0;


end;
function Options:delete()
end;

function Options:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Options:keyEvent(unicode, sym, modifier, isDown)
end;

function Options:update(dt)


    if self.isAITractorActivated then
        setVisibility(self.starfire,true);
  else
    setVisibility(self.starfire,false);
  end;

              
  

  
if self.isEntered then
  if self.isMotorStarted then
		     if self.motorSound ~= nil then
				if self.camIndex == self.intCameraIndex then
					setSampleVolume(self.motorSound, self.motorSoundVolume/7);
				else
					setSampleVolume(self.motorSound, self.motorSoundVolume);
				end;
			end;
			
			if self.motorStartSound ~= nil then
				
				if self.camIndex == self.intCameraIndex then
					setSampleVolume(self.motorStartSound, self.motorStartSoundVolume/4);
				else
					setSampleVolume(self.motorStartSound, self.motorStartSoundVolume);
				end;
			end;
			
			if self.motorStopSound ~= nil then
				
				if self.camIndex == self.intCameraIndex then
					setSampleVolume(self.motorStopSound, 1/4);
				else
					setSampleVolume(self.motorStopSound, 1);
				end;
			end;
          
                  
             -- Essuie glace
               if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;
             --Shift mode
                 if InputBinding.hasEvent(InputBinding.MXSHIFTMODE) then
                   if self.shiftmode == 0 then
                     self.shiftmode = 1;
                   elseif self.shiftmode == 1 then
                     self.shiftmode = 0;
                   end;
                  end;

               
   		
		


                
        
         
               -- Clignotant

                 if InputBinding.hasEvent(InputBinding.MXCLIGNOG) then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	        end;

	if InputBinding.hasEvent(InputBinding.MXWARN) then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;

	if InputBinding.hasEvent(InputBinding.MXCLIGNOD) then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;	
               -- Retro

                  if InputBinding.hasEvent(InputBinding.MXACTIVATEMIRRORS) then
			self.mirrorsEnabled = not self.mirrorsEnabled;
		end;

                 if self.leftMirrorGlass ~= nil then
		setVisibility(self.leftMirrorGlass,self.mirrorsEnabled);
	end;
	
	if self.rightMirrorGlass ~= nil then
		setVisibility(self.rightMirrorGlass,self.mirrorsEnabled);
	end;
	
	if self.leftMirror ~= nil then
		setRotation(self.leftMirror,Utils.degToRad(-self.mirrorRotationOffsetXleft),Utils.degToRad(226.5-self.mirrorRotationOffsetYleft),Utils.degToRad(0));
	end;
	
	if self.rightMirror ~= nil then
		setRotation(self.rightMirror,Utils.degToRad(-self.mirrorRotationOffsetXright),Utils.degToRad(self.mirrorRotationOffsetYright),Utils.degToRad(0));
	end;
              
                 --Fenetre et porte
                    if self.rotatingParts[1] ~= nil then
			if InputBinding.hasEvent(InputBinding.DOOR1) then
				self.isLeftDoorOpen = not self.isLeftDoorOpen;
			end;
			
			self:doRotate(1, self.isLeftDoorOpen, dt);	
		    end;		  
		
		     if self.rotatingParts[2] ~= nil then		
			if InputBinding.hasEvent(InputBinding.WINDOW) then	
				self.isRearWindowOpen = not self.isRearWindowOpen;
			end;
		
			self:doRotate(2, self.isRearWindowOpen, dt);
		      end;
                 --

                

   end;
 end;
           -- relevage
           	if self.lifterArmLower ~= nil and self.lifter ~= nil then
		local x,y,z = getRotation(self.lifterArmLower);
		if self.lifterStartAngle == 0 and x ~= 0 then
			self.lifterStartAngle = x;
		end;
		
		local lifterFactor = 2.12;
		local lifterRotation =  x * lifterFactor-self.lifterStartAngle * lifterFactor;
		setRotation(self.lifter, lifterRotation, y,z);
		
		local lifterAttacherFactor = 2.51;
		local lifterAttacherRotation =  self.lifterStartAngle * lifterAttacherFactor - x * lifterAttacherFactor;
		setRotation(self.lifterAttacher, lifterAttacherRotation, y,z);
		
	end;
	
	if self.hydraulicsJoint1 ~= nil and self.hydraulics1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulics1);
        local bx, by, bz = getWorldTranslation(self.hydraulicsJoint1);

        local x, y, z = worldDirectionToLocal(getParent(self.hydraulics1), bx-ax, by-ay, bz-az);
        setDirection(self.hydraulics1, x, y, z, 0, 1, 0);
		setTranslation(self.push1,0,by-ay,0);
		
		
		local x2,y2,z2 = getRotation(self.hydraulics1);
		setRotation(self.hydraulics1,x2+1.57,y2,z2);
	end;
	
	if self.hydraulicsJoint2 ~= nil and self.hydraulics2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulics2);
        local bx, by, bz = getWorldTranslation(self.hydraulicsJoint2);

        local x, y, z = worldDirectionToLocal(getParent(self.hydraulics2), bx-ax, by-ay, bz-az);
        setDirection(self.hydraulics2, x, y, z, 0, 1, 0);
		setTranslation(self.push2,0,by-ay,0);
		
		
		local x2,y2,z2 = getRotation(self.hydraulics2);
		setRotation(self.hydraulics2,x2+1.57,y2,z2);
	end;
	

  --Clignotant
      if self.flash then
		    if self.delayOn >= 0 then
			    self.delayOn = self.delayOn -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOn < 0 then
				    self.delayOff = 500;
				    self.flashlightsRightActive = true;
				    self.flashlightsLeftActive = true;
			    	self.flashlightsWarnerActive = true;
				    self.turnlightsActive2 = true;
			    	self.turnlightsActive = true;
				    playSample(self.turn1, 1, 0.7, 0);                                    
			    end;
		    end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	  end;

	    if self.flashRight then
		    if self.delayOnRight >= 0 then
			    self.delayOnRight = self.delayOnRight -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOnRight < 0 then
				    self.delayOffRight = 500;
				    self.flashlightsRightActive = true;
				    self.turnlightsActive2 = true;
				    playSample(self.turn1,1,0.7,0);
                                    
			    end;
		    end;
		    if self.delayOffRight >= 0 then
			   self.delayOffRight = self.delayOffRight -dt;
		    end;
		    if self.flashlightsRightActive then
			    if self.delayOffRight < 0 then
				    self.delayOnRight = 500;
				    self.flashlightsRightActive = false;
				    self.turnlightsActive2 = false;
				    playSample(self.turn2,1,0.7,0);
			    end;
		    end;
	    else
		    if not self.flashWarner then
			    self.turnlightsActive2 = false;
		    end;
	    end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
                                                                               
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);                                        
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;

		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
    	if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
  
end;

function Options:onLeave()
 
end;

function Options:draw()
end;

function Options:doRotate(index, boolean, dt)
	local x, y, z = getRotation(self.rotatingParts[index].node);
	local rot = {x,y,z};
	local newRot = Utils.getMovedLimitedValues(rot, self.rotatingParts[index].maxRot, self.rotatingParts[index].minRot, 3, self.rotatingParts[index].rotTime, dt, not boolean);
	setRotation(self.rotatingParts[index].node, unpack(newRot));
end;

function Options:validateAttacherJoint(implement, jointDesc, dt)
	if self.jointmove then
		return true;
	end;
end;

