TwinWheelStateEvent = {};
TwinWheelStateEvent_mt = Class(TwinWheelStateEvent, Event);

InitEventClass(TwinWheelStateEvent, "TwinWheelStateEvent");

function TwinWheelStateEvent:emptyNew()
    local self = Event:new(TwinWheelStateEvent_mt);
    self.className="TwinWheelStateEvent";
    return self;
end;

function TwinWheelStateEvent:new(vehicle, state)
    local self = TwinWheelStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.twinwheelState = state;
    return self;
end;

function TwinWheelStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.twinwheelState = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function TwinWheelStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.twinwheelState);
end;

function TwinWheelStateEvent:run(connection)
	self.vehicle:setTwinWheelState(self.twinwheelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(TwinWheelStateEvent:new(self.vehicle, self.twinwheelState), nil, connection, self.object);
    end;
end;


function TwinWheelStateEvent.sendEvent(vehicle, state, noEventSend)
	if vehicle.TwinWheelMode ~= state then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(TwinWheelStateEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(TwinWheelStateEvent:new(vehicle, state));
			end;
		end;
	end;
end;