--
-- Digital Display Specialization for Vehicles
--
-- @author  Knagsted
-- @date  16/07/10


digitalDisplay = {};

function digitalDisplay.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function digitalDisplay:load(xmlFile)
	-- Digital Display digits RPM
	self.numDigitRPMOne = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMOne#count"), 0);
	self.digitRPMOne = {};
    for i=1, self.numDigitRPMOne do
        local objname = string.format("vehicle.displayDigitRPMOne.digitRPM" .. "%d", i);
		self.digitRPMOne[i] = {};
        self.digitRPMOne[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMOne[i].rotNode,false);
    end;
	setVisibility(self.digitRPMOne[self.numDigitRPMOne].rotNode,true);
	
	self.numDigitRPMTwo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMTwo#count"), 0);
	self.digitRPMTwo = {};
    for i=1, self.numDigitRPMTwo do
        local objname = string.format("vehicle.displayDigitRPMTwo.digitRPM" .. "%d", i);
		self.digitRPMTwo[i] = {};
        self.digitRPMTwo[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMTwo[i].rotNode,false);
    end;
	setVisibility(self.digitRPMTwo[self.numDigitRPMTwo].rotNode,true);

	self.numDigitRPMThree = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMThree#count"), 0);
	self.digitRPMThree = {};
    for i=1, self.numDigitRPMThree do
        local objname = string.format("vehicle.displayDigitRPMThree.digitRPM" .. "%d", i);
		self.digitRPMThree[i] = {};
        self.digitRPMThree[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMThree[i].rotNode,false);
    end;
	setVisibility(self.digitRPMThree[self.numDigitRPMThree].rotNode,true);
	
	self.numDigitRPMFour = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMFour#count"), 0);
	self.digitRPMFour = {};
    for i=1, self.numDigitRPMFour do
        local objname = string.format("vehicle.displayDigitRPMFour.digitRPM" .. "%d", i);
		self.digitRPMFour[i] = {};
        self.digitRPMFour[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMFour[i].rotNode,false);
    end;
	setVisibility(self.digitRPMFour[self.numDigitRPMFour].rotNode,true);
	
	-- Digital Display digits Speed
	self.numDigitSPEEDOne = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDOne#count"), 0);
	self.digitSPEEDOne = {};
    for i=1, self.numDigitSPEEDOne do
        local objname = string.format("vehicle.displayDigitSPEEDOne.digitSPEED" .. "%d", i);
		self.digitSPEEDOne[i] = {};
        self.digitSPEEDOne[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDOne[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDOne[self.numDigitSPEEDOne].rotNode,true);
	
	self.numDigitSPEEDTwo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDTwo#count"), 0);
	self.digitSPEEDTwo = {};
    for i=1, self.numDigitSPEEDTwo do
        local objname = string.format("vehicle.displayDigitSPEEDTwo.digitSPEED" .. "%d", i);
		self.digitSPEEDTwo[i] = {};
        self.digitSPEEDTwo[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDTwo[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDTwo[self.numDigitSPEEDTwo].rotNode,true);

	self.numDigitSPEEDThree = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDThree#count"), 0);
	self.digitSPEEDThree = {};
    for i=1, self.numDigitSPEEDThree do
        local objname = string.format("vehicle.displayDigitSPEEDThree.digitSPEED" .. "%d", i);
		self.digitSPEEDThree[i] = {};
        self.digitSPEEDThree[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDThree[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDThree[self.numDigitSPEEDThree].rotNode,true);
	
	self.numDigitSPEEDFour = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDFour#count"), 0);
	self.digitSPEEDFour = {};
    for i=1, self.numDigitSPEEDFour do
        local objname = string.format("vehicle.displayDigitSPEEDFour.digitSPEED" .. "%d", i);
		self.digitSPEEDFour[i] = {};
        self.digitSPEEDFour[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDFour[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDFour[self.numDigitSPEEDFour].rotNode,true);
	-- Digital display ligth on
	-- Digital Display digits RPM
	self.numDigitRPMOneLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMOneLight#count"), 0);
	self.digitRPMOneLight = {};
    for i=1, self.numDigitRPMOneLight do
        local objname = string.format("vehicle.displayDigitRPMOneLight.digitRPM" .. "%d", i);
		self.digitRPMOneLight[i] = {};
        self.digitRPMOneLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMOneLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMOneLight[self.numDigitRPMOneLight].rotNode,true);
	
	self.numDigitRPMTwoLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMTwoLight#count"), 0);
	self.digitRPMTwoLight = {};
    for i=1, self.numDigitRPMTwoLight do
        local objname = string.format("vehicle.displayDigitRPMTwoLight.digitRPM" .. "%d", i);
		self.digitRPMTwoLight[i] = {};
        self.digitRPMTwoLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMTwoLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMTwoLight[self.numDigitRPMTwoLight].rotNode,true);

	self.numDigitRPMThreeLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMThreeLight#count"), 0);
	self.digitRPMThreeLight = {};
    for i=1, self.numDigitRPMThreeLight do
        local objname = string.format("vehicle.displayDigitRPMThreeLight.digitRPM" .. "%d", i);
		self.digitRPMThreeLight[i] = {};
        self.digitRPMThreeLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMThreeLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMThreeLight[self.numDigitRPMThreeLight].rotNode,true);
	
	self.numDigitRPMFourLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMFourLight#count"), 0);
	self.digitRPMFourLight = {};
    for i=1, self.numDigitRPMFourLight do
        local objname = string.format("vehicle.displayDigitRPMFourLight.digitRPM" .. "%d", i);
		self.digitRPMFourLight[i] = {};
        self.digitRPMFourLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMFourLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMFourLight[self.numDigitRPMFourLight].rotNode,true);
	
	-- Digital Display digits Speed
	self.numDigitSPEEDOneLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDOneLight#count"), 0);
	self.digitSPEEDOneLight = {};
    for i=1, self.numDigitSPEEDOneLight do
        local objname = string.format("vehicle.displayDigitSPEEDOneLight.digitSPEED" .. "%d", i);
		self.digitSPEEDOneLight[i] = {};
        self.digitSPEEDOneLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDOneLight[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDOneLight[self.numDigitSPEEDOneLight].rotNode,true);
	
	self.numDigitSPEEDTwoLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDTwoLight#count"), 0);
	self.digitSPEEDTwoLight = {};
    for i=1, self.numDigitSPEEDTwoLight do
        local objname = string.format("vehicle.displayDigitSPEEDTwoLight.digitSPEED" .. "%d", i);
		self.digitSPEEDTwoLight[i] = {};
        self.digitSPEEDTwoLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDTwoLight[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDTwoLight[self.numDigitSPEEDTwoLight].rotNode,true);

	self.numDigitSPEEDThreeLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDThreeLight#count"), 0);
	self.digitSPEEDThreeLight = {};
    for i=1, self.numDigitSPEEDThreeLight do
        local objname = string.format("vehicle.displayDigitSPEEDThreeLight.digitSPEED" .. "%d", i);
		self.digitSPEEDThreeLight[i] = {};
        self.digitSPEEDThreeLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDThreeLight[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDThreeLight[self.numDigitSPEEDThreeLight].rotNode,true);
	
	self.numDigitSPEEDFourLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDFourLight#count"), 0);
	self.digitSPEEDFourLight = {};
    for i=1, self.numDigitSPEEDFourLight do
        local objname = string.format("vehicle.displayDigitSPEEDFourLight.digitSPEED" .. "%d", i);
		self.digitSPEEDFourLight[i] = {};
        self.digitSPEEDFourLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDFourLight[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDFourLight[self.numDigitSPEEDFourLight].rotNode,true);
	
	-- Digital Display digits LiftHeight
	self.numDigitLiftHeightOne = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitLiftHeightOne#count"), 0);
	self.digitLiftHeightOne = {};
    for i=1, self.numDigitLiftHeightOne do
        local objname = string.format("vehicle.displayDigitLiftHeightOne.digitLiftHeight" .. "%d", i);
		self.digitLiftHeightOne[i] = {};
        self.digitLiftHeightOne[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitLiftHeightOne[i].rotNode,false);
    end;
	setVisibility(self.digitLiftHeightOne[self.numDigitLiftHeightOne].rotNode,true);
	
	self.numDigitLiftHeightTwo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitLiftHeightTwo#count"), 0);
	self.digitLiftHeightTwo = {};
    for i=1, self.numDigitLiftHeightTwo do
        local objname = string.format("vehicle.displayDigitLiftHeightTwo.digitLiftHeight" .. "%d", i);
		self.digitLiftHeightTwo[i] = {};
        self.digitLiftHeightTwo[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitLiftHeightTwo[i].rotNode,false);
    end;
	setVisibility(self.digitLiftHeightTwo[self.numDigitLiftHeightTwo].rotNode,true);
	
	-- Digital Display digits LiftHeight lights
	self.numDigitLiftHeightOneLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitLiftHeightOneLight#count"), 0);
	self.digitLiftHeightOneLight = {};
    for i=1, self.numDigitLiftHeightOneLight do
        local objname = string.format("vehicle.displayDigitLiftHeightOneLight.digitLiftHeight" .. "%d", i);
		self.digitLiftHeightOneLight[i] = {};
        self.digitLiftHeightOneLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitLiftHeightOneLight[i].rotNode,false);
    end;
	setVisibility(self.digitLiftHeightOneLight[self.numDigitLiftHeightOneLight].rotNode,true);
	
	self.numDigitLiftHeightTwoLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitLiftHeightTwoLight#count"), 0);
	self.digitLiftHeightTwoLight = {};
    for i=1, self.numDigitLiftHeightTwoLight do
        local objname = string.format("vehicle.displayDigitLiftHeightTwoLight.digitLiftHeight" .. "%d", i);
		self.digitLiftHeightTwoLight[i] = {};
        self.digitLiftHeightTwoLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitLiftHeightTwoLight[i].rotNode,false);
    end;
	setVisibility(self.digitLiftHeightTwoLight[self.numDigitLiftHeightTwoLight].rotNode,true);
	
	-- Root display nodes
	self.displayStatusRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displayStatusRootNode#index"));
	self.displayStatusRootNodeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displayStatusRootNodeLight#index"));
	setVisibility(self.displayStatusRootNode,true);
	setVisibility(self.displayStatusRootNodeLight,false);
	
	self.displayRPMRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displayRPMRootNode#index"));	
	self.displayRPMRootNodeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displayRPMRootNodeLight#index"));
	setVisibility(self.displayRPMRootNode,true);
	setVisibility(self.displayRPMRootNodeLight,false);	
	
	self.displayLiftRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displayLiftRootNode#index"));
	self.displayLiftRootNodeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displayLiftRootNodeLight#index"));
	setVisibility(self.displayLiftRootNode,true);
	setVisibility(self.displayLiftRootNodeLight,false);
	
	self.displayValue = 0;
	self.prevousDigitRPMFour = self.numDigitRPMFour;
	self.prevousDigitRPMThree = self.numDigitRPMThree;
	self.prevousDigitRPMTwo = self.numDigitRPMTwo;
	self.prevousDigitRPMOne = 0;
	
	self.prevousDigitSPEEDFour = self.numDigitSPEEDFour;
	self.prevousDigitSPEEDThree = self.numDigitSPEEDThree;
	self.prevousDigitSPEEDTwo = self.numDigitSPEEDTwo;
	self.prevousDigitSPEEDOne = 0;
	
	self.prevousDigitLiftHeightTwo = self.numDigitLiftHeightTwo;
	self.prevousDigitLiftHeightOne = 0;
	
	self.cycleRoundMax = 20;
	self.currentCycle = 0;
	self.lastRpm = 0;
	
	self.displayMode = 2;
end;

function digitalDisplay:delete()
end;

function digitalDisplay:mouseEvent(posX, posY, isDown, isUp, button)
end;

function digitalDisplay:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_m then
		if self.displayMode < 2 then
			self.displayMode = self.displayMode + 1;
		else
			self.displayMode = 1;
		end;
	end;
end;

function digitalDisplay:update(dt)
	--Turn on lights display
	if not self.lightsActive then
		setVisibility(self.displayStatusRootNode,true);
		setVisibility(self.displayRPMRootNode,true);
		setVisibility(self.displayLiftRootNode,true);
		setVisibility(self.displayStatusRootNodeLight,false);
		setVisibility(self.displayRPMRootNodeLight,false);
		setVisibility(self.displayLiftRootNodeLight,false);
	else
		setVisibility(self.displayStatusRootNode,false);
		setVisibility(self.displayRPMRootNode,false);
		setVisibility(self.displayLiftRootNode,false);
		setVisibility(self.displayStatusRootNodeLight,true);
		setVisibility(self.displayRPMRootNodeLight,true);
		setVisibility(self.displayLiftRootNodeLight,true);
	end;
	
	-- Digital Display handling RPM
	if self.isEntered then
		--setVisibility(self.digitRPMTwo[1].rotNode,false);
		--if self.displaySelectorMode == 0 then
		if self.isMotorStarted then
			if self.currentCycle < self.cycleRoundMax then
				self.currentCycle = self.currentCycle + 1;
				self.currentRPM = self.motor.lastMotorRpm;
				if self.rpmMeterValue ~= nil then
					self.currentRPM = self.rpmMeterValue;
				end;
				self.lastRpm = math.floor((self.lastRpm + self.currentRPM)/2);
			else
				self.currentCycle = 0;
				self.displayValue = self.lastRpm;
			end;
		else
			self.displayValue = 0;
		end;
		
		--end;
		local displayValue = self.displayValue;
		
		--if self.displaySelectorMode == 1 then
			--displayValue = math.floor(displayValue);
		--end;

		-- Handle the digitRPMs in the display
		if self.isMotorStarted then
			local thousends = math.floor(displayValue/1000);
			local displayIndex = thousends;
			if self.prevousDigitRPMFour ~= thousends then
				if self.prevousDigitRPMFour > 0 then
					setVisibility(self.digitRPMFour[self.prevousDigitRPMFour].rotNode,false);
					setVisibility(self.digitRPMFourLight[self.prevousDigitRPMFour].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = self.numDigitRPMFour; 
				end;
				setVisibility(self.digitRPMFour[displayIndex].rotNode,true);
				setVisibility(self.digitRPMFourLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitRPMFour = displayIndex;
				
			displayValue = displayValue - thousends * 1000;
			local hundreds = math.floor(displayValue/100);
			displayIndex = hundreds;
			if self.prevousDigitRPMThree ~= hundreds then
				if self.prevousDigitRPMThree > 0 then
					setVisibility(self.digitRPMThree[self.prevousDigitRPMThree].rotNode,false);
					setVisibility(self.digitRPMThreeLight[self.prevousDigitRPMThree].rotNode,false);
				end;
				if displayIndex == 0 and thousends == 0 then
					displayIndex = self.numDigitRPMThree;
				elseif displayIndex == 0 then 
					if thousends > 0 then
						displayIndex = 10;
					end;
				end;
				setVisibility(self.digitRPMThree[displayIndex].rotNode,true);
				setVisibility(self.digitRPMThreeLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitRPMThree = displayIndex;
			
			displayValue = displayValue - hundreds * 100;
			local tens = math.floor(displayValue/10);
			displayIndex = tens;
			if self.prevousDigitRPMTwo ~= tens then
				if self.prevousDigitRPMTwo > 0 then
					setVisibility(self.digitRPMTwo[self.prevousDigitRPMTwo].rotNode,false);
					setVisibility(self.digitRPMTwoLight[self.prevousDigitRPMTwo].rotNode,false);
				end;
				if displayIndex == 0 and hundreds == 0 then
					displayIndex = self.numDigitRPMTwo;
				elseif displayIndex == 0 then 
					if hundreds > 0 or thousends > 0 then
						displayIndex = 10;
					end;
				end;
				setVisibility(self.digitRPMTwo[displayIndex].rotNode,true);
				setVisibility(self.digitRPMTwoLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitRPMTwo = displayIndex;
			
			displayValue = displayValue - tens * 10;
			local ones = math.floor(displayValue);
			displayIndex = 10;
			if self.prevousDigitRPMOne ~= ones then
				if self.prevousDigitRPMOne > 0 then
					setVisibility(self.digitRPMOne[displayIndex+1].rotNode,false);
					setVisibility(self.digitRPMOneLight[displayIndex+1].rotNode,false);
				end;

				if displayIndex == 0 then
					displayIndex = 10;
				end;
				--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
				setVisibility(self.digitRPMOne[displayIndex].rotNode,true);
				setVisibility(self.digitRPMOneLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitRPMOne = displayIndex;
			self.rpmDisplaysSetOff = false;
		else
			if not self.rpmDisplaysSetOff then
				for i=1, self.numDigitRPMOne do
					setVisibility(self.digitRPMOne[i].rotNode,false);
				end;
		
				for i=1, self.numDigitRPMTwo do
					setVisibility(self.digitRPMTwo[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMThree do
					setVisibility(self.digitRPMThree[i].rotNode,false);
				end;
		
				for i=1, self.numDigitRPMFour do
					setVisibility(self.digitRPMFour[i].rotNode,false);
				end;
				
				for i=1, self.numDigitRPMOneLight do
					setVisibility(self.digitRPMOneLight[i].rotNode,false);
				end;
		
				for i=1, self.numDigitRPMTwoLight do
					setVisibility(self.digitRPMTwoLight[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMThreeLight do
					setVisibility(self.digitRPMThreeLight[i].rotNode,false);
				end;
		
				for i=1, self.numDigitRPMFourLight do
					setVisibility(self.digitRPMFourLight[i].rotNode,false);
				end;
				
				self.rpmDisplaysSetOff = true;
			end;
		end;
	end;
	
	-- Digital Display handling Speed
	if self.isEntered then
		--if self.displaySelectorMode == 0 then
		
		--end;
		local displayValueSpeed = 0;
		
		if self.displayMode == 1 then 
			displayValueSpeed = math.floor(self.lastSpeed * 3600 * 100);
			displayValueSpeed = displayValueSpeed/10;
		elseif self.displayMode == 2 then
			if self.actualRotorSpeedValue ~= nil then
				displayValueSpeed = self.actualRotorSpeedValue;
			end;
		end;
		
		--if self.displaySelectorMode == 1 then
			--displayValueSpeed = math.floor(displayValueSpeed);
		--end;

		-- Handle the digitSPEEDs in the display
		if self.isMotorStarted then
			if self.displayMode == 1 then
				setVisibility(self.digitSPEEDTwo[11].rotNode,true);
				setVisibility(self.digitSPEEDTwoLight[11].rotNode,true);
			else
				setVisibility(self.digitSPEEDTwo[11].rotNode,false);
				setVisibility(self.digitSPEEDTwoLight[11].rotNode,false);
			end;
			
			local thousends = math.floor(displayValueSpeed/1000);
			local displayIndex = thousends;
			if self.prevousDigitSPEEDFour ~= thousends then
				if self.prevousDigitSPEEDFour > 0 then
					setVisibility(self.digitSPEEDFour[self.prevousDigitSPEEDFour].rotNode,false);
					setVisibility(self.digitSPEEDFourLight[self.prevousDigitSPEEDFour].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = self.numDigitSPEEDFour; 
				end;
				setVisibility(self.digitSPEEDFour[displayIndex].rotNode,true);
				setVisibility(self.digitSPEEDFourLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitSPEEDFour = displayIndex;
				
			displayValueSpeed = displayValueSpeed - thousends * 1000;
			local hundreds = math.floor(displayValueSpeed/100);
			displayIndex = hundreds;
			if self.prevousDigitSPEEDThree ~= hundreds then
				if self.prevousDigitSPEEDThree > 0 then
					setVisibility(self.digitSPEEDThree[self.prevousDigitSPEEDThree].rotNode,false);
					setVisibility(self.digitSPEEDThreeLight[self.prevousDigitSPEEDThree].rotNode,false);
				end;
				if displayIndex == 0 and thousends == 0 then
					displayIndex = self.numDigitSPEEDThree;
				elseif displayIndex == 0 then 
					if thousends > 0 then
						displayIndex = 10;
					end;
				end;
				setVisibility(self.digitSPEEDThree[displayIndex].rotNode,true);
				setVisibility(self.digitSPEEDThreeLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitSPEEDThree = displayIndex;
			
			displayValueSpeed = displayValueSpeed - hundreds * 100;
			local tens = math.floor(displayValueSpeed/10);
			displayIndex = tens;
			if self.prevousDigitSPEEDTwo ~= tens then
				if self.prevousDigitSPEEDTwo > 0 then
					setVisibility(self.digitSPEEDTwo[self.prevousDigitSPEEDTwo].rotNode,false);
					setVisibility(self.digitSPEEDTwoLight[self.prevousDigitSPEEDTwo].rotNode,false);
				end;
				if displayIndex == 0 and hundreds == 0 then
					displayIndex = 10;
				elseif displayIndex == 0 then 
					if hundreds > 0 or thousends > 0 then
						displayIndex = 10;
					end;
				end;
				setVisibility(self.digitSPEEDTwo[displayIndex].rotNode,true);
				setVisibility(self.digitSPEEDTwoLight[displayIndex].rotNode,true);
			end;
			--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
			self.prevousDigitSPEEDTwo = displayIndex;
			
			displayValueSpeed = displayValueSpeed - tens * 10;
			local ones = math.floor(displayValueSpeed);
			displayIndex = ones;
			if self.prevousDigitSPEEDOne ~= ones then
				if self.prevousDigitSPEEDOne > 0 then
					setVisibility(self.digitSPEEDOne[self.prevousDigitSPEEDOne].rotNode,false);
					setVisibility(self.digitSPEEDOneLight[self.prevousDigitSPEEDOne].rotNode,false);
				end;

				if displayIndex == 0 then
					displayIndex = 10;
				end;
				--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
				setVisibility(self.digitSPEEDOne[displayIndex].rotNode,true);
				setVisibility(self.digitSPEEDOneLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitSPEEDOne = displayIndex;
			self.speedDisplaysSetOff = false;
		else
			if not self.speedDisplaysSetOff then
				for i=1, self.numDigitSPEEDOne do
					setVisibility(self.digitSPEEDOne[i].rotNode,false);
				end;
		
				for i=1, self.numDigitSPEEDTwo do
					setVisibility(self.digitSPEEDTwo[i].rotNode,false);
				end;

				for i=1, self.numDigitSPEEDThree do
					setVisibility(self.digitSPEEDThree[i].rotNode,false);
				end;
		
				for i=1, self.numDigitSPEEDFour do
					setVisibility(self.digitSPEEDFour[i].rotNode,false);
				end;
				
				for i=1, self.numDigitSPEEDOneLight do
					setVisibility(self.digitSPEEDOneLight[i].rotNode,false);
				end;
		
				for i=1, self.numDigitSPEEDTwoLight do
					setVisibility(self.digitSPEEDTwoLight[i].rotNode,false);
				end;

				for i=1, self.numDigitSPEEDThreeLight do
					setVisibility(self.digitSPEEDThreeLight[i].rotNode,false);
				end;
		
				for i=1, self.numDigitSPEEDFourLight do
					setVisibility(self.digitSPEEDFourLight[i].rotNode,false);
				end;
				self.speedDisplaysSetOff = true;
			end;
		end;
	end;
	
	-- Digital Display handling Lift display
	if self.isEntered and self.lastAttacherRotation ~= nil then
		local displayValue = 0
		if self.isMotorStarted then
			displayValue = 36 - ((self.lastAttacherRotation/3.14)*180);
		else
			displayValue = 0;
		end;
		
		--if self.displaySelectorMode == 1 then
			--displayValue = math.floor(displayValue);
		--end;

		-- Handle the digitRPMs in the display
		--renderText(0.5, 0.65, 0.040, string.format(displayValue));
		if self.isMotorStarted then
			local tens = math.floor(displayValue/10);
			displayIndex = tens;
			if self.prevousDigitLiftHeightTwo ~= tens then
				if self.prevousDigitLiftHeightTwo > 0 then
					setVisibility(self.digitLiftHeightTwo[self.prevousDigitLiftHeightTwo].rotNode,false);
					setVisibility(self.digitLiftHeightTwoLight[self.prevousDigitLiftHeightTwo].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = self.numDigitLiftHeightTwo;
				end;
				setVisibility(self.digitLiftHeightTwo[displayIndex].rotNode,true);
				setVisibility(self.digitLiftHeightTwoLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitLiftHeightTwo = displayIndex;
			displayValue = displayValue - tens * 10;
			--renderText(0.5, 0.55, 0.040, string.format(displayValue));
			local ones = math.floor(displayValue);
			--renderText(0.5, 0.45, 0.040, string.format(ones));
			displayIndex = ones;
			if self.prevousDigitLiftHeightOne ~= ones then
				if self.prevousDigitLiftHeightOne > 0 then
					setVisibility(self.digitLiftHeightOne[self.prevousDigitLiftHeightOne].rotNode,false);
					setVisibility(self.digitLiftHeightOneLight[self.prevousDigitLiftHeightOne].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = 10;
				end;
				--renderText(0.5, 0.35, 0.040, string.format(displayIndex));
				setVisibility(self.digitLiftHeightOne[displayIndex].rotNode,true);
				setVisibility(self.digitLiftHeightOneLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitLiftHeightOne = displayIndex;
			self.LiftHeightDisplaysSetOff = false;
		else
			if not self.LiftHeightDisplaysSetOff then
				for i=1, self.numDigitLiftHeightOne do
					setVisibility(self.digitLiftHeightOne[i].rotNode,false);
				end;
		
				for i=1, self.numDigitLiftHeightTwo do
					setVisibility(self.digitLiftHeightTwo[i].rotNode,false);
				end;
				
				for i=1, self.numDigitLiftHeightOneLight do
					setVisibility(self.digitLiftHeightOneLight[i].rotNode,false);
				end;
		
				for i=1, self.numDigitLiftHeightTwoLight do
					setVisibility(self.digitLiftHeightTwoLight[i].rotNode,false);
				end;
				
				self.LiftHeightDisplaysSetOff = true;
			end;
		end;
	end;
end;

function digitalDisplay:draw()
end;
