--
-- Breakdown 
-- Specialization for combine - Allows a combine to breakdown ( engine failure ) and be repaired.
--
-- @author  Bayn - www.tsforum3.com
-- @date  14/07/09

-- @edit by Knagsted
-- @date  16/07/10
--

Breakdown = {};

function Breakdown.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function Breakdown:load(xmlFile)
	
	
	------------------------------------------
	------ Keys ------------
	------------------------------------------


	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	

	
   -- Panel movements --
	
	local rotationNodePanel1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPanel1#index"));
    if rotationNodePanel1 ~= nil then
        self.rotationPanel1 = {};
        self.rotationPanel1.node = rotationNodePanel1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPanel1#minRot"));
        self.rotationPanel1.minRot = {};
        self.rotationPanel1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPanel1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPanel1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPanel1#maxRot"));
        self.rotationPanel1.maxRot = {};
        self.rotationPanel1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPanel1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPanel1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPanel1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPanel1#rotTime"), 2)*1000;
        self.rotationPanel1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPanel1#touchRotLimit"), 10));
    end; 	
  
	local rotationNodePanel2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPanel2#index"));
    if rotationNodePanel2 ~= nil then
        self.rotationPanel2 = {};
        self.rotationPanel2.node = rotationNodePanel2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPanel2#minRot"));
        self.rotationPanel2.minRot = {};
        self.rotationPanel2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPanel2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPanel2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPanel2#maxRot"));
        self.rotationPanel2.maxRot = {};
        self.rotationPanel2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPanel2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPanel2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPanel2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPanel2#rotTime"), 2)*1000;
        self.rotationPanel2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPanel2#touchRotLimit"), 10));
    end; 

	local rotationNodePanel3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPanel3#index"));
    if rotationNodePanel3 ~= nil then
        self.rotationPanel3 = {};
        self.rotationPanel3.node = rotationNodePanel3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPanel3#minRot"));
        self.rotationPanel3.minRot = {};
        self.rotationPanel3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPanel3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPanel3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPanel3#maxRot"));
        self.rotationPanel3.maxRot = {};
        self.rotationPanel3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPanel3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPanel3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPanel3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPanel3#rotTime"), 2)*1000;
        self.rotationPanel3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPanel3#touchRotLimit"), 10));
    end; 	
	
	local rotationNodeEchellePanel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationEchellePanel#index"));
    if rotationNodeEchellePanel ~= nil then
        self.rotationEchellePanel = {};
        self.rotationEchellePanel.node = rotationNodeEchellePanel;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchellePanel#minRot"));
        self.rotationEchellePanel.minRot = {};
        self.rotationEchellePanel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchellePanel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchellePanel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchellePanel#maxRot"));
        self.rotationEchellePanel.maxRot = {};
        self.rotationEchellePanel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchellePanel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchellePanel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEchellePanel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchellePanel#rotTime"), 2)*1000;
        self.rotationEchellePanel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchellePanel#touchRotLimit"), 10));
    end;
	
	local rotationNodeSafetyBoom = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationSafetyBoom#index"));
    if rotationNodeSafetyBoom ~= nil then
        self.rotationSafetyBoom = {};
        self.rotationSafetyBoom.node = rotationNodeSafetyBoom;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSafetyBoom#minRot"));
        self.rotationSafetyBoom.minRot = {};
        self.rotationSafetyBoom.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSafetyBoom.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSafetyBoom.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSafetyBoom#maxRot"));
        self.rotationSafetyBoom.maxRot = {};
        self.rotationSafetyBoom.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSafetyBoom.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSafetyBoom.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationSafetyBoom.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSafetyBoom#rotTime"), 2)*1000;
        self.rotationSafetyBoom.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSafetyBoom#touchRotLimit"), 10));
    end; 
	
	local rotationNodeSafetyBoomHolder = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationSafetyBoomHolder#index"));
    if rotationNodeSafetyBoomHolder ~= nil then
        self.rotationSafetyBoomHolder = {};
        self.rotationSafetyBoomHolder.node = rotationNodeSafetyBoomHolder;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSafetyBoomHolder#minRot"));
        self.rotationSafetyBoomHolder.minRot = {};
        self.rotationSafetyBoomHolder.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSafetyBoomHolder.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSafetyBoomHolder.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSafetyBoomHolder#maxRot"));
        self.rotationSafetyBoomHolder.maxRot = {};
        self.rotationSafetyBoomHolder.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSafetyBoomHolder.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSafetyBoomHolder.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationSafetyBoomHolder.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSafetyBoomHolder#rotTime"), 2)*1000;
        self.rotationSafetyBoomHolder.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSafetyBoomHolder#touchRotLimit"), 10));
    end;

	local safetyBoomHolderIndicator = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.safetyBoomHolderIndicator#index"));
	if safetyBoomHolderIndicator ~= nil then
		self.safetyBoomHolderIndicator = {};
		self.safetyBoomHolderIndicator.node = safetyBoomHolderIndicator;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.safetyBoomHolderIndicator#minTranslation"));
		self.safetyBoomHolderIndicator.minTranslation = {};
		self.safetyBoomHolderIndicator.minTranslation[1] = x;
		self.safetyBoomHolderIndicator.minTranslation[2] = y;	
		self.safetyBoomHolderIndicator.minTranslation[3] = z;

		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.safetyBoomHolderIndicator#maxTranslation"));
		self.safetyBoomHolderIndicator.maxTranslation = {};
		self.safetyBoomHolderIndicator.maxTranslation[1] = x;
		self.safetyBoomHolderIndicator.maxTranslation[2] = y;	
		self.safetyBoomHolderIndicator.maxTranslation[3] = z;

        self.safetyBoomHolderIndicator.translationTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.safetyBoomHolderIndicator#translationTime"), 2)*1000;
        self.safetyBoomHolderIndicator.touchTransLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.safetyBoomHolderIndicator#touchTransLimit"), 10));		
	end;
	
	-- Sounds --
	
    BreakdownSoundFile = Utils.getFilename("Sounds/Breakdown.ogg", self.baseDirectory);
    self.BreakdownSoundId = createSample("BreakdownSound");
    loadSample(self.BreakdownSoundId, BreakdownSoundFile, false);
    self.BreakdownPlaying = false;
	
    FixingSoundFile = Utils.getFilename("Sounds/wrench.wav", self.baseDirectory);
    self.FixingSoundId = createSample("FixingSound");
    loadSample(self.FixingSoundId, FixingSoundFile, false);
    self.FixingPlaying = false;
	
    StairsSoundFile = Utils.getFilename("Sounds/stairs.wav", self.baseDirectory);
    self.StairsSoundId = createSample("StairsSound");
    loadSample(self.StairsSoundId, StairsSoundFile, false);
    self.StairsPlaying = false;
	
	
	-- Generating a random number --
	self.RandomNumber = math.random(2,30);	
	--print ("nombre:" , self.RandomNumber);

	self.AuthorizeBreakdown = true;
	self.BreakdownLights = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BreakdownLights#index"));
    self.maintenanceStairsInRange = false;
	self.Panels = false;
	self.servicePrice = 0;
	self.awaitingFixingAck = false;
	self.servicePrice = math.random(200,1500);
end;

function Breakdown:delete()

    if self.BreakdownSoundId ~= nil then
        stopSample(self.BreakdownSoundId);
    end;
    if self.FixingSoundId ~= nil then
        stopSample(self.FixingSoundId);
    end;
    if self.StairsSoundId ~= nil then
        stopSample(self.StairsSoundId);
    end;	
end;

function Breakdown:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Breakdown:keyEvent(unicode, sym, modifier, isDown)


		--if isDown and sym == self.keys.Panneaux then
			--self.Panels = not self.Panels;
		--end
end;

function Breakdown:update(dt)

	--manual fixing.
	local nearestDistance = 3.0; --max distance allowed
	local px, py, pz = getWorldTranslation(self.rotationEchellePanel.node); --self.Helice1 is one of the spereaders
	local vx, vy, vz = getWorldTranslation(getCamera());
	if vx ~= nil and  vy ~= nil and vz ~= nil then
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.maintenanceStairsInRange = true; --farmer is in range
		else
			self.maintenanceStairsInRange = false; --farmer is not in range
		end;
	end;
	
	if self.maintenanceStairsInRange then
		if not self.Panels then
			g_currentMission:addExtraPrintText(string.format("%s: Deplier Echelle Entretien", InputBinding.getKeyNamesOfDigitalAction(InputBinding.MAINTENANCELADDER)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: Replier Echelle Entretien", InputBinding.getKeyNamesOfDigitalAction(InputBinding.MAINTENANCELADDER)));
			g_currentMission:addExtraPrintText(string.format("%s: Effectuer Entretien", InputBinding.getKeyNamesOfDigitalAction(InputBinding.FIXCOMBINE)));
		end;
	end;
	
	if InputBinding.hasEvent(InputBinding.FIXCOMBINE) then
		if 	self.maintenanceStairsInRange and self.Panels then
			--if Player:getIsActiveForSound() then
			self.awaitingFixingAck = true;
			--end;
		end;
	end;
	
	if InputBinding.hasEvent(InputBinding.ACKNOWLEDGE) then
		if self.awaitingFixingAck then
			self.awaitingFixingAck = false;
			self.Breakdown = false;
			self.AuthorizeBreakdown = true;
			self.RandomNumber = self.RandomNumber + math.random(10,30);
			if not self.FixingPlaying then
				playSample(self.FixingSoundId, 1, 1, 0);
			end;
			--Fixing costs money!!!
            g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + self.servicePrice;
            g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + self.servicePrice;

            g_currentMission.missionStats.money = g_currentMission.missionStats.money - self.servicePrice;
			self.servicePrice = math.random(200,1500);
		end;
	end;
	
	if InputBinding.hasEvent(InputBinding.DECLINE) then
		if self.awaitingFixingAck then
			self.awaitingFixingAck = false;
		end;
	end;

	if self.awaitingFixingAck then
		setTextColor(1, 0, 0, 1.0);
		renderText(0.25, 0.5, 0.03, string.format("Le Service Entretien coûte: " ..self.servicePrice.. " Euro? Y/N"));
	end;
	
	if InputBinding.hasEvent(InputBinding.MAINTENANCELADDER) then
		if 	self.maintenanceStairsInRange then
			self.Panels = not self.Panels;
			--if Player:getIsActiveForSound() then
				if not self.FixingPlaying then
					playSample(self.StairsSoundId, 1, 1, 0);
				end;
			--end;
		end;
	end;
	
	--renderText(0.5, 0.5, 0.020, string.format("%d ",self.RandomNumber));
	
	
	-- Manual fixing done
    	
		-- Movements --
	
	local doRotate = self.rotationPanel1Max or self.rotationPanel1Min 
	if self.rotationPanel1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPanel1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPanel1.maxRot, self.rotationPanel1.minRot, 3, self.rotationPanel1.rotTime, dt, not self.rotationPanel1Max);
        setRotation(self.rotationPanel1.node, unpack(newRot));
    end;	
	
	local doRotate = self.rotationPanel2Max or self.rotationPanel2Min 
	if self.rotationPanel2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPanel2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPanel2.maxRot, self.rotationPanel2.minRot, 3, self.rotationPanel2.rotTime, dt, not self.rotationPanel2Max);
        setRotation(self.rotationPanel2.node, unpack(newRot));
    end;	
	
	local doRotate = self.rotationPanel3Max or self.rotationPanel3Min 
	if self.rotationPanel3 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPanel3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPanel3.maxRot, self.rotationPanel3.minRot, 3, self.rotationPanel3.rotTime, dt, not self.rotationPanel3Max);
        setRotation(self.rotationPanel3.node, unpack(newRot));
    end;

	local doRotate = self.rotationEchellePanelMax or self.rotationEchellePanelMin 
	if self.rotationEchellePanel ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationEchellePanel.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationEchellePanel.maxRot, self.rotationEchellePanel.minRot, 3, self.rotationEchellePanel.rotTime, dt, not self.rotationEchellePanelMax);
        setRotation(self.rotationEchellePanel.node, unpack(newRot));
    end;

	--local doRotate = self.rotationSafetyBoomMax or self.rotationSafetyBoomMin
	if self.rotationSafetyBoomHolder ~= nil then
		local ax, ay, az = getWorldTranslation(self.safetyBoomHolderIndicator.node);
		local bx, by, bz = getWorldTranslation(self.rotationSafetyBoomHolder.node);

		local x, y, z = worldDirectionToLocal(getParent(self.rotationSafetyBoomHolder.node), bx-ax, by-ay, bz-az);
		setDirection(self.rotationSafetyBoomHolder.node, x, y, z, 0, 1, 0);
		
		--local x2,y2,z2 = getRotation(self.rotationSafetyBoomHolder.node);
		--setRotation(self.rotationSafetyBoomHolder.node,Utils.degToRad(22.5)+x2,0,0);
    end;

	local doRotate = self.rotationSafetyBoomMax or self.rotationSafetyBoomMin
	if self.rotationSafetyBoom ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationSafetyBoom.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationSafetyBoom.maxRot, self.rotationSafetyBoom.minRot, 3, self.rotationSafetyBoom.rotTime, dt, not self.rotationSafetyBoomMax);
        setRotation(self.rotationSafetyBoom.node, unpack(newRot));
    end;
	
	if self.safetyBoomHolderIndicator ~= nil and self.safetyBoomHolderIndicator.node ~= nil then
		local x, y, z = getTranslation(self.safetyBoomHolderIndicator.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.safetyBoomHolderIndicator.maxTranslation, self.safetyBoomHolderIndicator.minTranslation, 3, self.safetyBoomHolderIndicator.translationTime, dt, not self.rotationSafetyBoomHandleMax);
        setTranslation(self.safetyBoomHolderIndicator.node, unpack(newTrans));
	end;
	-- Panels Movements --
	
	if self.Panels then
		self.rotationPanel1Max = true;
		self.rotationPanel2Max = true;
		self.rotationPanel3Max = true;	
		self.rotationEchellePanelMax = true;
		self.rotationSafetyBoomMax = true;
		self.rotationSafetyBoomHandleMax = true;			
		self.rotationPanel1Min = false;
		self.rotationPanel2Min = false;
		self.rotationPanel3Min = false;
		self.rotationEchellePanelMin = false;
		self.rotationSafetyBoomMin = false;
		self.rotationSafetyBoomHandleMin = false;	
		--self.AuthorizeBreakdown = false;

	else
		self.rotationPanel1Max = false;
		self.rotationPanel2Max = false;
		self.rotationPanel3Max = false;
		self.rotationEchellePanelMax = false;
		self.rotationSafetyBoomMax = false;
		self.rotationSafetyBoomHandleMax = false;	
		self.rotationPanel1Min = true;
		self.rotationPanel2Min = true;
		self.rotationPanel3Min = true;
		self.rotationEchellePanelMin = true;
		self.rotationSafetyBoomMin = true;
		self.rotationSafetyBoomHandleMin = true;	
	end;
		

	
	-- Breakdown OFF : open the panel if HectarTreshed == random number -- 
	
	
	if g_currentMission.missionStats.hectaresThreshedSession >= self.RandomNumber then
		self.Breakdown = true;
	end;
	
	if self.AuthorizeBreakdown and self.Breakdown then
		
		-- stopTreshing --
			self.isThreshingStarted = false;
			self.playThreshingSound = false;
			
			if self.isHired then
				WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, 0, false, 0);
			end;
			
			if self.isEntered then
				setTextColor(1, 0, 0, 1.0);
				renderText(0.3, 0.5, 0.04, string.format("Moissonneuse en panne - Sortez et faites l'entretien !"));
			end;

			if self.threshingSound ~= nil then
				stopSample(self.threshingSound);
			end;

			if self.threshingStopSound ~= nil and self.threshingSoundActive and self:getIsActiveForSound() then
				setSamplePitch(self.threshingStopSound, self.threshingStopSoundPitchOffset);
				playSample(self.threshingStopSound, 1, 1, 0);
				self.threshingSoundActive = false;
			end;

			self.chopperActivated = false;
			self.isThreshing = false;
			for cutter,implement in pairs(self.attachedCutters) do
				local jointDesc = self.attacherJoints[implement.jointDescIndex];
				jointDesc.moveDown = false;

				cutter:onStopReel();
			end;
			
			if self.currentStrawParticleSystem ~= nil then
                Utils.setEmittingState(self.currentStrawParticleSystem, false);
            end;
		-- Display warning lights --
			setVisibility(self.BreakdownLights, true);
		-- Play Sound --
		if self:getIsActiveForSound() then
			if not self.BreakdownPlaying then
				playSample(self.BreakdownSoundId, 1, 1, 0);
				self.BreakdownPlaying = true;
			end;
        end;
	else
			setVisibility(self.BreakdownLights, false);
			if self.BreakdownPlaying then
				stopSample(self.BreakdownSoundId);
				self.BreakdownPlaying = false;
			end;
	end;

	
end;

function Breakdown:onLeave()
end;

function Breakdown:onEnter()
end;

function Breakdown:draw()
end;
