--
-- Straw Specialization for Combines
--
-- @author  Templaer
-- @date  24/05/09

-- @edit by Knagsted
-- @date  16/07/10


strawSpec = {};

function strawSpec.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function strawSpec:load(xmlFile)
    -- Backup of Chopper Blind
    self.backupChopperBlind = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperBlind#index"));

    -- Straw Active Boolean
    self.strawActive = false;
end;

function strawSpec:delete()
end;

function strawSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function strawSpec:keyEvent(unicode, sym, modifier, isDown)
	--[[if self:getIsActiveForInput() and self.isEntered then
		if InputBinding.isPressed(InputBinding.JDTSTRAW_TOGGLE) then
			self.strawActive = not self.strawActive;
		end;
	end;]]
end;

function strawSpec:update(dt)
			self.strawActive = not self.strawShreaderMounted;
			
			if self:getIsActive() then
				
				-- Check if straw is enabled
				if not self.strawActive then
					self.strawEmitState = false;
					self.strawEnableTime = nil;
					self.chopperActivated = true;
					self.chopperBlind = nil;
					
					-- Lower the chopper
					local chopperBlindRotationSpeed = 0.001;
					local minRotX = -83*3.1415/180.0;
					
					if self.backupChopperBlind ~= nil then
						local x,y,z = getRotation(self.backupChopperBlind);
					
						x = x-dt*chopperBlindRotationSpeed;
						if x < minRotX then
							x = minRotX;
						end;
						setRotation(self.backupChopperBlind, x, y, z);
					end;
							
					-- Enable chopper particle system					
					if self.lastArea > 0  then
						if self.chopperActivated then
							if self.chopperEnableTime == nil then
								self.chopperEnableTime = self.time + self.chopperToggleTime;
							else
								self.chopperDisableTime = nil;
							end;
							disableChopperEmit = false;
						end;
					
						-- Chopper starting delay
						if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
					
							self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
					
							if self.currentChopperParticleSystem == nil then
								self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
							end;
							Utils.setEmittingState(self.currentChopperParticleSystem, true);
						end;
					end;
					
					-- Disable the particleSystem when combine is full
					if self.grainTankFillLevel == self.grainTankCapacity then
						Utils.setEmittingState(self.currentChopperParticleSystem, false);
					end;
					
					if not self.isThreshing then
						Utils.setEmittingState(self.currentChopperParticleSystem, false);
					end;
					
					if self.ignitionKey ~= nil then
						if not self.ignitionKey then
							Utils.setEmittingState(self.currentChopperParticleSystem, false);
						end;
					end;
					
					
				elseif self.strawActive then
					self.chopperBlind = self.backupChopperBlind;
					self.currentStrawParticleSystem = self.strawParticleSystems[self.currentGrainTankFruitType];
				end;
			else
				if self.currentChopperParticleSystem  ~= nil then
					Utils.setEmittingState(self.currentChopperParticleSystem, false);
				end;
				if self.currentChopperParticleSystem  ~= nil then
					Utils.setEmittingState(self.currentStrawParticleSystem, false);
				end;
			end;
end;

function strawSpec:draw()
end;
