--
-- CIH2388
-- Implementation of combine functions and leavers
-- 
-- @author Knagsted
-- @date  16/07/10
--
-- Thankyou to Bayn for allowing me to reuse parts from the JD 660 script in this implementation
--
-- Do not edit without my permission
--

CIH2388 = {};

function CIH2388.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function CIH2388:load(xmlFile)
	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

    self.lastGrainLevel = 0;

    self.pipeGrainParticleSystem = {};
    local i = 0;
	while true do
		local key = string.format("vehicle.pipeGrainParticleSystem.part%d", i);
	local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};
      local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, self.baseDirectory)
      self.pipeGrainParticleSystem[desc.index] = currentPS;
			if self.addDefaultpipeGrainParticleSystem == nil then
				self.addDefaultpipeGrainParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;

    self.pipeRapeParticleSystem = {};
    local i = 0;
	while true do
		local key = string.format("vehicle.pipeRapeParticleSystem.part%d", i);
	local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};
      local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, self.baseDirectory)
      self.pipeRapeParticleSystem[desc.index] = currentPS;
			if self.addDefaultpipeRapeParticleSystem == nil then
				self.addDefaultpipeRapeParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;

	self.extraPipeWheatParticleSystem = {};
    local i = 0;
	while true do
		local key = string.format("vehicle.extraPipeWheatParticleSystem.part%d", i);
	local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};
      local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, self.baseDirectory)
      self.extraPipeWheatParticleSystem[desc.index] = currentPS;
			if self.addDefaultextraPipeWheatParticleSystem == nil then
				self.addDefaultextraPipeWheatParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;

    self.extraPipeRapeParticleSystem = {};
    local i = 0;
	while true do
		local key = string.format("vehicle.extraPipeRapeParticleSystem.part%d", i);
	local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};
      local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, self.baseDirectory)
      self.extraPipeRapeParticleSystem[desc.index] = currentPS;
			if self.addDefaultextraPipeRapeParticleSystem == nil then
				self.addDefaultextraPipeRapeParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;

    self.strawSpreaderAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.strawSpreader#count"),0);
    self.strawSpreader = {};
    for i=1, self.strawSpreaderAnz do
        local objname = string.format("vehicle.strawSpreader.strawSpreader" .. "%d",i);
        self.strawSpreader[i] = {};
        self.strawSpreader[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.strawSpreader[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
    end;

    local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTanknadel2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#index"));
    if rotationPartNodeTanknadel2 ~= nil then
        self.rotationPartTanknadel2 = {};
        self.rotationPartTanknadel2.node = rotationPartNodeTanknadel2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#minRot"));
        self.rotationPartTanknadel2.minRot = {};
        self.rotationPartTanknadel2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#maxRot"));
        self.rotationPartTanknadel2.maxRot = {};
        self.rotationPartTanknadel2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#rotTime"), 2)*1000;
        self.rotationPartTanknadel2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeVoltnadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartVoltnadel#index"));
    if rotationPartNodeVoltnadel ~= nil then
        self.rotationPartVoltnadel = {};
        self.rotationPartVoltnadel.node = rotationPartNodeVoltnadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartVoltnadel#minRot"));
        self.rotationPartVoltnadel.minRot = {};
        self.rotationPartVoltnadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartVoltnadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartVoltnadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartVoltnadel#maxRot"));
        self.rotationPartVoltnadel.maxRot = {};
        self.rotationPartVoltnadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartVoltnadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartVoltnadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartVoltnadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartVoltnadel#rotTime"), 2)*1000;
        self.rotationPartVoltnadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartVoltnadel#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTempnadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTempnadel#index"));
    if rotationPartNodeTempnadel ~= nil then
        self.rotationPartTempnadel = {};
        self.rotationPartTempnadel.node = rotationPartNodeTempnadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTempnadel#minRot"));
        self.rotationPartTempnadel.minRot = {};
        self.rotationPartTempnadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTempnadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTempnadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTempnadel#maxRot"));
        self.rotationPartTempnadel.maxRot = {};
        self.rotationPartTempnadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTempnadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTempnadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTempnadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTempnadel#rotTime"), 2)*1000;
        self.rotationPartTempnadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTempnadel#touchRotLimit"), 10));
    end;
	
    self.incrementRotation = true;
    self.exhaustCover = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.exhaustCover#index"));
    if self.exhaustCover ~= nil then
        self.exhaustRotationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.exhaustCover#rotationSpeed"), 0);
	  self.exhaustRotationMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.exhaustCover#rotationMax"), 0);
	  self.exhaustRotationMin = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.exhaustCover#rotationMin"), 0);
	  self.currentRotation = self.exhaustRotationMin;
    end;
	
	self.fan = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fan#index"));
    self.fanRotation = 0;


  -- Steering Wheel movements --

local rotationNodeColonne = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationColonne#index"));
    if rotationNodeColonne ~= nil then
        self.rotationColonne = {};
        self.rotationColonne.node = rotationNodeColonne;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationColonne#minRot"));
        self.rotationColonne.minRot = {};
        self.rotationColonne.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationColonne.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationColonne.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationColonne#maxRot"));
        self.rotationColonne.maxRot = {};
        self.rotationColonne.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationColonne.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationColonne.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationColonne.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationColonne#rotTime"), 2)*1000;
        self.rotationColonne.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationColonne#touchRotLimit"), 10));
    end; 

	-- Ladder movements --
	
	local rotationNodeEchelle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationEchelle#index"));
    if rotationNodeEchelle ~= nil then
        self.rotationEchelle = {};
        self.rotationEchelle.node = rotationNodeEchelle;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchelle#minRot"));
        self.rotationEchelle.minRot = {};
        self.rotationEchelle.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchelle.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchelle.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchelle#maxRot"));
        self.rotationEchelle.maxRot = {};
        self.rotationEchelle.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchelle.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchelle.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEchelle.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchelle#rotTime"), 2)*1000;
        self.rotationEchelle.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchelle#touchRotLimit"), 10));
    end;

	-- Seperator movements -- 
		local seperatorPartNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seperatorPart1#index"));
    if seperatorPartNode1 ~= nil then
        self.seperatorPart1 = {};
        self.seperatorPart1.node = seperatorPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart1#minRot"));
        self.seperatorPart1.minRot = {};
        self.seperatorPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart1#maxRot"));
        self.seperatorPart1.maxRot = {};
        self.seperatorPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seperatorPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart1#rotTime"), 2);
        self.seperatorPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart1#touchRotLimit"), 10));
    end;
	
	local seperatorPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seperatorPart2#index"));
    if seperatorPartNode2 ~= nil then
        self.seperatorPart2 = {};
        self.seperatorPart2.node = seperatorPartNode2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart2#minRot"));
        self.seperatorPart2.minRot = {};
        self.seperatorPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart2#maxRot"));
        self.seperatorPart2.maxRot = {};
        self.seperatorPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seperatorPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart2#rotTime"), 2);
        self.seperatorPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart2#touchRotLimit"), 10));
    end;
	
	local seperatorPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seperatorPart3#index"));
    if seperatorPartNode3 ~= nil then
        self.seperatorPart3 = {};
        self.seperatorPart3.node = seperatorPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart3#minRot"));
        self.seperatorPart3.minRot = {};
        self.seperatorPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart3#maxRot"));
        self.seperatorPart3.maxRot = {};
        self.seperatorPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seperatorPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart3#rotTime"), 2);
        self.seperatorPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart3#touchRotLimit"), 10));
    end;
	
	local seperatorPartNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seperatorPart4#index"));
    if seperatorPartNode4 ~= nil then
        self.seperatorPart4 = {};
        self.seperatorPart4.node = seperatorPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart4#minRot"));
        self.seperatorPart4.minRot = {};
        self.seperatorPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart4#maxRot"));
        self.seperatorPart4.maxRot = {};
        self.seperatorPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seperatorPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart4#rotTime"), 2);
        self.seperatorPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart4#touchRotLimit"), 10));
    end;
	
	local seperatorPartNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seperatorPart5#index"));
    if seperatorPartNode5 ~= nil then
        self.seperatorPart5 = {};
        self.seperatorPart5.node = seperatorPartNode5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart5#minRot"));
        self.seperatorPart5.minRot = {};
        self.seperatorPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart5#maxRot"));
        self.seperatorPart5.maxRot = {};
        self.seperatorPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seperatorPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart5#rotTime"), 2);
        self.seperatorPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart5#touchRotLimit"), 10));
    end;
	
	
	local seperatorPartNode6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seperatorPart6#index"));
    if seperatorPartNode6 ~= nil then
        self.seperatorPart6 = {};
        self.seperatorPart6.node = seperatorPartNode6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart6#minRot"));
        self.seperatorPart6.minRot = {};
        self.seperatorPart6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seperatorPart6#maxRot"));
        self.seperatorPart6.maxRot = {};
        self.seperatorPart6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seperatorPart6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seperatorPart6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seperatorPart6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart6#rotTime"), 2);
        self.seperatorPart6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seperatorPart6#touchRotLimit"), 10));
    end;
	
	self.seperatorPart7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seperatorPart7#index"));
	
	--grain tank
		local rotationNodeTankLid1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationTankLid1#index"));
    if rotationNodeTankLid1 ~= nil then
        self.rotationTankLid1 = {};
        self.rotationTankLid1.node = rotationNodeTankLid1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTankLid1#minRot"));
        self.rotationTankLid1.minRot = {};
        self.rotationTankLid1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTankLid1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTankLid1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTankLid1#maxRot"));
        self.rotationTankLid1.maxRot = {};
        self.rotationTankLid1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTankLid1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTankLid1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationTankLid1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTankLid1#rotTime"), 2)*1000;
        self.rotationTankLid1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTankLid1#touchRotLimit"), 10));
    end; 	
  
	local rotationNodeTankLid2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationTankLid2#index"));
    if rotationNodeTankLid2 ~= nil then
        self.rotationTankLid2 = {};
        self.rotationTankLid2.node = rotationNodeTankLid2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTankLid2#minRot"));
        self.rotationTankLid2.minRot = {};
        self.rotationTankLid2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTankLid2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTankLid2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTankLid2#maxRot"));
        self.rotationTankLid2.maxRot = {};
        self.rotationTankLid2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTankLid2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTankLid2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationTankLid2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTankLid2#rotTime"), 2)*1000;
        self.rotationTankLid2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTankLid2#touchRotLimit"), 10));
    end; 
	
	local rotationNodeTankOpenHandle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationTankOpenHandle#index"));
    if rotationNodeTankOpenHandle ~= nil then
        self.rotationTankOpenHandle = {};
        self.rotationTankOpenHandle.node = rotationNodeTankOpenHandle;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTankOpenHandle#minRot"));
        self.rotationTankOpenHandle.minRot = {};
        self.rotationTankOpenHandle.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTankOpenHandle.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTankOpenHandle.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTankOpenHandle#maxRot"));
        self.rotationTankOpenHandle.maxRot = {};
        self.rotationTankOpenHandle.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTankOpenHandle.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTankOpenHandle.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationTankOpenHandle.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTankOpenHandle#rotTime"), 2)*1000;
        self.rotationTankOpenHandle.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTankOpenHandle#touchRotLimit"), 10));
    end;
	
	local tankOpenHandleIndicator = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tankOpenHandleIndicator#index"));
	if tankOpenHandleIndicator ~= nil then
		self.tankOpenHandleIndicator = {};
		self.tankOpenHandleIndicator.node = tankOpenHandleIndicator;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tankOpenHandleIndicator#minTranslation"));
		self.tankOpenHandleIndicator.minTranslation = {};
		self.tankOpenHandleIndicator.minTranslation[1] = x;
		self.tankOpenHandleIndicator.minTranslation[2] = y;	
		self.tankOpenHandleIndicator.minTranslation[3] = z;

		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tankOpenHandleIndicator#maxTranslation"));
		self.tankOpenHandleIndicator.maxTranslation = {};
		self.tankOpenHandleIndicator.maxTranslation[1] = x;
		self.tankOpenHandleIndicator.maxTranslation[2] = y;	
		self.tankOpenHandleIndicator.maxTranslation[3] = z;

        self.tankOpenHandleIndicator.translationTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tankOpenHandleIndicator#translationTime"), 2)*1000;
        self.tankOpenHandleIndicator.touchTransLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tankOpenHandleIndicator#touchTransLimit"), 10));		
	end;
	
	--extra grainplane
	self.extraGrainTankPlanes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.extraGrainTankPlane.node(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            setVisibility(node, false);

            local entry = {};
            entry.node = node;
            local windowNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#windowIndex"));
            if windowNode ~= nil then
                entry.windowNode = windowNode;
                setVisibility(windowNode, false);
            end;

            if self.defaultExtraGrainTankPlane == nil then
                self.defaultExtraGrainTankPlane = entry;
            end;
            self.extraGrainTankPlanes[t] = entry;
        end;
        i = i +1;
    end;
    if self.defaultExtraGrainTankPlane==nil then
        self.extraGrainTankPlanes = nil;
    end;

    --self.grainPlane = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainPlane#index"));
    --self.grainPlaneWindow = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainTankPlane#windowIndex"));

    self.extraGrainTankPlaneMinY, self.extraGrainTankPlaneMaxY = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.extraGrainTankPlane#minMaxY"));
    if self.extraGrainTankPlaneMinY == nil or self.extraGrainTankPlaneMaxY == nil then
        local animCurve = AnimCurve:new(linearInterpolator4);
        local i = 0;
        while true do
            local key = string.format("vehicle.extraGrainTankPlane.key(%d)", i);
            local t = getXMLFloat(xmlFile, key.."#time");
            local yValue = getXMLFloat(xmlFile, key.."#y");
            local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
            if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil then
                break;
            end;
            animCurve:addKeyframe({x=scaleX, y=scaleY, z=scaleZ, w=yValue, time = t});
            i = i +1;
        end;
        if i > 0 then
            self.extraGrainTankPlaneAnimCurve = animCurve;
        end;
        self.extraGrainTankPlaneMinY = 0;
        self.extraGrainTankPlaneMaxY = 0;
    end;
	
	-- Sounds --
	
    BuseSoundFile = Utils.getFilename("BuseSound.ogg", self.baseDirectory);
    self.BuseSoundId = createSample("BuseSound");
    loadSample(self.BuseSoundId, BuseSoundFile, false);
    self.BusePlaying = false;
   
    BatteurSoundFile = Utils.getFilename("Treshing.ogg", self.baseDirectory);
    self.BatteurSoundId = createSample("BatteurSound");
    loadSample(self.BatteurSoundId, BatteurSoundFile, false);
    self.BatteurPlaying = false;
	
    BatteurStartSoundFile = Utils.getFilename("startTreshing2.ogg", self.baseDirectory);
    self.BatteurStartSoundId = createSample("BatteurStartSound");
    loadSample(self.BatteurStartSoundId, BatteurStartSoundFile, false);
    self.BatteurStartPlaying = false;

    BatteurStopSoundFile = Utils.getFilename("treshingStop2.ogg", self.baseDirectory);
    self.BatteurStopSoundId = createSample("BatteurStopSound");
    loadSample(self.BatteurStopSoundId, BatteurStopSoundFile, false);
    self.BatteurStopPlaying = false;
	
    FixingSoundFile = Utils.getFilename("wrench.wav", self.baseDirectory);
    self.FixingSoundId = createSample("FixingSound");
    loadSample(self.FixingSoundId, FixingSoundFile, false);
    self.FixingPlaying = false;

	self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
	
	-- External sounds
	--ExternalFixingSound  = Utils.getFilename("wrench.wav", self.baseDirectory);
	--self.externalFixingSound = createAudioSource("ExternalFixingSound", ExternalFixingSound, 50, 10, 1, 0);
	--link(self.components[1].node, self.externalFixingSound);
	--setVisibility(self.externalFixingSound, false);
	
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;

    self.Rouleau = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Rouleau#index"));
    self.Helice1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Helice1#index"));
    self.Helice2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Helice2#index"));
    self.Rotor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Rotor#index"));
    self.retroG = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.retroG#index"));
    self.retroD = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.retroD#index"));
	
	-- Discs ---
	self.disc1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.disc1#index"));
	self.disc2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.disc2#index"));
	self.disc3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.disc3#index"));
	self.disc4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.disc4#index"));
	self.disc5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.disc5#index"));
	self.disc6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.disc6#index"));
	self.disc7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.disc7#index"));
	self.disc8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.disc8#index"));
	
	-- Cab controllers
	self.seperatorOnSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seperatorOnSwitch#index"));
	self.lightOnSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lightOnSwitch#index"));
	self.workLightOnSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workLightOnSwitch#index"));
	self.reelOnSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reelOnSwitch#index"));
	self.grainPipeOutSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainPipeOutSwitch#index"));
	self.key = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.key#index"));
	self.feederSpeed = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.feederSpeed#index"));
	self.reelSpeedSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reelSpeedSwitch#index"));
	self.reelLiftSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reelLiftSwitch#index"));
	self.reelForwardSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reelForwardSwitch#index"));
	self.cutterRaiseSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cutterRaiseSwitch#index"));
	self.cutterLevelIndicator = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cutterLevelIndicator#index"));
	
	-- Different grain tank levels
	self.grainTankClosedTankCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankClosedTankCapacity"), 7200);
	
	self.attacherJointRot = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJointRot#index"));
	
	-- Moveable camera
	self.internalCamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.internalCamera#index"));
	
	local grainUnloadHandleNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.grainUnloadHandle#index"));
    if grainUnloadHandleNode ~= nil then
        self.grainUnloadHandle = {};
        self.grainUnloadHandle.node = grainUnloadHandleNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.grainUnloadHandle#minRot"));
        self.grainUnloadHandle.minRot = {};
        self.grainUnloadHandle.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.grainUnloadHandle.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.grainUnloadHandle.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.grainUnloadHandle#maxRot"));
        self.grainUnloadHandle.maxRot = {};
        self.grainUnloadHandle.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.grainUnloadHandle.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.grainUnloadHandle.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.grainUnloadHandle.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.grainUnloadHandle#rotTime"), 2);
        self.grainUnloadHandle.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.grainUnloadHandle#touchRotLimit"), 10));
    end;
	
	-- Graintank auger
    self.grainTankAuger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainTankAuger#index"));
    self.grainTankAugerRotation = 0;

	-- Init of self values
    self.ThreshingActive = false;
	self.ThreshingSound = false;
	self.Echelle = false;	
    self.setGrainTankFillLevel = SpecializationUtil.callSpecializationsFunction("setGrainTankFillLevel");
	self.HUDActive = true;
	self.RetroActive = false;
	self.BatteurOK = false;
	self.TreshedNumber = 0;
	self.TreshedTotalNumber = 0;
	self.strawToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.strawParticleSystems#toggleTime"), 3500);
	-- HUD --
	
	self.HUDpath = Utils.getFilename("HUD_Controls.png", self.baseDirectory);
	self.HUDWidth = 0.100;
    self.HUDHeight = 0.22;
	self.HUDPoxX = 0.90;
    self.HUDPoxY = 0.165
    self.HUDOverlay = Overlay:new("HUD", self.HUDpath, self.HUDPoxX, self.HUDPoxY, self.HUDWidth, self.HUDHeight);
	
	self.rotationDirection = true;
	self.lastGrainLevel = self.grainTankFillLevel;
	self.lastGrainPipeRotation = 0;
	self.lastAttacherRotation = 0;
	self.engineRunTime = 0;
	self.rotorSpeedValue = 350;
	self.actualRotorSpeedValue = 0;
	self.feederSpeedValue = 15;
	self.feedSpeed = self.feederSpeedValue;
	self.reelSpeedValue = 1.5;
	self.sidearmRotation = 0;
	self.sidearmTranslation = -0.95;
	self.reelSpeedAdjustMode = 0;
	self.sideArmAdjustMode = 0;
	self.sideArmFwdAdjustMode = 0;
	self.attacherRot = 0;
	self.attacherHightAdjustMode = 0;
	self.rotorSpeedAdjustMode = 0;
	self.autoHeader = true;
	self.cutterLevelIndicatorHeight = 0;
	self.orgUnloadCapacity = self.grainTankUnloadingCapacity;	
	self.myLightsActive = false;
	self.lastThreasherRoundPerMinute = 0;
	self.shiftMode = 1;
	
	self.rotationTankLid1Max = false;
	self.rotationTankLid2Max = true;
	self.rotationTankOpenHandleMax = false;
	self.rotationTankLid1Min = true;
	self.rotationTankLid2Min = false;
	self.rotationTankOpenHandleMin = true;
	--self.speedUpAndDownCycles = 10 * dt;
	--self.remReelCycles = self.speedUpAndDownCycles;
	--self.remThresherCycles = self.speedUpAndDownCycles;
	
	self.leftMirror = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMirror#index"));
	self.rightMirror = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMirror#index"));
	
	if self.mirrorRotationOffsetXleft == nil then
		self.mirrorRotationOffsetXleft = 0;
	end;
	
	if self.mirrorRotationOffsetYleft == nil then
		self.mirrorRotationOffsetYleft = 0;
	end;

	if self.mirrorRotationOffsetXright == nil then
		self.mirrorRotationOffsetXright = 0;
	end;

	if self.mirrorRotationOffsetYright == nil then
		self.mirrorRotationOffsetYright = 0;
	end;
	
	if self.camPositionX == nil then
		self.camPositionX = 0;
	end;
	
	if self.camPositionZ == nil then
		self.camPositionZ = 0;
	end;
	
	if self.strawShreaderMounted == nil then
		self.strawShreaderMounted = true;
	end;
	
	self.threasherActivationTime = 2500;
	self.threshingTime = 0;
	self.reelTime = 0;
	self.timeoutCutterShutdown = true;
	self.isCutterStarted = false;
	self.startAttacherMinRot = self.attacherJoints[1].minRot;
	self.startAttacherMaxRot = self.attacherJoints[1].maxRot;
end;

function CIH2388:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    self.mirrorRotationOffsetXleft = Utils.getNoNil(getXMLFloat(xmlFile, key.."#mirrorRotationOffsetXleft"), 0);
    self.mirrorRotationOffsetYleft = Utils.getNoNil(getXMLFloat(xmlFile, key.."#mirrorRotationOffsetYleft"), 0);
	self.mirrorRotationOffsetXright = Utils.getNoNil(getXMLFloat(xmlFile, key.."#mirrorRotationOffsetXright"), 0);
    self.mirrorRotationOffsetYright = Utils.getNoNil(getXMLFloat(xmlFile, key.."#mirrorRotationOffsetYright"), 0);
	
	self.camPositionX = Utils.getNoNil(getXMLFloat(xmlFile, key.."#camPositionX"), 0);
	self.camPositionZ = Utils.getNoNil(getXMLFloat(xmlFile, key.."#camPositionZ"), 0);
	
	local shreaderMounted = Utils.getNoNil(getXMLFloat(xmlFile, key.."#strawShreaderMounted"), 1);
	if shreaderMounted == 0 then
		self.strawShreaderMounted = false;
	else
		self.strawShreaderMounted = true;
	end;
	
   local TreshedTotalNumber =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#TreshedTotalNumber"),0);
   self.TreshedTotalNumber = TreshedTotalNumber;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function CIH2388:getSaveAttributesAndNodes(nodeIdent)
   local TreshedTotalNumber= Utils.getNoNil(self.TreshedTotalNumber, 10);
   local shreaderMounted = 1;
   if not self.strawShreaderMounted then
		shreaderMounted = 0;
   end;
    local attributes = 'TreshedTotalNumber="'..string.format("%.1f",TreshedTotalNumber)..'" strawShreaderMounted="'..shreaderMounted..'" mirrorRotationOffsetXleft="'..self.mirrorRotationOffsetXleft..'" mirrorRotationOffsetYleft="'..self.mirrorRotationOffsetYleft..'" mirrorRotationOffsetXright="'..self.mirrorRotationOffsetXright..'" mirrorRotationOffsetYright="'..self.mirrorRotationOffsetYright..'" camPositionX="'..self.camPositionX..'" camPositionZ="'..self.camPositionZ..'"';
   return attributes, nil;
end;


function CIH2388:delete()
    stopSample(self.BuseSoundId);
    stopSample(self.BatteurStartSoundId);
    stopSample(self.BatteurStopSoundId);
    stopSample(self.BatteurSoundId);
	stopSample(self.FixingSoundId);
end;

function CIH2388:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CIH2388:keyEvent(unicode, sym, modifier, isDown)

		--if isDown and sym == Input.KEY_l and self.isMotorStarted then
			--renderText(0.5, 0.9350, 0.040, string.format());
    	if isDown and sym == self.keys.Batteur and self.isMotorStarted then
			self.ThreshingActive = not self.ThreshingActive;
			self.ThreshingSound = not self.ThreshingSound;
			self.BatteurOK = not self.BatteurOK;
			local BatteurSoundOffset = 4050;
			self.playBatteurSoundTime = self.time+BatteurSoundOffset;
		end

		if isDown and sym == self.keys.HUD then
			self.HUDActive = not self.HUDActive;
		end;

		if isDown and sym == self.keys.Echelle then
			self.Echelle = not self.Echelle;
		end;

		if isDown and sym == Input.KEY_home then
			self.RetroActive = not self.RetroActive;
		end;
		
		if isDown and sym == Input.KEY_KP_7 then
			self.rotorSpeedAdjustMode = 1;
		else 
			self.rotorSpeedAdjustMode = 0;
		end;
		
		if isDown and sym == Input.KEY_KP_9 then
			self.rotorSpeedAdjustMode = -1;
		end;
		
		if isDown and sym == Input.KEY_9 then
			if 	self.shiftMode == 1 then
				self.reelSpeedAdjustMode = 1;
			end;
		else
			if 	self.shiftMode == 1 then
				self.reelSpeedAdjustMode = 0;
			end;
		end;
		
		if isDown and sym == Input.KEY_8 then
			if 	self.shiftMode == 1 then
				self.reelSpeedAdjustMode = -1;
			end;
		end;
		
		if isDown and sym == Input.KEY_4 then
			if 	self.shiftMode == 1 then
				self.sideArmAdjustMode = -1;
			end;
		else
			if 	self.shiftMode == 1 then
				self.sideArmAdjustMode = 0;
			end;
		end;
		
		if isDown and sym == Input.KEY_5 then
			if 	self.shiftMode == 1 then
				self.sideArmAdjustMode = 1;
			end;
		end;
		
		if isDown and sym == Input.KEY_6 then
			if 	self.shiftMode == 1 then
				self.sideArmFwdAdjustMode = 1;
			end;
		else
			if 	self.shiftMode == 1 then
				self.sideArmFwdAdjustMode = 0;
			end;
		end;
		
		if isDown and sym == Input.KEY_7 then
			if 	self.shiftMode == 1 then
				self.sideArmFwdAdjustMode = -1;
			end;
		end;
		
		if isDown and sym == Input.KEY_KP_enter then
			self.autoHeader = not self.autoHeader;
		end;
		
		if isDown and sym == Input.KEY_f then
			self.myLightsActive = not self.myLightsActive;
		end;
		

    if self.isEntered then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input.KEY_r then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;

end;

function CIH2388:update(dt)
	if self.isEntered then
		if InputBinding.isPressed(InputBinding.COMBINEMOVECAMLEFT) then
			if 	self.shiftMode == 2 then
				self.camPositionX = self.camPositionX + 0.02;
				if self.camPositionX >= 0.4 then
					self.camPositionX = 0.4;
				end;
			elseif self.shiftMode == 3 then
				self.mirrorRotationOffsetYleft = self.mirrorRotationOffsetYleft + 0.5;
			elseif self.shiftMode == 4 then
				self.mirrorRotationOffsetYright = self.mirrorRotationOffsetYright + 0.5;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.COMBINEMOVECAMRIGHT) then
			if 	self.shiftMode == 2 then
				self.camPositionX = self.camPositionX - 0.02;
				if self.camPositionX <= -0.4 then
					self.camPositionX = -0.4;
				end;
			elseif self.shiftMode == 3 then
				self.mirrorRotationOffsetYleft = self.mirrorRotationOffsetYleft - 0.5;
			elseif self.shiftMode == 4 then
				self.mirrorRotationOffsetYright = self.mirrorRotationOffsetYright - 0.5;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.COMBINEMOVECAMFORWARD) then
			if 	self.shiftMode == 2 then
				self.camPositionZ = self.camPositionZ + 0.02;
				if self.camPositionZ >= 0.3 then
					self.camPositionZ = 0.3;
				end;
			elseif self.shiftMode == 3 then
				self.mirrorRotationOffsetXleft = self.mirrorRotationOffsetXleft + 0.5;
			elseif self.shiftMode == 4 then
				self.mirrorRotationOffsetXright = self.mirrorRotationOffsetXright + 0.5;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.COMBINEMOVECAMBACK) then
			if 	self.shiftMode == 2 then
				self.camPositionZ = self.camPositionZ - 0.02;
				if self.camPositionZ <= -0.3 then
					self.camPositionZ = -0.3;
				end;
			elseif self.shiftMode == 3 then
				self.mirrorRotationOffsetXleft = self.mirrorRotationOffsetXleft - 0.5;
			elseif self.shiftMode == 4 then
				self.mirrorRotationOffsetXright = self.mirrorRotationOffsetXright - 0.5;
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.COMBINEMOVECAMRESET) then
			if 	self.shiftMode == 2 then
				self.camPositionX = 0;
				self.camPositionZ = 0;
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.OPENGRAINTANK) then
			self.rotationTankLid1Max = not self.rotationTankLid1Max;
			self.rotationTankLid2Max = not self.rotationTankLid1Max;
			self.rotationTankOpenHandleMax = not self.rotationTankOpenHandleMax;
			self.rotationTankLid1Min = not self.rotationTankLid1Min;
			self.rotationTankLid2Min = not self.rotationTankLid1Min;
			self.rotationTankOpenHandleMin = not self.rotationTankOpenHandleMin;
			
			--Adjust combine capacity in accordance to whether graintank is closed or not
		end;
		
		if InputBinding.hasEvent(InputBinding.COMBINESHIFTMODE) then
			self.shiftMode = self.shiftMode + 1;
			if self.shiftMode > 5 then
				self.shiftMode = 1;
			end;
		end;
	end;
	
	--Always open tank if we have grain in the tank thats more than open level
	if self.grainTankFillLevel >= self.grainTankClosedTankCapacity then
		self.rotationTankOpenHandleMax = true;
		self.rotationTankOpenHandleMin = false;
	end;
	
	if not self.autoHeader and self.isEntered and not self.isHired then
		if InputBinding.isPressed(InputBinding.HEADERDOWN) then
			if self.attacherRot < 26 then
				self.attacherRot = self.attacherRot + 0.013 * dt;
			end;
		elseif InputBinding.isPressed(InputBinding.HEADERUP) then
			if self.attacherRot > -7 then
				self.attacherRot = self.attacherRot - 0.013 * dt;
			end;
		end;
	end;
		
	self.lightsActive = self.myLightsActive;
	for k, light in pairs(self.lights) do
        setVisibility(light, self.lightsActive);
    end; 
		
	
	--local rpm = self.rpmNum;
	local rpm = 3;
	local engineRpm = 3;
	
	--if self.rpmMeterValue ~= nil then
	if self.enabledPowershiftGearBox and not self.isAIThreshing and not self.isAutopilotActivated then
		rpm = self.rpmMeterValue / self.motorMaxRpmLimit[3] * 3;
	end;
	
	if rpm > 3 then
		rpm = 3;
	end;
	
	engineRpm = rpm;

	if self.isMotorStarted then
		rotate(self.fan, dt * 0.004 * rpm, 0, 0);
		self.engineRunTime = dt + self.engineRunTime;
	else
		self.engineRunTime = 0;
	end;
	
	if self.rotorSpeedAdjustMode == 1 then
		if self.rotorSpeedValue < 550 then
			self.rotorSpeedValue = self.rotorSpeedValue + 0.01 * dt;
		end;
	elseif self.rotorSpeedAdjustMode == -1 then
		if self.rotorSpeedValue > 150 then
			self.rotorSpeedValue = self.rotorSpeedValue - 0.01 * dt;
		end;
	end;
	
	if self.isMotorStarted then
		if self.reelSpeedAdjustMode == -1 then
			if self.reelSpeedValue > 0.2 then
				self.reelSpeedValue = self.reelSpeedValue - 0.03;
				--self.feederSpeedValue = self.reelSpeedValue * 5;
			end;
		elseif self.reelSpeedAdjustMode == 1 then
			if self.reelSpeedValue < 4 then
				self.reelSpeedValue = self.reelSpeedValue + 0.03;
				--self.feederSpeedValue = self.reelSpeedValue * 5;
			end;
		end;
		
		
		if self.sideArmAdjustMode == -1 then
			if self.sidearmRotation > -25 then
				self.sidearmRotation = self.sidearmRotation - 0.2;
			end
		elseif self.sideArmAdjustMode == 1 then
			if self.sidearmRotation < 15 then
				self.sidearmRotation = self.sidearmRotation + 0.2;
			end
		end;
		
		
		if self.sideArmFwdAdjustMode == -1 then
			if self.sidearmTranslation < -0.86 then
				self.sidearmTranslation = self.sidearmTranslation + 0.003;
			end
		elseif self.sideArmFwdAdjustMode == 1 then
			if self.sidearmTranslation > -1.08 then
				self.sidearmTranslation = self.sidearmTranslation - 0.003;
			end
		end;
	end;
	
	if self.attacherJointRot ~= nil then
		if self.autoHeader then
			local x,y,z = getRotation(self.attacherJointRot);
			self.attacherRot = x/3.14 * 180;
		end;
	end;

	local procent = self.grainTankFillLevel/self.grainTankCapacity*100;
	if procent >= 89 then
		if not self.rundumleuchtenAn then
			self.rundumleuchtenAn = true;
			for i=1, self.rundumleuchtenAnz do
				setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
			end;
		end;
	elseif self.isAIThreshing or self.isAutopilotActivated then
		self.rundumleuchtenAn = false;
		for i=1, self.rundumleuchtenAnz do
			setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
		end;
	end;
	
	-- Higher unload rate pr. rpm and extra pipe particles
	self.grainTankUnloadingCapacity = rpm * self.orgUnloadCapacity;
	--self.grainTankUnloadingCapacity = 200;
	
	if self.manualUnloading and self.grainTankUnloadingCapacity > self.orgUnloadCapacity * 2 then
		if self.grainTankFillLevel > 500 then
			if self.currentGrainTankFruitType == FruitUtil.FRUITTYPE_RAPE then
				Utils.setEmittingState(self.extraPipeRapeParticleSystem, true);
			else
				Utils.setEmittingState(self.extraPipeWheatParticleSystem, true);
			end;
		else
			Utils.setEmittingState(self.extraPipeRapeParticleSystem, false);
			Utils.setEmittingState(self.extraPipeWheatParticleSystem, false);
		end;
	else
		Utils.setEmittingState(self.extraPipeRapeParticleSystem, false);
		Utils.setEmittingState(self.extraPipeWheatParticleSystem, false);
	end;

	-- Camera translation
	if self.internalCamera ~= nil then
		setTranslation(self.internalCamera, self.camPositionX, 0, self.camPositionZ);
	end;
	
	if self.leftMirror ~= nil then
		setRotation(self.leftMirror,Utils.degToRad(-self.mirrorRotationOffsetXleft),Utils.degToRad(28.5+self.mirrorRotationOffsetYleft),Utils.degToRad(0));
	end;
	
	if self.rightMirror ~= nil then
		setRotation(self.rightMirror,Utils.degToRad(-self.mirrorRotationOffsetXright),Utils.degToRad(-self.mirrorRotationOffsetYright),Utils.degToRad(0));
	end;
	
	--if self.ThreshingActive then 
		self.actualRotorSpeedValue = self.rotorSpeedValue * rpm;
	--else
		--self.actualRotorSpeedValue = 0;
	--end;

	-- Slow reel startup and shutoff
	if self.reelTime < self.threasherActivationTime and self.isCutterStarted then
		self.reelTime = self.reelTime + dt;
		if self.reelTime > self.threasherActivationTime then
			self.reelTime = self.threasherActivationTime;
		end;
	end;

	if self.reelTime > 0 and not self.isCutterStarted then
		self.reelTime = self.reelTime - dt/2;
		if self.reelTime < 0 then
			self.reelTime = 0;
		end;
	end;
	
	--self.reelSpeedValue = self.reelSpeedValue/self.threasherActivationTime * self.reelTime;
	--renderText(0.5, 0.9, 0.040,string.format(rpm));
	--renderText(0.5, 0.8, 0.040,string.format(self.threasherActivationTime));
	--renderText(0.5, 0.7, 0.040,string.format(self.reelTime));
	--renderText(0.5, 0.6, 0.040,string.format(dt));
	local reelRpm = rpm/self.threasherActivationTime * self.reelTime;
	
	-- Slow thresher startup and shutoff
	if self.threshingTime < self.threasherActivationTime and self.ThreshingActive then
		self.threshingTime = self.threshingTime + dt;
		if self.threshingTime > self.threasherActivationTime then
			self.threshingTime = self.threasherActivationTime;
		end;
	end;

	if self.threshingTime > 0 and not self.ThreshingActive then
		self.threshingTime = self.threshingTime - dt/2;
		if self.threshingTime < 0 then
			self.threshingTime = 0;
		end;
	end;
	
	rpm = rpm/self.threasherActivationTime * self.threshingTime;
	self.actualRotorSpeedValue = self.actualRotorSpeedValue/self.threasherActivationTime * self.threshingTime;
	
	-- Grain tank particles
	for cutter,implement in pairs(self.attachedCutters) do
                if cutter.reelStarted then
				if self.lastGrainLevel < self.grainTankFillLevel then 
					if self.currentGrainTankFruitType == FruitUtil.FRUITTYPE_RAPE then
						Utils.setEmittingState(self.pipeRapeParticleSystem, true);
					else
						Utils.setEmittingState(self.pipeGrainParticleSystem, true);
					end;
				else
			  		Utils.setEmittingState(self.pipeGrainParticleSystem, false);
					Utils.setEmittingState(self.pipeRapeParticleSystem, false);
				end;
			
		    else 
			Utils.setEmittingState(self.pipeGrainParticleSystem, false);
			Utils.setEmittingState(self.pipeRapeParticleSystem, false);
		    end;
	end;

	-- Seperator movements --
	
	--if self.ThreshingActive then 
		if self.seperatorPart1 ~= nil then
            local x, y, z = getRotation(self.seperatorPart1.node);
            local minRot = self.seperatorPart1.minRot;
			local maxRot = self.seperatorPart1.maxRot;
            local eps = self.seperatorPart1.touchRotLimit;

            if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
				self.rotationDirection = false;
			elseif math.abs(maxRot[1]-x) < eps and math.abs(maxRot[2]-y) < eps and math.abs(maxRot[3]-z) < eps then
				self.rotationDirection = true;
			end;
		end;
			
		if self.seperatorPart1 ~= nil then
			local x, y, z = getRotation(self.seperatorPart1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.seperatorPart1.maxRot, self.seperatorPart1.minRot, 3, self.seperatorPart1.rotTime / rpm, dt, self.rotationDirection);
			setRotation(self.seperatorPart1.node, unpack(newRot));
		end;
		
		if self.seperatorPart2 ~= nil then
			local x, y, z = getRotation(self.seperatorPart2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.seperatorPart2.maxRot, self.seperatorPart2.minRot, 3, self.seperatorPart2.rotTime / rpm, dt, self.rotationDirection);
			setRotation(self.seperatorPart2.node, unpack(newRot));
		end;
		
		if self.seperatorPart3 ~= nil then
			local x, y, z = getRotation(self.seperatorPart3.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.seperatorPart3.maxRot, self.seperatorPart3.minRot, 3, self.seperatorPart3.rotTime / rpm, dt, self.rotationDirection);
			setRotation(self.seperatorPart3.node, unpack(newRot));
		end;
		
		if self.seperatorPart4 ~= nil then
			local x, y, z = getRotation(self.seperatorPart4.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.seperatorPart4.maxRot, self.seperatorPart4.minRot, 3, self.seperatorPart4.rotTime / rpm, dt, self.rotationDirection);
			setRotation(self.seperatorPart4.node, unpack(newRot));
		end;
		
		if self.seperatorPart5 ~= nil then
			local x, y, z = getRotation(self.seperatorPart5.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.seperatorPart5.maxRot, self.seperatorPart5.minRot, 3, self.seperatorPart5.rotTime / rpm, dt, self.rotationDirection);
			setRotation(self.seperatorPart5.node, unpack(newRot));
		end;
		
		if self.seperatorPart6 ~= nil then
			local x, y, z = getRotation(self.seperatorPart6.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.seperatorPart6.maxRot, self.seperatorPart6.minRot, 3, self.seperatorPart6.rotTime / rpm, dt, self.rotationDirection);
			setRotation(self.seperatorPart6.node, unpack(newRot));
		end;
		
		rotate(self.seperatorPart7, dt*0.012*rpm, 0, 0);
	--end;

		if self.isEntered then
		  if self.rundumleuchtenAn == true then
			setVisibility(self.roundLightDisplay, true);
		  else
			setVisibility(self.roundLightDisplay, false);
	    	  end;
    		end;

	if self.rundumleuchtenAnz > 0 then
	  if self.rundumleuchtenAn then
		for i=1, self.rundumleuchtenAnz do
		  rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
		end;
	  end;
	end;

	--manual mountings etc.
	--mount straw spreader manually
	local nearestDistance = 3.0; --max distance allowed
	local px, py, pz = getWorldTranslation(self.Helice1); --self.Helice1 is one of the spereaders
	local vx, vy, vz = getWorldTranslation(getCamera());
	
	if vx ~= nil and  vy ~= nil and vz ~= nil then
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.spreaderMountingInRange = true; --farmer is in range
		else
			self.spreaderMountingInRange = false; --farmer is not in range
		end;
	end;
	
	if self.spreaderMountingInRange then
		if not self.strawShreaderMounted then
			g_currentMission:addExtraPrintText(string.format("Key %s: Mount straw shreader", InputBinding.getKeyNamesOfDigitalAction(InputBinding.STRAWSHREADER)));
		else
			g_currentMission:addExtraPrintText(string.format("Key %s: Unmount straw shreader", InputBinding.getKeyNamesOfDigitalAction(InputBinding.STRAWSHREADER)));
		end;
	end;
	
	if InputBinding.hasEvent(InputBinding.STRAWSHREADER) then
		if 	self.spreaderMountingInRange then
			self.strawShreaderMounted = not self.strawShreaderMounted;
			--if Player:getIsActiveForSound() then
				if not self.FixingPlaying then
					playSample(self.FixingSoundId, 1, 1, 0);
				end;
			--end;
		end;
	end;
	
	
	if self.Helice1 ~= nil then
		setVisibility(self.Helice1, self.strawShreaderMounted);
	end;
	
	if self.Helice2 ~= nil then
		setVisibility(self.Helice2, self.strawShreaderMounted);
	end;
	
	if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_WHEAT and self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_BARLEY and self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
		if self.strawShreaderMounted == false then
			self.strawShreaderMounted = true;
		end;
	end;
	
	-- Manual mountings done
	-- Movements --

		local doRotate = self.rotationColonneMax or self.rotationColonneMin 
	if self.rotationColonne ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationColonne.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationColonne.maxRot, self.rotationColonne.minRot, 3, self.rotationColonne.rotTime, dt, not self.rotationColonneMax);
        setRotation(self.rotationColonne.node, unpack(newRot));
    end;	
	
	local doRotate = self.rotationEchelleMax or self.rotationEchelleMin 
	if self.rotationEchelle ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationEchelle.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationEchelle.maxRot, self.rotationEchelle.minRot, 3, self.rotationEchelle.rotTime, dt, not self.rotationEchelleMax);
        setRotation(self.rotationEchelle.node, unpack(newRot));
    end;
	
	--[[local doRotate = self.rotationTankLid1Max or self.rotationTankLid1Min 
	if self.rotationTankLid1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationTankLid1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationTankLid1.maxRot, self.rotationTankLid1.minRot, 3, self.rotationTankLid1.rotTime, dt, not self.rotationTankLid1Max);
        setRotation(self.rotationTankLid1.node, unpack(newRot));
    end;]]	
	
	--[[local doRotate = self.rotationTankLid2Max or self.rotationTankLid2Min 
	if self.rotationTankLid2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationTankLid2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationTankLid2.maxRot, self.rotationTankLid2.minRot, 3, self.rotationTankLid2.rotTime, dt, not self.rotationTankLid2Max);
        setRotation(self.rotationTankLid2.node, unpack(newRot));
    end;]]

	local doRotate = self.rotationTankOpenHandleMax or self.rotationTankOpenHandleMin 
	if self.rotationTankOpenHandle ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationTankOpenHandle.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationTankOpenHandle.maxRot, self.rotationTankOpenHandle.minRot, 3, self.rotationTankOpenHandle.rotTime, dt, not self.rotationTankOpenHandleMax);
        setRotation(self.rotationTankOpenHandle.node, unpack(newRot));
    end;	
	
	if self.rotationTankLid1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.rotationTankLid1.node);
		local bx, by, bz = getWorldTranslation(self.tankOpenHandleIndicator.node);

		local x, y, z = worldDirectionToLocal(getParent(self.rotationTankLid1.node), bx-ax, by-ay, bz-az);
		setDirection(self.rotationTankLid1.node, x, y, z, 0, 1, 0);
		
		--local x2,y2,z2 = getRotation(self.rotationSafetyBoomHolder.node);
		--setRotation(self.rotationSafetyBoomHolder.node,Utils.degToRad(22.5)+x2,0,0);
    end;
	
	if self.rotationTankLid2 ~= nil then
        local x, y, z = getRotation(self.rotationTankLid1.node);
        local rot = {-x*2.86667,0,0};
        --local newRot = Utils.getMovedLimitedValues(rot, self.rotationTankLid2.maxRot, self.rotationTankLid2.minRot, 3, self.rotationTankLid2.rotTime, dt, not self.rotationTankLid2Max);
        setRotation(self.rotationTankLid2.node, unpack(rot));
    end;
	
	--[[if self.tankOpenHandleIndicator.node ~= nil then
		local x, y, z = getTranslation(self.tankOpenHandleIndicator.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.tankOpenHandleIndicator.maxTranslation, self.tankOpenHandleIndicator.minTranslation, 3, self.tankOpenHandleIndicator.translationTime, dt, not self.rotationTankLid1Max);
        setTranslation(self.tankOpenHandleIndicator.node, unpack(newTrans));
	end;]]

		-- Echelle --
		
	if self.Echelle then
		self.rotationEchelleMax = true;
		self.rotationEchelleMin = false;
	else
		self.rotationEchelleMax = false;
		self.rotationEchelleMin = true;
	end;
	
	
	-- Threshing Sounds --

	
	if self.ThreshingSound and self:getIsActiveForSound() then
        if not self.BatteurStartPlaying then
			playSample(self.BatteurStartSoundId, 1, 1, 0);
			self.BatteurStartPlaying = true;
			stopSample(self.BatteurStopSoundId);
			self.BatteurStopPlaying = false;
		end;
	else
        if self.BatteurStartPlaying then
			stopSample(self.BatteurStartSoundId);
			self.BatteurStartPlaying = false;
			playSample(self.BatteurStopSoundId, 1, 1, 0);
			self.BatteurStopPlaying = true;	
		end;
	end;
	
	if self.BatteurSoundId ~= nil then
		local alpha = 0.9;
		local roundPerMinute = self.lastThreasherRoundPerMinute*alpha + (1-alpha)*(self.actualRotorSpeedValue);
		self.lastThreasherRoundPerMinute = roundPerMinute;
		local roundPerSecond = roundPerMinute / 60;
		setSamplePitch(self.BatteurSoundId, math.min(1 + 0.01*math.abs(roundPerSecond), 3));
	end;
	
	if self.ThreshingSound and self:getIsActiveForSound() then
		if self.playBatteurSoundTime <= self.time then
			if not self.BatteurPlaying then
				playSample(self.BatteurSoundId, 0, 1, 0);
				self.BatteurPlaying = true;
			end;
		end;
	else
			if self.BatteurPlaying then
				stopSample(self.BatteurSoundId);
				self.BatteurPlaying = false;
			end;
	end;

-- Threshing Movements --
	--local feederRotation = 0.007 * self.rotorSpeedValue;
	local feederRotation = 0.001 * 	(self.feederSpeedValue/2) * reelRpm;
	local reelRotation = 0.001 * (self.reelSpeedValue/2) * reelRpm;
	
	feederRotation = feederRotation/self.threasherActivationTime * self.reelTime;
	reelRotation = reelRotation/self.threasherActivationTime * self.reelTime;
	
	self.feedSpeed = self.feederSpeedValue/3 * engineRpm;
	
	--if self.ThreshingActive then 
		rotate(self.Rouleau, dt*feederRotation, 0, 0);
		rotate(self.Helice2, 0, -dt*0.01 * rpm, 0);
		rotate(self.Helice1, 0, dt*0.01 * rpm, 0);
		rotate(self.grainTankAuger, 0, -dt*0.007* rpm, 0);

		rotate(self.disc8, dt*0.01* rpm, 0, 0);
		rotate(self.disc7, dt*0.03* rpm, 0, 0);
		rotate(self.disc6, dt*0.018* rpm, 0, 0);
		rotate(self.disc5, -dt*0.03* rpm, 0, 0);
		rotate(self.disc4, -dt*0.015* rpm, 0, 0);
		rotate(self.disc3, -dt*0.015* rpm, 0, 0);
		rotate(self.disc2, -dt*0.015* rpm, 0, 0);
		rotate(self.disc1, -dt*0.015* rpm, 0, 0);
	
	--end;
	
-- Cutter movements -- 
	
	for cutter,implement in pairs(self.attachedCutters) do
		if self.isMotorStarted then
			if cutter.rollNode ~= nil then
				rotate(cutter.rollNode, -1 * dt*feederRotation, 0, 0);
			end;
			if cutter.myRollNode ~= nil then
				cutter.myRollSpeed = -1 * dt*feederRotation;
			end;
			
			if cutter.reelNode ~= nil then
				rotate(cutter.reelNode, -1 * dt*reelRotation, 0, 0);
			end;
			if cutter.myReelNode ~= nil then
				cutter.myReelSpeed = -1 * dt*reelRotation;
			end;
			
		end;
		
		if cutter.sideArm ~= nil then
			setRotation(cutter.sideArm, Utils.degToRad(self.sidearmRotation) ,0 ,0);
		end
		
		
		if cutter.sideArmFwdTranslator ~= nil then
			setTranslation(cutter.sideArmFwdTranslator, 0,0.32,self.sidearmTranslation);
		end
		
		cutter.sideArmAdjustMode = self.sideArmAdjustMode; 
	end;
	
-- Manual attacher movement
	if not self.isHired and not self.autoHeader then
		if self.attacherJointRot ~= nil then
			local rot = {Utils.degToRad(self.attacherRot),0 ,0};
			self.attacherJoints[1].moveDown = true;
			self.attacherJoints[1].maxRot = rot;
			self.attacherJoints[1].minRot = rot;
			local implCount = 0;
			 for k, implement in pairs(self.attachedImplements) do
				implCount = implCount + 1;
			 end;
			if implCount == 0 then
				setRotation(self.attacherJoints[1].rotationNode, Utils.degToRad(self.attacherRot),0 ,0);
			end;
			--setRotation(self.attacherJointRot, Utils.degToRad(self.attacherRot),0 ,0);
		end;
	else
		if self.attacherJointRot ~= nil then
			self.attacherJoints[1].maxRot = self.startAttacherMaxRot;
			self.attacherJoints[1].minRot = self.startAttacherMinRot;
			--self.attacherJoints[1].moveDown = false;
		end;
	end;
	


-- CAB movements

	if self.attacherJointRot ~= nil then
		local xAttacher, yAttacher, zAttacher = getRotation(self.attacherJointRot);
		if xAttacher ~= nil then
			if xAttacher < self.lastAttacherRotation then
				setRotation(self.cutterRaiseSwitch, Utils.degToRad(-17) ,0 ,0);
			elseif xAttacher > self.lastAttacherRotation then
				setRotation(self.cutterRaiseSwitch, Utils.degToRad(17) ,0 ,0);
			else
				setRotation(self.cutterRaiseSwitch, 0 ,0 ,0);
			end;
		end;
			
		self.lastAttacherRotation = xAttacher;
	end;
	
	if self.ThreshingActive then
		setRotation(self.seperatorOnSwitch, Utils.degToRad(15) ,0 ,0);
	else
		setRotation(self.seperatorOnSwitch, Utils.degToRad(-15) ,0 ,0);
	end;
	
	if self.lightsActive then
		setRotation(self.lightOnSwitch, Utils.degToRad(9) ,0 ,0);
		setRotation(self.workLightOnSwitch, Utils.degToRad(9) ,0 ,0);
	else
		setRotation(self.lightOnSwitch, Utils.degToRad(-6) ,0 ,0);
		setRotation(self.workLightOnSwitch, Utils.degToRad(-6) ,0 ,0);
	end;
	
	self.isCutterStarted = false;
	for cutter,implement in pairs(self.attachedCutters) do
		if cutter.reelStarted then
			setRotation(self.reelOnSwitch, Utils.degToRad(15) ,0 ,0);
		else
			setRotation(self.reelOnSwitch, Utils.degToRad(0) ,0 ,0);
		end;
		self.isCutterStarted = cutter.reelStarted;
	end;
	
	if self.pipe ~= nil then
		local xPipe, yPipe, zPipe = getRotation(self.pipe);
		
		if yPipe ~= nil then
			if yPipe < self.lastGrainPipeRotation then
				setRotation(self.grainPipeOutSwitch, Utils.degToRad(-10) ,0 ,0);
			elseif yPipe > self.lastGrainPipeRotation then
				setRotation(self.grainPipeOutSwitch, Utils.degToRad(10) ,0 ,0);
			else
				setRotation(self.grainPipeOutSwitch, 0 ,0 ,0);
			end;
		end;
		
		self.lastGrainPipeRotation = yPipe;
	end;
	
	if self.key ~= nil then
		if self.isMotorStarted and self.engineRunTime < 1500 then
			setRotation(self.key, 0,Utils.degToRad(-90) ,Utils.degToRad(-24));
		elseif self.isMotorStarted then
			setRotation(self.key, 0,Utils.degToRad(-50) ,Utils.degToRad(-24));
		else
			setRotation(self.key, 0,Utils.degToRad(0) ,Utils.degToRad(-24));
		end;
	end;
	
	if self.feederSpeed ~= nil then
		setRotation(self.feederSpeed, Utils.degToRad(10 * self.rotorSpeedAdjustMode),0 ,0);
	end;
	
	if self.reelSpeedSwitch ~= nil then
		setRotation(self.reelSpeedSwitch, 0,Utils.degToRad((self.reelSpeedValue * -75) + 250),0);
	end;
	
	if self.reelLiftSwitch ~= nil then
		setRotation(self.reelLiftSwitch, Utils.degToRad(-17 * self.sideArmAdjustMode),0 ,Utils.degToRad(-17 * self.sideArmFwdAdjustMode));
	end;
	
	--if self.reelForwardSwitch ~= nil and self.sideArmAdjustMode == 0 then
		--setRotation(self.reelForwardSwitch, 0,0,Utils.degToRad(-17 * self.sideArmFwdAdjustMode));
	--end;
	
	self.unloading = false;
	if self.lastGrainLevel > self.grainTankFillLevel then
		self.unloading = true;
	else
		self.unloading = false;
	end;
	if self.grainUnloadHandle ~= nil then
		local x, y, z = getRotation(self.grainUnloadHandle.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.grainUnloadHandle.maxRot, self.grainUnloadHandle.minRot, 3, self.grainUnloadHandle.rotTime, dt, self.unloading);
		setRotation(self.grainUnloadHandle.node, unpack(newRot));
	end;
	
	if self.isMotorStarted then
		if self.rotationPartTanknadel ~= nil then
			local x, y, z = getRotation(self.rotationPartTanknadel.node);
			z = ((self.rotationPartTanknadel.maxRot[3] - self.rotationPartTanknadel.minRot[3]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[3];
			setRotation(self.rotationPartTanknadel.node, x, y ,z);
		end;
	
		if self.rotationPartTanknadel2 ~= nil then
			local x, y, z = getRotation(self.rotationPartTanknadel2.node);
			z = ((self.rotationPartTanknadel2.maxRot[3] - self.rotationPartTanknadel2.minRot[3]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel2.minRot[3];
			setRotation(self.rotationPartTanknadel2.node, x, y ,z);
		end;
		
		if self.rotationPartVoltnadel ~= nil then
			setRotation(self.rotationPartVoltnadel.node, 0, 0,Utils.degToRad(55));
		end;
		
		if self.rotationPartTempnadel ~= nil then
			setRotation(self.rotationPartTempnadel.node, 0, 0,Utils.degToRad(45));
		end;
	else
		setRotation(self.rotationPartTanknadel.node, 0, 0 ,Utils.degToRad(-15));
		setRotation(self.rotationPartVoltnadel.node, 0, 0 ,Utils.degToRad(-15));
		setRotation(self.rotationPartTempnadel.node, 0, 0 ,Utils.degToRad(-15));
	end;
	
	--[[if self.isHired or self.isEntered then
		if 	self.hydroStatHandle ~= nil then
			local hydro = math.floor((self.hydro+2.5)/5)*5;
			local xRotation = 30 / 100 * hydro;
			--local direction = self.movingDirection;
			
			if self.motor.speedLevel == 0 then
				if self.hydro > 0 then
					setRotation(self.hydroStatHandle, Utils.degToRad(xRotation), 0 ,Utils.degToRad(-5));
				elseif self.hydro < 0 then
					setRotation(self.hydroStatHandle, Utils.degToRad(xRotation), 0 ,Utils.degToRad(5));
				else
					setRotation(self.hydroStatHandle, 0, 0 ,0);
				end;
			elseif self.motor.speedLevel ~= 0 then
				xRotation = 30/34 * self.lastSpeed*3600;
				
				if self.hydro > 0 then
					setRotation(self.hydroStatHandle, Utils.degToRad(xRotation), 0 ,Utils.degToRad(-5));
				elseif self.hydro < 0 then
					setRotation(self.hydroStatHandle, Utils.degToRad(-xRotation), 0 ,Utils.degToRad(5));
				else
					setRotation(self.hydroStatHandle, 0, 0 ,0);
				end;
			end;
		end;
		
		if self.rpmHandle ~= nil then
			if rpm > 1 then
				setRotation(self.rpmHandle, Utils.degToRad(15.8 * rpm), 0 ,0);
			else
				setRotation(self.rpmHandle, Utils.degToRad(0), 0 ,0);
			end;
		end;
	end;
	
	if self.gearShifter ~= nil then
		if self.motor.speedLevel ~= 0 then
			setRotation(self.gearShifter, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(15));
		else
			if self.gearNum == 1 then
				setRotation(self.gearShifter, Utils.degToRad(10), Utils.degToRad(0), Utils.degToRad(15));
			elseif self.gearNum == 2 then
				setRotation(self.gearShifter, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(-15));
			else
				setRotation(self.gearShifter, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(15));
			end;
		end;
	end;]]
	
-- Threashing off --
	if not self.isMotorStarted then
		self.ThreshingActive = false;
		self.ThreshingSound = false;
		self.BatteurOK = false;
	    self.BatteurStartPlaying = false;
	    self.BatteurStopPlaying = false;
	    self.BatteurPlaying = false;
		if self.BatteurPlaying ~= nil then
			stopSample(self.BatteurSoundId);
		end;
		if self.threshingSound ~= nil then
			stopSample(self.threshingSound);
		end;
		self:stopThreshing();
	end	

	if not self.isEntered then
	    self.BatteurStartPlaying = false;
	    self.BatteurStopPlaying = false;
	    self.BatteurPlaying = false;
	end;

	-- Threshing conditions --
	
	if self.BatteurOK and self.isMotorStarted then
		self.allowsThreshing = true;
	else
		self.allowsThreshing = false;	
	end;

	-- Animations ---

	--if self.grainTankFillLevel > 0 and not self.Go.Batteur then
		--self.Go.Batteur = true;
		--self.Done.Batteur = true;
	--end;
	
	-- Ha Treshed --
		--self.TreshedNumber = g_currentMission.missionStats.hectaresThreshedSession
		
		if self.isThreshing then
		local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
		self.TreshedNumber = self.TreshedNumber + self.lastArea*pixelToQm/(40000);
		self.TreshedTotalNumber = self.TreshedTotalNumber + self.lastArea*pixelToQm/(40000);
		end;
	
			--self.TESTNUMBER = g_currentMission.missionStats.hectaresThreshedSession;
	-- Hide/Show Parts --
	
	if self.reverseDriveSoundEnabled then
		setVisibility(self.backward_lights, true);
	else
		setVisibility(self.backward_lights, false);
    	end;

	if self.RetroActive then
		setVisibility(self.retroG, true);
		setVisibility(self.retroD, true);
	else
		setVisibility(self.retroG, false);
		setVisibility(self.retroD, false);
	end;

	self.lastGrainLevel = self.grainTankFillLevel;

end;

function CIH2388:onLeave()
	if not self.isHired then
		self.rotationColonneMin = false;
		self.rotationColonneMax = true;
	end;
	if self.myLightsActive then
		self.lightsActive = true;
	else
		self.lightsActive = false;
	end
end;

function CIH2388:onEnter()
		self.rotationColonneMin = true;
		self.rotationColonneMax = false;
end;

function CIH2388:draw()
if self.isEntered then
		g_currentMission:addExtraPrintText(string.format("Key Enter: HUD ON/OFF"));
		g_currentMission:addExtraPrintText(string.format("Key %s: Start/Stop engine", "KP ,"));
		if self.HUDOverlay ~= nil then
			if self.HUDActive then
				self.HUDOverlay:render();
				setTextBold(true);
				setTextColor(0, 0, 0, 1.0);
				renderText(0.96, 0.255, 0.016, string.format("%.1f", self.TreshedNumber));
				renderText(0.96, 0.24, 0.016, string.format("%.1f", self.TreshedTotalNumber));
				--renderText(0.5, 0.9350, 0.040, string.format(self.RandomNumber));
				if self.shiftMode == 1 then
					setTextColor(1, 1, 1, 1.0);
					renderText(0.01, 0.08, 0.020, string.format("Adjusting reel mode[%s]",InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINESHIFTMODE)));
				elseif self.shiftMode == 2 then
					setTextColor(1, 1, 1, 1.0);
					renderText(0.01, 0.08, 0.020, string.format("Adjusting camera mode[%s]",","));
					renderText(0.01, 0.04, 0.020, string.format("left[%s], right[%s], fwd[%s], back[%s], ",InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMLEFT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMRIGHT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMFORWARD), InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMBACK)));
					renderText(0.01, 0.02, 0.020, string.format("Reset[%s]",InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMRESET)));
				elseif self.shiftMode == 3 then
					setTextColor(1, 1, 1, 1.0);
					renderText(0.01, 0.08, 0.020, string.format("Adjusting left mirror mode[%s]",","));
					renderText(0.01, 0.04, 0.020, string.format("left[%s], right[%s], down[%s], up[%s], ",InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMLEFT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMRIGHT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMFORWARD), InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMBACK)));
				elseif self.shiftMode == 4 then
					setTextColor(1, 1, 1, 1.0);
					renderText(0.01, 0.08, 0.020, string.format("Adjusting right mirror mode[%s]",","));
					renderText(0.01, 0.04, 0.020, string.format("left[%s], right[%s], down[%s], up[%s], ",InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMLEFT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMRIGHT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMFORWARD), InputBinding.getKeyNamesOfDigitalAction(InputBinding.COMBINEMOVECAMBACK)));
				elseif self.shiftMode == 5 then
					setTextColor(1, 1, 1, 1.0);
					renderText(0.01, 0.08, 0.020, string.format("Adjusting autopilot mode[%s]",","));
					renderText(0.01, 0.04, 0.020, string.format("Press[0] to see AP controls panel"));					
				end;
			end;
		end;
	end;
end;


function CIH2388:onDeactivateSounds()
    if self.BatteurPlaying ~= nil then
		stopSample(self.BatteurSoundId);
    end;
end;

function CIH2388:setGrainTankFillLevel(fillLevel, fruitType)
    if self.extraGrainTankPlanes ~= nil then
        local fruitTypeName = FruitUtil.fruitIndexToDesc[fruitType].name;
        local extraGrainPlane = self.extraGrainTankPlanes[fruitTypeName];
        if extraGrainPlane.node ~= nil then
            local yTranslation = 0;
            if self.extraGrainTankPlaneAnimCurve then
                local scaleX, scaleY, scaleZ , yTrans = self.extraGrainTankPlaneAnimCurve:get(self.grainTankFillLevel/self.grainTankCapacity);
                yTranslation = yTrans;
                setScale(extraGrainPlane.node, scaleX, scaleY, scaleZ);
            else
                local m = (self.extraGrainTankPlaneMaxY - self.extraGrainTankPlaneMinY) / self.grainTankCapacity;
                yTranslation = m*self.grainTankFillLevel + self.extraGrainTankPlaneMinY;
            end;
            local xPos, yPos, zPos = getTranslation(extraGrainPlane.node);
            setTranslation(extraGrainPlane.node, xPos, yTranslation, zPos);
            setVisibility(extraGrainPlane.node, self.grainTankFillLevel > 0);
            self.currentExtraGrainTankPlane = extraGrainPlane.node;
        end;
    end;
end;
