-- Para Veiculos Animados
--Autor:???
--Edio LS13:Vinicius LS---FBT Modding
--Cdigos para instalao:
--Modesc:
--<specialization name="PartesAnimadas" className="PartesAnimadas" filename="scripts/PartesAnimadas.lua"/>

--<specialization name="PartesAnimadas" />

--<specialization name="animatedVehicle" />

--<input name="Animacao1" category="VEHICLE" key1="KEY_5" 	key2="" button="" device="0" mouse="" />

--<input name="Animacao2" category="VEHICLE" key1="KEY_6" 	key2="" button="" device="0" mouse="" />

--<text name="Animacao1Abrir"><de>Korn Tankklappe ffnen</de><en>Open grain tank flap</en><pl>Otwrz klape zbiornika</pl></text>

--<text name="Animacao1Fechar"><de>Korn Tankklappe schliessen</de><en>Close grain tank flap</en><pl>Zamknij klape zbiornika</pl></text>

--<text name="Animacao2Abrir"><de>Rechte Klappe ffnen</de><en>Open right flap</en><pl>Otwrz klape boczna</pl></text>

--<text name="Animacao2Fechar"><de>Rechte Klappe schliessen</de><en>Close right flap</en><pl>Zamknij klape boczna</pl></text>

--XML:
--<animations>
--		<!-- Animacao1 -->
--        <animation name="GrainFlap">
--            <part node="0>28" startTime="0" endTime="2" startRot="0 0 0" endRot="0 0 11"/>
--			<part node="0>29" startTime="0" endTime="2" startRot="0 0 0" endRot="0 0 -11"/>
--        </animation>
--		<!-- Animacao2 -->
--        <animation name="RightFlap">
--            <part node="0>26" startTime="0" endTime="2" startRot="0 0 0" endRot="0 0 -90"/>
--        </animation>
--</animations>	

--    <GrainFlap animationName="GrainFlap" />

--    <RightFlap animationName="RightFlap" />

--FBT Modding Todos os direitos Reservados.

PartesAnimadas = {};

function PartesAnimadas.prerequisitesPresent(specializations)
    return true;
end;

function PartesAnimadas:load(xmlFile)
	self.SetGrainFlap = SpecializationUtil.callSpecializationsFunction("SetGrainFlap");
	self.SetRightFlap = SpecializationUtil.callSpecializationsFunction("SetRightFlap");
	
	-- Animations --
	self.GrainFlapAnimation = getXMLString(xmlFile, "vehicle.GrainFlap#animationName");
	self.RightFlapAnimation = getXMLString(xmlFile, "vehicle.RightFlap#animationName");
	
	self.grainFlap = true;
	self.rightFlap = true;
end;

function PartesAnimadas:delete()
end;

function PartesAnimadas:readStream(streamId, connection)
	self:SetGrainFlap(streamReadBool(streamId), true);
	self:SetRightFlap(streamReadBool(streamId), true);
end;

function PartesAnimadas:writeStream(streamId, connection)
	streamWriteBool(streamId, self.grainFlap);
	streamWriteBool(streamId, self.rightFlap);
end;

function PartesAnimadas:readUpdateStream(streamId, timestamp, connection)
end;

function PartesAnimadas:writeUpdateStream(streamId, connection, dirtyMask)
end;

function PartesAnimadas:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PartesAnimadas:keyEvent(unicode, sym, modifier, isDown)
end;

function PartesAnimadas:update(dt)	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.Animacao1) then
			self:SetGrainFlap(not self.grainFlap);
		end;
		if InputBinding.hasEvent(InputBinding.Animacao2) then
			self:SetRightFlap(not self.rightFlap);
	end;
end;

function PartesAnimadas:updateTick(dt)	
end;

function PartesAnimadas:SetGrainFlap(grainFlapState,noEventSend)
	SetGrainFlapEvent.sendEvent(self, grainFlapState, noEventSend);
	if grainFlapState then
		if self.GrainFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.GrainFlapAnimation, -1, nil, true);
			self.grainFlap = true;
		end;
	else
		if self.GrainFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.GrainFlapAnimation, 1, nil, true);
			self.grainFlap = false;
		end;
	end;
end;

function PartesAnimadas:SetEngineFlap(engineFlapState,noEventSend)
end;

function PartesAnimadas:SetRightFlap(rightFlapState,noEventSend)
	SetRightFlapEvent.sendEvent(self, rightFlapState, noEventSend);
	if rightFlapState then
		if self.RightFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.RightFlapAnimation, -1, nil, true);
			self.rightFlap = true;
		end;
	else
		if self.RightFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.RightFlapAnimation, 1, nil, true);
			self.rightFlap = false;
		end;
	end;
end;

function PartesAnimadas:draw()
	if self.grainFlap then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Animacao1Abrir"), self.typeDesc), InputBinding.AnimatedParts_ToggleGrainFlap);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Animacao1Fechar"), self.typeDesc), InputBinding.AnimatedParts_ToggleGrainFlap);
	end;
	if self.rightFlap then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Animacao2Abrir"), self.typeDesc), InputBinding.AnimatedParts_ToggleRightFlap);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Animacao2Fechar"), self.typeDesc), InputBinding.AnimatedParts_ToggleRightFlap);
		end;
	end;
end;