--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.80, 0.26, 0.02, "NP_0: Turn HUD On");
	 else
		renderText(0.80, 0.26, 0.02, "NP_0: Turn HUD Off");
		renderText(0.72, 0.44, 0.025, "-- IH 1480 --");			
		renderText(0.72, 0.42, 0.02, "NP_Enter: Engine Start/Stop");
		renderText(0.72, 0.40, 0.02, "t: Auger Spreaders Pulleys On/Off");
		renderText(0.72, 0.38, 0.02, "w: Throttle hold down in hire mode");			
		renderText(0.72, 0.36, 0.02, "y: Lever hold down")
		renderText(0.72, 0.34, 0.02, "x: Shifter hold down");
    renderText(0.72, 0.30, 0.025, "KNAGSTED");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




