--
-- InteractiveControlPanel
-- Specialization for InteractiveControlPanel
--
-- @author:  	Manuel Leithner/Ptitminus73
-- @date:		14/02/12
-- @version:	v2.1
-- @history:	v1.0 - initial implementation
--				v2.0 - Converted to LS2011
--				v2.1 - Adapted from the Fertimax Carre
--

InteractiveControlPanel = {};

function InteractiveControlPanel.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Agronomic, specializations);
end;

function InteractiveControlPanel:load(xmlFile)
	
	self.detachPosition = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#detachPosition"));
	self.controlPanel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#index"));	
	self.attacherVehicleCopy = nil;
	
end;

function InteractiveControlPanel:delete()
end;

function InteractiveControlPanel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveControlPanel:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveControlPanel:update(dt)	
end;

function InteractiveControlPanel:draw()
end;

function InteractiveControlPanel:onAttach(attacherVehicle)
	self.attacherVehicleCopy = attacherVehicle;	
	if attacherVehicle.addControlPanel ~= nil then
		local wasSuccessful = attacherVehicle:addControlPanel(self);
	end;	
end;

function InteractiveControlPanel:onDetach()
	if self.attacherVehicleCopy.removeControlPanel ~= nil then
		local wasSuccessful = self.attacherVehicleCopy:removeControlPanel(self);
	end;

	self.attacherVehicleCopy = nil;
end;