--
-- Agronomic
-- Specialization for Agronomic cultivator. Work as a sprayer to simulate the cleaning of sugarbeets row.
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		24/08/2011
--

Agronomic = {}

function Agronomic.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function Agronomic:load(xmlFile)
	--Rotating parts
	self.numRotatingParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotatingParts#count"), 0);	
	self.RotatingParts = {};
    for i=1, self.numRotatingParts do
        local RotatingPartsnamei = string.format("vehicle.RotatingParts.RotatingPart" .. "%d", i);
        self.RotatingParts[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, RotatingPartsnamei .. "#index"));
    end;
end;

function Agronomic:delete()
end;

function Agronomic:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Agronomic:keyEvent(unicode, sym, modifier, isDown)
end;

function Agronomic:readStream(streamId, connection)
end;

function Agronomic:writeStream(streamId, connection)
end;

function Agronomic:readUpdateStream(streamId, timestamp, connection)
end;

function Agronomic:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Agronomic:update(dt)
	if self:getIsActive() then
        if self.isTurnedOn then
			-- rotate rotatingParts --
			for i=1, self.numRotatingParts do
				rotate(self.RotatingParts[i], 2 * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
			end;
		end;
	end;
end;
function Agronomic:updateTick(dt)
	if self.lowered and self.lastSpeed*3600 > 4 then
		self:setIsTurnedOn(true);
		if self.foldMoveDirection > 0.1 or (self.foldMoveDirection == 0 and self.foldAnimTime > 0.5) then
			self:setFoldDirection(-1)
		end;
	else
		self:setIsTurnedOn(false);
	end;
end;

function Agronomic:draw()
end;

function Agronomic:onAttach()
end;

function Agronomic:onSetLowered(lowered)
	self.lowered = lowered;
end;

function Agronomic:getIsTurnedOnAllowed(isTurnedOn)
	if not isTurnedOn or self.fillLevel > 0 or self.capacity == 0 then
		if self.lowered and self.lastSpeed*3600 > 4 then
			return true;
		end;
	end;
end;
