--
-- Washable
-- Specialization for Washable functionality
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v3.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - Changed xml-reading, added updateInterval to define updating interval for vehicles with many rustComponents (performance issue)
--				v3.0 - added network support, changed update to updateTick
--        v4.0 - copied to RustyTools
-- free for noncommerical-usage
--

RustyTool = {};

function RustyTool.prerequisitesPresent(specializations)
    return true;
end;

function RustyTool:load(xmlFile)

	self.increaseRust = SpecializationUtil.callSpecializationsFunction("increaseRust");
	self.decreaseRust = SpecializationUtil.callSpecializationsFunction("decreaseRust");
	self.unusualRustIncrease = SpecializationUtil.callSpecializationsFunction("unusualRustIncrease");
	
	local i = 0;
	self.rustComponents = {};
	while true do
		local path = string.format("vehicle.rust.rustComponent(%d)", i);
		local component = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#index"));	
		if component == nil then
			break;
		end;
		table.insert(self.rustComponents, component);
		i = i + 1;
	end;	
	
	self.updateInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rust#updateInterval"), 0.05);
	self.rustInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rust#rustInterval"), 1) * 60 * 60 * 1000;
	self.cleaningInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rust#cleaningInterval"), 30) * 1000;

	self.rustScale = 0;
	self.oldRustScale = self.rustScale;
	self.timeScale = 1;

end;

function RustyTool:readStream(streamId, connection)
    local rustScale = streamReadFloat32(streamId);
    self:unusualRustIncrease(rustScale);
end;

function RustyTool:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.rustScale);
end;

function RustyTool:delete()
end;

function RustyTool:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RustyTool:keyEvent(unicode, sym, modifier, isDown)
end;

function RustyTool:update(dt)
	if      RustyTool.staticRustCount ~= nil 
			and ( self.rustInvalidationCount == nil or self.rustInvalidationCount ~= RustyTool.staticRustCount ) then
		self.rustInvalidationCount = RustyTool.staticRustCount
		if self.rustScale ~= RustyTool.staticRustLevel then
			print(tostring(self.rustScale).." "..tostring(RustyTool.staticRustLevel))
			self.rustScale = RustyTool.staticRustLevel
		end
	end
	if      RustyTool.staticDirtCount ~= nil 
			and ( self.dirtInvalidationCount == nil or self.dirtInvalidationCount ~= RustyTool.staticDirtCount ) then
		self.dirtInvalidationCount = RustyTool.staticDirtCount
		if self.dirtScale ~= RustyTool.staticDirtLevel then
			print(tostring(self.dirtScale).." "..tostring(RustyTool.staticDirtLevel))
			self.dirtScale = RustyTool.staticDirtLevel
		end
	end
end;

function RustyTool:updateTick(dt)
	--if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
	--	self:increaseRust(dt);
	--else
	if self.ploughHasGroundContact then
		self:decreaseRust(dt);
	elseif not self:getIsActive() and not self.isActive then
		self:increaseRust(dt);
	end;	
	
	if math.abs(self.rustScale-self.oldRustScale) > self.updateInterval then
		for _, component in pairs(self.rustComponents) do
			setShaderParameter(component, "rustScale", self.rustScale, 0,0,0,false);
		end;
		self.oldRustScale = self.rustScale;
	end;
end;

function RustyTool:draw()
end;


function RustyTool:unusualRustIncrease(increase)
	if self.rustScale < 1 then
		self.rustScale = self.rustScale + increase;
		if self.rustScale > 1 then
			self.rustScale = 1;
		end;
	end;
end;

function RustyTool:increaseRust(dt)
	if self.rustScale > 1 then
		self.rustScale = 1;
	end;
	if self.rustScale < 1 then
		local scale = Utils.getMovedLimitedValues({self.rustScale}, {1}, {0}, 1, self.rustInterval*self.timeScale, dt, false);
		self.rustScale = scale[1];
	end;
end;

function RustyTool:decreaseRust(dt)
	if self.rustScale < 0 then
		self.rustScale = 0;
	end;
	if self.rustScale > 0 then
		local scale = Utils.getMovedLimitedValues({self.rustScale}, {1}, {0}, 1, self.cleaningInterval*self.timeScale, dt, true);
		self.rustScale = scale[1];
	end;
end;

function RustyTool:decreaseDirt(dt)
	if self.rustScale < 0 then
		self.rustScale = 0;
	end;
	if self.rustScale > 0 then
		local scale = Utils.getMovedLimitedValues({self.rustScale}, {1}, {0}, 1, self.cleaningInterval*self.timeScale, dt, true);
		self.rustScale = scale[1];
	end;
end;

function RustyTool:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.rustScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#rustLevel"),0);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function RustyTool:getSaveAttributesAndNodes(nodeIdent)	
    local attributes = 'rustLevel="'.. tostring(self.rustScale) .. '"';
    return attributes, nil;
end;

addConsoleCommand("setRust", "Overwrite rustLevel", "setRust", RustyTool);
function RustyTool:setRust(value)
	if value == nil then
		RustyTool.staticRustLevel = nil
		RustyTool.staticRustCount = nil
	else
		RustyTool.staticRustLevel = math.min( math.max( tonumber(value), 0), 1 )
		if RustyTool.staticRustCount == nil then
			RustyTool.staticRustCount = 0
		else
			RustyTool.staticRustCount = RustyTool.staticRustCount + 1
		end
	end
end
addConsoleCommand("setDirt", "Overwrite dirtLevel", "setDirt", RustyTool);
function RustyTool:setDirt(value)
	if value == nil then
		RustyTool.staticDirtLevel = nil
		RustyTool.staticDirtCount = nil
	else
		RustyTool.staticDirtLevel = math.min( math.max( tonumber(value), 0), 1 )
		if RustyTool.staticDirtCount == nil then
			RustyTool.staticDirtCount = 0
		else
			RustyTool.staticDirtCount = RustyTool.staticDirtCount + 1
		end
	end
end
