-- LS09 xyzspain
-- LS11 mp ready Hummel (modhoster.de) 28.07.2011
-- LS13 ready Biedens & Upsidedown (modhoster.de) 15.05.2014

RWPackomat = {};

--RWPackomat_mt = { __index = function (table, key) return PackomatBase[key] end }
--setmetatable( RWPackomat, RWPackomat_mt )

function RWPackomat.prerequisitesPresent(specializations)
	return true;
end;

function RWPackomat:load(xmlFile)
	----- deep wheel
	local index = getXMLString(xmlFile, "vehicle.deeRWheel#index")
	if index ~= nil then
		self.deeRWheel = Utils.indexToObject(self.components, index);
	end
	
	self.getIsSelectable = RWPackomat.getIsSelectable;
	
	self.widthAdjust = {}
	self.widthAdjust.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kvernelandWidthAdjust#index"));
			
  local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kvernelandWidthAdjust#minTrans"));
  self.widthAdjust.minTrans = {};
  self.widthAdjust.minTrans[1] = Utils.getNoNil(x, 0);
  self.widthAdjust.minTrans[2] = Utils.getNoNil(y, 0);
  self.widthAdjust.minTrans[3] = Utils.getNoNil(z, 0);

  x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kvernelandWidthAdjust#maxTrans"));
  self.widthAdjust.maxTrans = {};
  self.widthAdjust.maxTrans[1] = Utils.getNoNil(x, 0);
  self.widthAdjust.maxTrans[2] = Utils.getNoNil(y, 0);
  self.widthAdjust.maxTrans[3] = Utils.getNoNil(z, 0);

	self.widthAdjust.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kvernelandWidthAdjust#transTime"), 2)*1000;    
			
	self.widthAdjustCurrentAlpha = nil
	self.widthAdjustTargetAlpha  = 0
	
	self.isPloughTurningRotation = 1
	
	self.deepWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deepWheel#index"));
end;

function RWPackomat:delete()
end;

function RWPackomat:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RWPackomat:draw()
	if      self.attacherVehicle               ~= nil 
			and self.attacherVehicle.packomatBase  == nil
			and not self.isLowering 
			and self:getIsActiveForInput(true) then
		if self.widthAdjustTargetAlpha < 10 then
			g_currentMission:addHelpButtonText( string.format( g_i18n:getText("RW_Packomat_Left"), 10 * self.widthAdjustTargetAlpha ), InputBinding.RW_Packomat_Left);
		end;
		if self.widthAdjustTargetAlpha > 0 then
			g_currentMission:addHelpButtonText( string.format( g_i18n:getText("RW_Packomat_Right"), 10 * self.widthAdjustTargetAlpha ), InputBinding.RW_Packomat_Right);
		end;
	end;
end;

function RWPackomat:keyEvent(unicode, sym, modifier, isDown)
end;
 
function RWPackomat:update(dt)

	if      self:getIsActiveForInput() 
			and self.attacherVehicle               ~= nil 
			and self.attacherVehicle.packomatBase  == nil
			and not self.isLowering then
		if InputBinding.isPressed(InputBinding.RW_Packomat_Left) then
			self:setStateEvent("widthAdjustTargetAlpha", math.min(self.widthAdjustTargetAlpha+1,10) )
		end
		if InputBinding.isPressed(InputBinding.RW_Packomat_Right) then
			self:setStateEvent("widthAdjustTargetAlpha", math.max(self.widthAdjustTargetAlpha-1,0))
		end
	end

	self.rotParts[1].max  = nil
	
	if self.attacherVehicle == nil then
		self.rotParts[1].target = 0
	else
		self.rotParts[1].target = -0.5 + 1.5 * self.smallWidth
	end

	self.rotation[1].max = self.rotateLeftToMax
	self.widthAdjust.max = self.widthAdjustMax
	self.widthAdjust.min = self.widthAdjustMin
	
	if self.rotateLeftToMax or self.transport then
		self.allowsDetaching = false
	end

--if self:getIsActiveForInput() then
--	self.allowsLowering = self.isLowering
--else
--	self.allowsLowering = true
--end
	
	if self.attacherVehicle ~= nil then
		self.translation[1].max = true;
		self.translation[2].max = true;
		self.rotation[7].max=true;
		self.rotation[15].target=0;
	--end;
		---recolocar cultivador en posicion 
			
		local rx,ry,rz = 0,0,0
		if self.rotateLeftToMax then
			rx,ry,rz = getRotation( self.wheels[2].repr )
			rx = -rx
			
			self.rotation[13].max=true;
			self.rotation[14].max=true;
			if not self.sound1Enabled  and not self.AIon and self:getIsActiveForSound() then
				setSamplePitch(self.sound1, self.sound1PitchOffset);
				playSample(self.sound1, 0, self.sound1Volume, 0);
				self.sound1Enabled = true;
			end;
			local x, y, z = getRotation(self.rotation[1].node);
			if z < Utils.degToRad(-110) or self.transport then
				self.rotation[4].max=true;
				if self.cultivator > 0.5 then
					self.rotation[11].max=true;
					self.rotation[10].max=false;
					self.rotation[9].max=true;
					self.rotation[8].max=false;
					self.rotation[12].target=0;
				else
					self.rotation[8].max=false;
					self.rotation[9].max=false;
					self.rotation[10].max=false;
					self.rotation[11].max=false;
					if self.attacherVehicle.packomatBase ~= nil then
						self.rotation[12].target=2;
						self.rotation[15].target=2;
					else
						self.rotation[12].target=0;
					end
				end
			elseif self.attacherVehicle.packomatBase == nil then
				self.rotParts[1].target = 1
			end;
			if z < Utils.degToRad(-120) or self.transport then
				local f = 1
				if self.kvernelandHeightControlHeight > self.kvernelandHeightBaseHeight then
					f = 0.5
				end
				self.rotation[6].target = 1 - f * ( self.kvernelandHeightBaseHeight - self.kvernelandHeightControlHeight );
			
			end;
			if z < Utils.degToRad(-150) or self.transport then
				self.rotation[5].max=true;
			end;
			if z < Utils.degToRad(-178) or self.transport then
			
				local x,y,z = getRotation(self.wheels[1].repr);	
				setRotation(self.deeRWheel,(x*-1), y, z);
				if self.sound1Enabled then ---desactivar sound1
					stopSample(self.sound1);
					self.sound1Enabled = false;
				end;
				self.rotation[3].max=false;
				self.rotation[2].max=false;
				
			end;
			
		else
			rx,ry,rz = getRotation( self.wheels[1].repr )
		
			self.rotation[13].max=false;
			self.rotation[14].max=false;
			if not self.sound1Enabled  and not self.AIon and self:getIsActiveForSound() then
				setSamplePitch(self.sound1, self.sound1PitchOffset);
				playSample(self.sound1, 0, self.sound1Volume, 0);
				self.sound1Enabled = true;
			end;
			local x, y, z = getRotation(self.rotation[1].node);
			if self.transport then z = 0 end
			if z > Utils.degToRad(-70)  then
				self.rotation[5].max=false;
				if self.cultivator > 0.5 then
					self.rotation[12].target=0;
					self.rotation[11].max=false;
					self.rotation[10].max=false;
					self.rotation[9].max=false;
					self.rotation[8].max=true;
				else
					self.rotation[8].max=false;
					self.rotation[9].max=false;
					self.rotation[10].max=true;
					self.rotation[11].max=false;
					if self.attacherVehicle.packomatBase ~= nil then
						self.rotation[12].target=2;
						self.rotation[15].target=2;
					else
						self.rotation[12].target=0;
					end
				end;
			elseif self.attacherVehicle.packomatBase == nil then
				self.rotParts[1].target = 1
			end;
			if z > Utils.degToRad(-60) or self.transport then
				local f = 1
				if self.kvernelandHeightControlHeight > self.kvernelandHeightBaseHeight then
					f = 0.5
				end
				self.rotation[6].target = 0 + f * ( self.kvernelandHeightBaseHeight - self.kvernelandHeightControlHeight );
				
			end;
			if z > Utils.degToRad(-50) or self.transport  then
				self.rotation[4].max=false;
			end;
			if z > Utils.degToRad(-1) or self.transport  then
		
				local x,y,z = getRotation(self.wheels[2].repr);	
				setRotation(self.deeRWheel, x, y, z);
				if self.sound1Enabled then ---desactivar sound1
					stopSample(self.sound1);
					self.sound1Enabled = false;
				end;

				self.rotation[3].max=false;
				self.rotation[2].max=false;
				
			end;
		end;		

		if self.transport  then
			rx,ry,rz = 0,0,0
			
			self.rotation[8].max=false;
			self.rotation[9].max=false;
			self.rotation[10].max=false;
			self.rotation[11].max=false;
			self.rotation[12].target=0;
			self.rotation[13].max=true;
			self.rotation[14].max=false;
			
			if self.rotateLeftToMax then
				self.rotation[3].max=true;
				self.rotation[2].max=false;
			else
				self.rotation[3].max=false;
				self.rotation[2].max=true;
			end
			
			--if self.attacherVehicle.packomatBase == nil then
				self.rotParts[1].target = 1
			--else
			--	self.rotParts[1].max = false
			--end
		end
		
		setRotation( self.deepWheel, rx, ry, rz )
	else
		self.translation[1].max = false;
		self.translation[2].max = false;
		self.rotation[7].max=false;
	end;

	if self.fixStartPositionTime == nil or self.fixStartPositionTime > 1500 then 	

		local widthAdjustTargetAlpha = self.widthAdjustTargetAlpha
		if      self.attacherVehicle               ~= nil 
				and self.attacherVehicle.setStateEvent ~= nil
				and self.attacherVehicle.packomatBase  ~= nil then
			widthAdjustTargetAlpha = 10 
		end

		local moveWidth = true
		local delta     = dt / self.widthAdjust.transTime
		if     self.widthAdjustCurrentAlpha == nil then
			self.widthAdjustCurrentAlpha = widthAdjustTargetAlpha
		elseif self.widthAdjustCurrentAlpha < widthAdjustTargetAlpha then
			self.widthAdjustCurrentAlpha = math.min( self.widthAdjustCurrentAlpha + delta, widthAdjustTargetAlpha )
		elseif self.widthAdjustCurrentAlpha > widthAdjustTargetAlpha then
			self.widthAdjustCurrentAlpha = math.max( self.widthAdjustCurrentAlpha - delta, widthAdjustTargetAlpha )
		else
			moveWidth = false
		end
		
		if moveWidth then		
			self.isRotating = true
			local x = self.widthAdjust.minTrans[1] + 0.1*self.widthAdjustCurrentAlpha*( self.widthAdjust.maxTrans[1] - self.widthAdjust.minTrans[1] )
			local y = self.widthAdjust.minTrans[2] + 0.1*self.widthAdjustCurrentAlpha*( self.widthAdjust.maxTrans[2] - self.widthAdjust.minTrans[2] )
			local z = self.widthAdjust.minTrans[3] + 0.1*self.widthAdjustCurrentAlpha*( self.widthAdjust.maxTrans[3] - self.widthAdjust.minTrans[3] )
			
			setTranslation(self.widthAdjust.node, x, y, z);
		end
		
	else
		self.rotation[8].max=false;
		self.rotation[9].max=false;
		self.rotation[10].max=false;
		self.rotation[11].max=false;
		self.translation[1].max = false;
		self.translation[2].max = false;
		self.rotation[7].max=false;
	end
	
--self.rotation[12].target=0;
end;

function RWPackomat:onAttach(attacherVehicle, jointDescIndex)
	self.rotation[7].max=true;
	self.translation[1].max = true;
	self.translation[2].max = true;
	--self.transport = true;
end;

function RWPackomat:onDetach(attacherVehicle, jointDescIndex)
  self.ploughLimitToField=true;
	self.rotation[8].max=false;
	self.rotation[9].max=false;
	self.rotation[10].max=false;
	self.rotation[11].max=false;
	self:setStateEvent("isLowering",false)
	if not self.rotation[1].max then
		self.translation[1].max = false;
		self.translation[2].max = false;
		self.rotation[7].max=false;
	end;
	PackomatBase.onLeave( self )
end;

function RWPackomat:getIsSelectable()
	if      self.attacherVehicle               ~= nil 
			and self.attacherVehicle.setStateEvent ~= nil
			and self.attacherVehicle.packomatBase  ~= nil then
		if self.time > self.onAttachedTime + 2000 then
			return Vehicle.getIsSelectable(self)
		else
			return false
		end
	else
		return Vehicle.getIsSelectable(self)
	end
end

function PackomatBase:readStream(streamId, connection)  
	self.widthAdjustTargetAlpha = streamReadFloat32(streamId)
end

function PackomatBase:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.widthAdjustTargetAlpha)
end;
------------------------------------------------------------------------
-- getSaveAttributesAndNodes
------------------------------------------------------------------------
function RWPackomat:getSaveAttributesAndNodes(nodeIdent)

	local attributes = ""

	--self.widthAdjust.curAlpha = 0
	--setTranslation(self.widthAdjust.node, unpack(self.widthAdjust.minTrans));

	attributes = attributes.." RWPackomatWidth=\"" .. tostring(self.widthAdjustTargetAlpha) .. "\""

	return attributes
end;

------------------------------------------------------------------------
-- loadFromAttributesAndNodes
------------------------------------------------------------------------
function RWPackomat:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	local value = getXMLInt(xmlFile, key .. "#RWPackomatWidth")
	if value ~= nil then
		self.widthAdjustTargetAlpha  = math.min(math.max(value,0),10)
		self.widthAdjustCurrentAlpha = nil
	end
	
	return BaseMission.VEHICLE_LOAD_OK;
end
