-- www.LS-Landtechnik.de
-- @author  LS-Landtechnik.de
-- @date:		21.05.2014
-- @version:	v2.2
-- @copyright:	LS-Landtechnik.de
-- @edit 2.1 byBullgore www.modhoster.de
-- @edit 2.2 byMogli http://www.modhoster.de/community/user/biedens


Einblendung = {};

function Einblendung.prerequisitesPresent(specializations)
    return true;
end;
function Einblendung:load(xmlFile)
	self.setblends1Visibility = SpecializationUtil.callSpecializationsFunction("setblends1Visibility");
	self.setblends2Visibility = SpecializationUtil.callSpecializationsFunction("setblends2Visibility");
	
  self.blends1 = {};
  local i = 0;
  while true do
		local key = string.format("vehicle.blends1.blend1(%d)", i);
    if not hasXMLProperty(xmlFile, key) then
			break;
		end;
    local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
    if node ~= nil then
			setVisibility(node, true);
			local entry = {}
			entry.node = node
			entry.mass = getMass(node)
			entry.colli = getCollisionMask(node)
			table.insert(self.blends1, entry);
		end;
		i = i + 1;
  end;
  self.blends1Active = true;
	self.blends1Time = 0
	
  self.blends2 = {};
	local i = 0;
	while true do
	local key = string.format("vehicle.blends2.blend2(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		if node ~= nil then
			setVisibility(node, true);
			entry.node = node
			entry.mass = getMass(node)
			entry.colli = getCollisionMask(node)
			table.insert(self.blends2, entry);
		end;
		i = i + 1;
  end;
	self.blends2Active = true;
	self.blends2Time = 0
end;
function Einblendung:delete()
end;
function Einblendung:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setblends1Visibility(visibility, true);
	local visibility = streamReadBool(streamId);
	self:setblends2Visibility(visibility, true);
end;

function Einblendung:writeStream(streamId, connection)
	streamWriteBool(streamId, self.blends1Active);
	streamWriteBool(streamId, self.blends2Active);
end;
function Einblendung:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Einblendung:keyEvent(unicode, sym, modifier, isDown)
end;
function Einblendung:update(dt)

	--if self:getIsActiveForInput() and self.isClient then
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.EinblendungEins) then
			self:setblends1Visibility(not self.blends1Active);
			self.blends2Time = self.time;
		end;
		if InputBinding.hasEvent(InputBinding.EinblendungZwei) then
			self:setblends2Visibility(not self.blends2Active);
			self.blends1Time = self.time;
		end;
	end;
	
	if self.blends1Time > 0 then
		local f = 0.001 * ( self.time - self.blends1Time )
		if f > 1 then
		  self.blends1Time = 0
			f = 1
		elseif f < 0 then
			f = 0
		end
		
		if not self.blends1Active then
		  f = 1 - f
		end
		
    for _, blend1 in pairs(self.blends1) do
			setMass(blend1.node,math.max( 1E-6, f * blend1.mass) )
    end;
	end;

	if self.blends2Time > 0 then
		local f = 0.001 * ( self.time - self.blends2Time )
		if f > 1 then
		  self.blends1Time = 0
			f = 1
		elseif f < 0 then
			f = 0
		end
		
		if not self.blends2Active then
		  f = 1 - f
		end
		
    for _, blend2 in pairs(self.blends2) do
			setMass(blend2.node,math.max( 1E-6, f * blend2.mass) )
    end;
	end;
end;
function Einblendung:onLeave()
end;
function Einblendung:draw()
  if self:getIsActiveForInput(true) then
		if self.blends1 ~= nil and table.getn( self.blends1 ) > 0 then
			g_currentMission:addHelpButtonText(g_i18n:getText("EinblendungEins"), InputBinding.EinblendungEins)
		end
		if self.blends2 ~= nil and table.getn( self.blends2 ) > 0 then
			g_currentMission:addHelpButtonText(g_i18n:getText("EinblendungZwei"), InputBinding.EinblendungZwei)
		end
	end
end;
function Einblendung:setblends1Visibility(visibility, noEventSend)
  if visibility ~= self.blends1Active then
  
    if noEventSend == nil or noEventSend == false then
      if g_server ~= nil then
          g_server:broadcastEvent(Setblends1Event:new(self, visibility), nil, nil, self);
      else
          g_client:getServerConnection():sendEvent(Setblends1Event:new(self, visibility));
      end;
    end;
  
    self.blends1Active = visibility;
  
    for _, blend1 in pairs(self.blends1) do
      setVisibility(blend1.node, visibility);
			if visibility then
				setCollisionMask(blend1.node,blend1.colli)
			else
				setCollisionMask(blend1.node,0)
			end
    end;
    for _,v in pairs(self.specializations) do
      if v.setblend1Visibility ~= nil then
        v.setblend1Visibility(self, visibility);
      end;
    end;
  end;
end;
function Einblendung:setblends2Visibility(visibility, noEventSend)
  if visibility ~= self.blends2Active then
  
    if noEventSend == nil or noEventSend == false then
      if g_server ~= nil then
          g_server:broadcastEvent(Setblends2Event:new(self, visibility), nil, nil, self);
      else
          g_client:getServerConnection():sendEvent(Setblends2Event:new(self, visibility));
      end;
    end;
  
    self.blends2Active = visibility;
  
    for _, blend2 in pairs(self.blends2) do
      setVisibility(blend2.node, visibility);
			if visibility then
				setCollisionMask(blend1.node,blend2.colli)
			else
				setCollisionMask(blend2.node,0)
			end
    end;
    for _,v in pairs(self.specializations) do
      if v.setblend2Visibility ~= nil then
        v.setblend2Visibility(self, visibility);
      end;
    end;
  end;
end;

