-- xyzspain
PackomatBase = {};

function PackomatBase.prerequisitesPresent(specializations)
	return true;
end;

function PackomatBase:load(xmlFile)

	self.setStateEvent           = SpecializationUtil.callSpecializationsFunction("setStateEvent");
	self.setPloughLimitToField   = SpecializationUtil.callSpecializationsFunction("setPloughLimitToField");
 	self.onPackomatTransport     = SpecializationUtil.callSpecializationsFunction("onPackomatTransport");
	self.onPackomatLowering      = SpecializationUtil.callSpecializationsFunction("onPackomatLowering");
	self.onPackomatRotate        = SpecializationUtil.callSpecializationsFunction("onPackomatRotate");
	self.onPackomatSmallWidth    = SpecializationUtil.callSpecializationsFunction("onPackomatSmallWidth");
	self.onPackomatCultivator    = SpecializationUtil.callSpecializationsFunction("onPackomatCultivator");
	
  self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel
  self.aiTerrainDetailChannel2 = g_currentMission.sowingWidthChannel
	--self.aiTerrainDetailProhibitedMask = bitOR( 2 ^ g_currentMission.cultivatorChannel, 2 ^ g_currentMission.ploughChannel )
	
  self.onlyActiveWhenLowered = true
  self.ploughHasGroundContact = false
  self.rotationMax = false
  self.speedViolationMaxTime = 2500
  self.speedViolationTimer = self.speedViolationMaxTime
  self.ploughContactReportsActive = false
  self.startActivationTimeout = 2000
  self.startActivationTime = 0
  self.ploughLimitToField = true
	
	for i=2,table.getn(self.components) do
		for j=1,i-1 do
			setPairCollision(self.components[j].node, self.components[i].node, false)
		end
	end
	
	-------------------------
	-- desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	self.updateAnimations      = SpecializationUtil.callSpecializationsFunction("updateAnimations");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------------
	local i = 1
	self.translation = {}
	while true do
		do
			local baseName = string.format( "vehicle.translation%d", i )
      local index = getXMLString(xmlFile, baseName .. "#index")
      if index == nil then
        break
      end
			local translationNode = Utils.indexToObject(self.components, index);
			
			if translationNode ~= nil then
        local entry = {};
        entry.node = translationNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName .. "#minTrans"));
        entry.minTrans = {};
        entry.minTrans[1] = Utils.getNoNil(x, 0);
        entry.minTrans[2] = Utils.getNoNil(y, 0);
        entry.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName .. "#maxTrans"));
        entry.maxTrans = {};
        entry.maxTrans[1] = Utils.getNoNil(x, 0);
        entry.maxTrans[2] = Utils.getNoNil(y, 0);
        entry.maxTrans[3] = Utils.getNoNil(z, 0);

				entry.transTime = Utils.getNoNil(getXMLString(xmlFile, baseName .. "#transTime"), 2)*1000;    
				entry.testMoving = Utils.getNoNil(getXMLBool(xmlFile, baseName .. "#testMoving"), true) 
				
				table.insert( self.translation, entry )
			end;
      i = i + 1
    end
  end

	i = 1
	self.rotation = {}
	while true do
		do
			local baseName = string.format( "vehicle.rotation%d", i )
      local index = getXMLString(xmlFile, baseName .. "#index")
      if index == nil then
        break
      end
			local rotationNode = Utils.indexToObject(self.components, index);
	
			if rotationNode ~= nil then
        local entry = {};
        entry.node = rotationNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName .. "#minRot"));
        entry.minRot = {};
        entry.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        entry.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        entry.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName .. "#maxRot"));
        entry.maxRot = {};
        entry.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        entry.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        entry.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        entry.rotTime = Utils.getNoNil(getXMLString(xmlFile, baseName .. "#rotTime"), 2)*1000;
				entry.testMoving = Utils.getNoNil(getXMLBool(xmlFile, baseName .. "#testMoving"), true) 

				table.insert( self.rotation, entry )
			end;
      i = i + 1
    end
  end

	i = 1
	self.rotParts = {}
	while true do
		do
			local baseName = string.format( "vehicle.RotParts%d", i )
			local numRotParts = getXMLInt(xmlFile, baseName.."#count")
			if numRotParts == nil then
				break
			end
				
			entry = {};
			entry.testMoving = Utils.getNoNil(getXMLBool(xmlFile, baseName .. "#testMoving"), true) 
			entry.rotTime = Utils.getNoNil(getXMLString(xmlFile,  baseName .. "#rotSpeed"), 2)*1000;
			entry.parts = {}
			
			for i=1, numRotParts do
				local partnamei = string.format(baseName..".part%d", i);
				local rotPart = {};
				rotPart.index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
				local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
				rotPart.minRot = {};
				rotPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
				rotPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
				rotPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
				x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
				rotPart.maxRot = {};
				rotPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
				rotPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
				rotPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

				table.insert( entry.parts, rotPart )
			end;
			table.insert( self.rotParts, entry )
      i = i + 1
    end
  end
		
	-------------------------
	self.kvernelandFurrows   = {}
	self.kvernelandPackomats = {}

	for k,tagName in pairs({"kvernelandFurrow","kvernelandPackomat"}) do		
		local i = 0
		while true do
			do
				local baseName = "vehicle."..tagName.."s."..tagName..string.format( "(%d)", i )
				if not hasXMLProperty(xmlFile, baseName) then
					break
				end
		
				local entry = {}
				entry.cuttingArea = {}
				entry.cuttingArea.start           = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#startIndex"));
				entry.cuttingArea.width           = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#widthIndex"));
				entry.cuttingArea.height          = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#heightIndex"));
				entry.cuttingArea.groundThreshold = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#groundThreshold"), 0.2);
				entry.cuttingArea.groundIndex     = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#groundIndex"));
				
				entry.groundParticleSystemsDisableTime = 0;		
				entry.groundContact = false
				
				local psCount = Utils.getNoNil(getXMLInt(xmlFile, baseName..".groundParticleSystems#count"), 0);
				for j=1, psCount do
					if entry.groundParticleSystems == nil then
						entry.groundParticleSystems = {};
					end
					local namei = string.format( baseName..".groundParticleSystems.part%d", j );
					local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
					Utils.loadParticleSystem(xmlFile, entry.groundParticleSystems, namei, nodei, false, nil, self.baseDirectory)	
					Utils.setEmittingState(entry.groundParticleSystems,false)
				end;
				
				local psCount = Utils.getNoNil(getXMLInt(xmlFile, baseName..".groundParticleSystems1#count"), 0);
				for j=1, psCount do
					if entry.groundParticleSystems1 == nil then
						entry.groundParticleSystems1 = {};
					end
					local namei = string.format( baseName..".groundParticleSystems1.part%d", j );
					local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
					Utils.loadParticleSystem(xmlFile, entry.groundParticleSystems1, namei, nodei, false, nil, self.baseDirectory)	
					Utils.setEmittingState(entry.groundParticleSystems1,false)
				end;
				
				table.insert( self[tagName.."s"], entry )
				i = i + 1
			end
		end

		local directionIndex = getXMLString(xmlFile, "vehicle."..tagName.."s#directionIndex");
		local raiseTimeout   = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle."..tagName.."s#raiseTimeout"), 1) * 1000;
		local lowerTimeout   = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle."..tagName.."s#lowerTimeout"), 0) * 1000;
		local node = self.components[1].node
		if directionIndex ~= nil then
			node = Utils.indexToObject(self.components, directionIndex)
		end

		if k==1 then
			self.directionPlough        = node
			self.PloughRaiseTimeout     = raiseTimeout
			self.PloughLowerTimeout     = lowerTimeout
		else
			self.directionCultivator    = node
			self.CultivatorRaiseTimeout = raiseTimeout			
			self.CultivatorLowerTimeout = lowerTimeout			
		end
	end
	
		-------------------------
  local ploughSound = getXMLString(xmlFile, "vehicle.ploughSound#file");
  if ploughSound ~= nil and ploughSound ~= "" then
    ploughSound = Utils.getFilename(ploughSound, self.baseDirectory); 
    self.ploughSound = createSample("ploughSound");
    self.ploughSoundEnabled = false;
    loadSample(self.ploughSound, ploughSound, false);
    self.ploughSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughSound#pitchOffset"), 1);
    self.ploughSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughSound#volume"), 1);
  end;
	local cultivatorSound = getXMLString(xmlFile, "vehicle.cultivatorSound#file");
  if cultivatorSound ~= nil and cultivatorSound ~= "" then
    cultivatorSound = Utils.getFilename(cultivatorSound, self.baseDirectory); 
    self.cultivatorSound = createSample("cultivatorSound");
    self.cultivatorSoundEnabled = false;
    loadSample(self.cultivatorSound, cultivatorSound, false);
    self.cultivatorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#pitchOffset"), 1);
    self.cultivatorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#volume"), 1);
  end;
	-------------------------
		--------------
	local ploughTurnSound = getXMLString(xmlFile, "vehicle.ploughTurnSound#file");
  if ploughTurnSound ~= nil and ploughTurnSound ~= "" then
    ploughTurnSound = Utils.getFilename(ploughTurnSound, self.baseDirectory); 
    self.ploughTurnSound = createSample("ploughTurnSound");
    self.ploughTurnSoundEnabled = false;
    loadSample(self.ploughTurnSound, ploughTurnSound, false);
    self.ploughTurnSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughTurnSound#pitchOffset"), 1);
    self.ploughTurnSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughTurnSound#volume"), 1);
  end;
	
	----------------------------------
		---libertad bloques
	self.setJointRotLimit = SpecializationUtil.callSpecializationsFunction("setJointRotLimit");
	self.arm = {};
	
	--self.kvernelandHeightControl
	local baseName = "vehicle.kvernelandHeightControl"
	if hasXMLProperty(xmlFile, baseName) then
		self.kvernelandHeightControlIndex  = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#index"));
		self.kvernelandHeightControlHeight = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#height"), 0.6);
		self.kvernelandHeightBaseHeight    = self.kvernelandHeightControlHeight;
		self.kvernelandHeightMinHeight     = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#minHeight"), self.kvernelandHeightControlHeight-0.20);
		self.kvernelandHeightMaxHeight     = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#maxHeight"), self.kvernelandHeightControlHeight+0.20);
		self.kvernelandHeightRealFactor    = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#realFactor"),5);
	end
	
	----------
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
	-- self.isLowering=false;
	self.smallWidth= 0.2;
	self.cultivator=0;
	self.isLowering=false;
	self.isLoweringTime=0;
	self.rotateLeftToMax= false;
	self.isRotating=false;
	self.isRotatingIndex=1;
	self.cultivatorHidden=false;
	self.isPloughTurningRotation=0;
	self.isPloughTurning=false;

	self.packomatBase = {}
end;

function PackomatBase:postLoad(xmlFile)

	self.packomatBase.aiLeftMarker  = self.aiLeftMarker 
	self.packomatBase.aiRightMarker = self.aiRightMarker
	self.packomatBase.aiBackMarker  = self.aiBackMarker 
	
	if self.attacherJoint ~= nil then
		self.packomatBase.lowerDistanceToGround = self.attacherJoint.lowerDistanceToGround
	end
end

function PackomatBase:delete()

	if self.ploughSound ~= nil then
		delete(self.ploughSound);
	end;
  if self.cultivatorSound ~= nil then
		delete(self.cultivatorSound);
  end;
	if self.ploughTurnSound ~= nil then
		delete(self.ploughTurnSound);
  end;

	Utils.deleteParticleSystem(self.groundParticleSystems)
	Utils.deleteParticleSystem(self.groundParticleSystems1)
	Utils.deleteParticleSystem(self.groundParticleSystems2)

	for k,tagName in pairs({"kvernelandFurrows","kvernelandPackomats"}) do		
		for i,entry in pairs(self[tagName]) do
			if entry.groundParticleSystems1 ~= nil then
				Utils.deleteParticleSystem(entry.groundParticleSystems1)
			end
			if entry.groundParticleSystems  ~= nil then
				Utils.deleteParticleSystem(entry.groundParticleSystems)
			end
		end                  
	end
end;

function PackomatBase:mouseEvent(posX, posY, isDown, isUp, button)
end;
function PackomatBase:keyEvent(unicode, sym, modifier, isDown)
end;

-- *******************************************************************************************************************************	
-- *******************************************************************************************************************************	
-- *******************************************************************************************************************************	
function PackomatBase:updateTick(dt)
	
  --if self:getIsActive() then

		self.ploughHasGroundContact      = false
		self.cultivatorHasGroundContact  = false
		self.showFieldNotOwnedWarning    = false
		
			----------areas y particulas--------------
		if      self.attacherVehicle ~= nil
				and not self.isPloughTurning
				and not self.transport
				and ( self.isLowering or self.time < self.isLoweringTime + math.max( self.PloughRaiseTimeout, self.CultivatorRaiseTimeout ) )
				then

			-- plough
			
			for k,tagName in pairs({"kvernelandFurrows","kvernelandPackomats"}) do		
				local cuttingAreasSend  = {}
				local area = 0;	
				
				for i, entry in pairs(self[tagName]) do
					local skip = false
					local groundContact = false
					local timeout = 0
					local cuttingArea = entry.cuttingArea
					local x,y,z = getWorldTranslation(cuttingArea.start);

					if ( self.cultivator > 0.5 or self.cultivatorHidden ) and k==2 then
						skip = true;
					elseif self.isLowering then
						if k==1 then
							timeout = self.PloughLowerTimeout
						else
							timeout = self.CultivatorLowerTimeout
						end
						
						skip = ( timeout > 0 ) and ( self.time < self.isLoweringTime + timeout )
					else
						if k==1 then
							timeout = self.PloughRaiseTimeout
						else
							timeout = self.CultivatorRaiseTimeout
						end

						skip = ( self.time > self.isLoweringTime + timeout )
					end
					
					if not skip then
						local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
						
						if y - terrainHeight <= cuttingArea.groundThreshold then
							groundContact = true
						end
					end						
						
					if groundContact ~= entry.groundContact then
						entry.groundContact            = groundContact
						self[tagName][i].groundContact = groundContact
					end						
					
					if entry.groundContact then
						if k == 1 then
							if i == 1 and not g_currentMission:getIsFieldOwnedAtWorldPos(x, z) then
								self.showFieldNotOwnedWarning = true
							end
							self.ploughHasGroundContact = true
						else
							self.cultivatorHasGroundContact = true
						end

						if self.isServer then
							local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
							local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
							table.insert(cuttingAreasSend, { x, z, x1, z1, x2, z2 })
						end
								
						if self.isClient then						
							if self.attacherVehicle.lastSpeed*3600 > 3  then
								if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
									self[tagName][i].groundParticleSystemsDisableTime = self.time + 40;
									if self.rotateLeftToMax and entry.groundParticleSystems1 ~= nil then
										Utils.setEmittingState(entry.groundParticleSystems1, true)
										if entry.groundParticleSystems  ~= nil then
											Utils.setEmittingState(entry.groundParticleSystems, false)
										end
									else
										if entry.groundParticleSystems1 ~= nil then
											Utils.setEmittingState(entry.groundParticleSystems1, false)
										end
										if entry.groundParticleSystems  ~= nil then
											Utils.setEmittingState(entry.groundParticleSystems, true)
										end
									end;
								end;
							elseif self.attacherVehicle.lastSpeed*3600 < 3 then
								if entry.groundParticleSystems1 ~= nil then
									Utils.setEmittingState(entry.groundParticleSystems1, false)
								end
								if entry.groundParticleSystems  ~= nil then
									Utils.setEmittingState(entry.groundParticleSystems, false)
								end
							end;
						end
					else
						if entry.groundParticleSystems1 ~= nil then
							Utils.setEmittingState(entry.groundParticleSystems1, false)
						end
						if entry.groundParticleSystems  ~= nil then
							Utils.setEmittingState(entry.groundParticleSystems, false)
						end
					end
				end	

				if 0 < table.getn(cuttingAreasSend) then
					local limitToField
					if k == 1 then
						limitToField = self.ploughLimitToField
					else
						limitToField = true
					end
					
					-- kill grass only inside the field
					local limitGrassDestructionToField = limitToField
					
					if not g_currentMission:getHasPermission("createFields", self:getOwner()) then
						limitToField = true
						limitGrassDestructionToField = true
					end
					
					local realArea, dx, dz = 0, 0, 1
					if k == 1 then
						dx, _, dz = localDirectionToWorld(self.directionPlough, 0, 0, 1)
					else
						dx, _, dz = localDirectionToWorld(self.directionCultivator, 0, 0, 1)
					end
					local angle = Utils.convertToDensityMapAngle(Utils.getYRotationFromDirection(dx, dz), g_currentMission.terrainDetailAngleMaxValue)
					
					if k == 1 then
						realArea = PloughAreaEvent.runLocally(cuttingAreasSend, limitToField, limitGrassDestructionToField, angle)
						g_server:broadcastEvent(PloughAreaEvent:new(cuttingAreasSend, limitToField, limitGrassDestructionToField, angle))
					else
						realArea = CultivatorAreaEvent.runLocally(cuttingAreasSend, limitToField, limitGrassDestructionToField, angle)
						g_server:broadcastEvent(CultivatorAreaEvent:new(cuttingAreasSend, limitToField, limitGrassDestructionToField, angle))
					end
					
					local pixelToSqm = g_currentMission:getFruitPixelsToSqm()
					local sqm = realArea * pixelToSqm
					local ha = sqm / 10000
					g_currentMission.missionStats.hectaresWorkedTotal = g_currentMission.missionStats.hectaresWorkedTotal + ha
					g_currentMission.missionStats.hectaresWorkedSession = g_currentMission.missionStats.hectaresWorkedSession + ha
				end
			end
			
			if self:getIsActiveForSound() then
				if self.ploughHasGroundContact and self.attacherVehicle.lastSpeed*3600 > 1 then
					if not self.ploughSoundEnabled and self:getIsActiveForSound() then
						setSamplePitch(self.ploughSound, self.ploughSoundPitchOffset);
						playSample(self.ploughSound, 0, self.ploughSoundVolume, 0);
						self.ploughSoundEnabled = true;
					end
				else
					if self.ploughSoundEnabled then
						stopSample(self.ploughSound);
						self.ploughSoundEnabled = false;
					end										
				end
			end
				
			if self:getIsActiveForSound() then
				if self.cultivatorHasGroundContact and self.attacherVehicle.lastSpeed*3600 > 1  then
					if not self.cultivatorSoundEnabled and self:getIsActiveForSound() then
						setSamplePitch(self.cultivatorSound, self.cultivatorSoundPitchOffset);
						playSample(self.cultivatorSound, 0, self.cultivatorSoundVolume, 0);
						self.cultivatorSoundEnabled = true;
					end;
				else
					if self.cultivatorSoundEnabled then
						stopSample(self.cultivatorSound);
						self.cultivatorSoundEnabled = false;
					end
				end
			end
			
		elseif self.isClient then						
			if self.ploughSoundEnabled then
				stopSample(self.ploughSound);
				self.ploughSoundEnabled = false;
			end;
			if self.cultivatorSoundEnabled then
				stopSample(self.cultivatorSound);
				self.cultivatorSoundEnabled = false;
			end;
		end;			
	--end
	
	for k,tagName in pairs({"kvernelandFurrows","kvernelandPackomats"}) do		
		for i,entry in pairs(self[tagName]) do
			if self.time > entry.groundParticleSystemsDisableTime then
				if entry.groundParticleSystems1 ~= nil then
					Utils.setEmittingState(entry.groundParticleSystems1, false)
				end
				if entry.groundParticleSystems  ~= nil then
					Utils.setEmittingState(entry.groundParticleSystems, false)
				end
			end
		end
	end	
end
-- *******************************************************************************************************************************	
-- *******************************************************************************************************************************	
-- *******************************************************************************************************************************	

function PackomatBase:update(dt)

	if self.fixStartPositionTime ~= nil and self.fixStartPositionTime < 1500 then 
		self.isRotating = true;
		self:updateAnimations(true);
	end
	
	if self.attacherVehicle == nil then
		if self.isLowering then
			self:setStateEvent("isLowering", false, false, true)
		end
	end

	--if self.checkDirectionTime ~= nil then
	--	if not self.isRotation and self.time > self.checkDirectionTime + 2000 then
	--		self.checkDirectionTime = nil
	--		
	--		print(tostring(self.typeName))
	--		for k=1,2 do
	--			local dx, dz = 0, 1
	--			if k == 1 then
	--				dx, _, dz = localDirectionToWorld(self.directionPlough, 0, 0, 1)
	--			else
	--				dx, _, dz = localDirectionToWorld(self.directionCultivator, 0, 0, 1)
	--			end
	--			local angle = math.deg(Utils.getYRotationFromDirection(dx, dz))
	--		
	--			print(tostring(angle))
	--		end
	--	end
	--end

	--if     self.packomatIsAIControlled 
	--		or self.attacherVehicle == nil 
	--		or self.time < self.onAttachedTime + 2000 
	--		or not self:getIsActiveForInput(true) then
	--	self.allowsLowering = true
	--elseif self.transport then
	--	self.allowsLowering = false	
	--else
	--	self.allowsLowering = true
	--end
	
	if      self.attacherVehicle               ~= nil 
			and self.attacherVehicle.setStateEvent ~= nil
			and self.attacherVehicle.packomatBase  ~= nil then
		local rootAttacherVehicle = self:getRootAttacherVehicle()
		if      rootAttacherVehicle ~= nil 
				and rootAttacherVehicle ~= self.attacherVehicle 
				and rootAttacherVehicle.selectedImplement == self then
				
			if not self.attacherVehicle.isLowering then
				self.allowsLowering = false
			end
			
			if self.packomatBase ~= nil and self.packomatBase.deselectAfterLoad then
				self.packomatBase.deselectAfterLoad = nil
				rootAttacherVehicle:setSelectedImplement( self.attacherVehicle )
			end
		end
		
		if self.transport ~= self.attacherVehicle.transport then
			self:setStateEvent("transport", self.attacherVehicle.transport,false,true)
		end;
		if self.rotateLeftToMax ~= self.attacherVehicle.rotateLeftToMax then
			self:setStateEvent("rotateLeftToMax", self.attacherVehicle.rotateLeftToMax,false,true)
		end;
		if self.smallWidth ~= self.attacherVehicle.smallWidth then
			self:setStateEvent("smallWidth", self.attacherVehicle.smallWidth,false,true)
		end;
		if self.kvernelandHeightControlHeight ~= self.attacherVehicle.kvernelandHeightControlHeight then
			self:setStateEvent("kvernelandHeightControlHeight", self.attacherVehicle.kvernelandHeightControlHeight,false,true)
		end;
		if self.ploughLimitToField ~= self.attacherVehicle.ploughLimitToField then
			self:setPloughLimitToField(self.attacherVehicle.ploughLimitToField,false,true)
		end
		
		self.aiLeftMarker  = nil
		self.aiRightMarker = nil
		self.aiBackMarker  = nil	
	elseif self.packomatBase ~= nil then
		self.aiLeftMarker  = self.packomatBase.aiLeftMarker 
		self.aiRightMarker = self.packomatBase.aiRightMarker
		self.aiBackMarker  = self.packomatBase.aiBackMarker 
	end

	if self:getIsActiveForInput() then
		if not self.isLowering and not self.isRotating then
			if InputBinding.hasEvent (InputBinding.IMPLEMENT_EXTRA2) then 
				self:setStateEvent("transport", not self.transport)
			--if self.transport then
			--	self:setStateEvent("rotateLeftToMax", not self.rotateLeftToMax ) 
			--end
			end;
			if InputBinding.hasEvent (InputBinding.IMPLEMENT_EXTRA) then -- and not self.transport then 
				self:setStateEvent("rotateLeftToMax", not self.rotateLeftToMax ) 
			end;
		end;

		if     InputBinding.isPressed(InputBinding.Packomat_UP) then
			self:setStateEvent("kvernelandHeightControlHeight", math.min(self.kvernelandHeightControlHeight+0.01, self.kvernelandHeightMaxHeight))
		--print("New height: "..tostring(self.kvernelandHeightControlHeight))
		elseif InputBinding.isPressed(InputBinding.Packomat_DOWN) then
			self:setStateEvent("kvernelandHeightControlHeight", math.max(self.kvernelandHeightControlHeight-0.01, self.kvernelandHeightMinHeight))
		--print("New height: "..tostring(self.kvernelandHeightControlHeight))
		elseif InputBinding.isPressed(InputBinding.Packomat_SMALL) then
			self:setStateEvent("smallWidth", math.min(self.smallWidth+0.1,1))
		elseif InputBinding.isPressed(InputBinding.Packomat_BIG) then
			self:setStateEvent("smallWidth", math.max(self.smallWidth-0.1,0))
		end

		if InputBinding.hasEvent (InputBinding.Packomat_CULTIVATOR_UP) then 
			self:setStateEvent("cultivator", 1, false, true)
		elseif InputBinding.hasEvent (InputBinding.Packomat_CULTIVATOR_DOWN) then 
			self:setStateEvent("cultivator", 0, false, true)
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:setPloughLimitToField(not self.ploughLimitToField)
		end
	end;		
	
	if self.cultivator > 0.5 or self.cultivatorHidden then
		self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel
		self.aiTerrainDetailChannel2 = g_currentMission.cultivatorChannel
		self.aiTerrainDetailChannel3 = g_currentMission.sowingWidthChannel
	else
		self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel
		self.aiTerrainDetailChannel2 = g_currentMission.sowingWidthChannel
		self.aiTerrainDetailChannel3 = -1
	end
	
	self.isRotating = false
	self.isPloughTurning=false;
	
	if self.fixStartPositionTime == nil or self.fixStartPositionTime > 1500 then 	
		for i=1,table.getn(self.rotation) do
			if self.rotation[i].max ~= nil then
				if self.rotation[i].max then
					self.rotation[i].target = 1
				else
					self.rotation[i].target = 0
				end
			end
			
			if self.rotation[i].target == nil then
				self.rotation[i].alpha = nil 
			elseif self.rotation[i].alpha == nil then
				self.rotation[i].alpha = 0--self.rotation[i].target
			elseif self.rotation[i].alpha < self.rotation[i].target then
				self.rotation[i].alpha = math.min( self.rotation[i].target, self.rotation[i].alpha + dt / self.rotation[i].rotTime )
			else
				self.rotation[i].alpha = math.max( self.rotation[i].target, self.rotation[i].alpha - dt / self.rotation[i].rotTime )
			end
		end

		for i=1,table.getn(self.translation) do
			if self.translation[i].max ~= nil then
				if self.translation[i].max then
					self.translation[i].target = 1
				else
					self.translation[i].target = 0
				end
			end

			if self.translation[i].target == nil then
				self.translation[i].alpha = nil 
			elseif self.translation[i].alpha == nil then
				self.translation[i].alpha = 0--self.translation[i].target
			elseif self.translation[i].alpha < self.translation[i].target then
				self.translation[i].alpha = math.min( self.translation[i].target, self.translation[i].alpha + dt / self.translation[i].transTime )
			else
				self.translation[i].alpha = math.max( self.translation[i].target, self.translation[i].alpha - dt / self.translation[i].transTime )
			end
		end

		for i=1, table.getn(self.rotParts) do
			if self.rotParts[i].max ~= nil then
				if self.rotParts[i].max then
					self.rotParts[i].target = 1
				else
					self.rotParts[i].target = 0
				end
			end
			
			if self.rotParts[i].target == nil then
				self.rotParts[i].alpha = nil
			elseif self.rotParts[i].alpha == nil then
				self.rotParts[i].alpha = 0--self.rotParts[i].target
			elseif self.rotParts[i].alpha < self.rotParts[i].target then
				self.rotParts[i].alpha = math.min( self.rotParts[i].target, self.rotParts[i].alpha + dt / self.rotParts[i].rotTime )
			else
				self.rotParts[i].alpha = math.max( self.rotParts[i].target, self.rotParts[i].alpha - dt / self.rotParts[i].rotTime )
			end
		end
		
		self:updateAnimations();
	
		if self:getIsActiveForSound() then
			if self.isRotating then
				if not self.ploughTurnSoundEnabled and self:getIsActiveForSound() then
					setSamplePitch(self.ploughTurnSound, self.ploughTurnSoundPitchOffset);
					playSample(self.ploughTurnSound, 0, self.ploughTurnSoundVolume, 0);
					self.ploughTurnSoundEnabled = true;
				end;
			else
				if self.ploughTurnSoundEnabled then
					stopSample(self.ploughTurnSound);
					self.ploughTurnSoundEnabled = false;
				end
			end
		end
	end

	self.allowsDetaching = not self.isRotating
	
	self:setHydraulicDirection();					
	
	if      self.isLowering
			and not self.transport 
			and not self.isRotating
			and self.attacherVehicleJointDescIndex       ~= nil
			and math.abs( self.attacherVehicle.attacherJoints[self.attacherVehicleJointDescIndex].moveAlpha 
									- self.attacherVehicle.attacherJoints[self.attacherVehicleJointDescIndex].lowerAlpha ) < 1E-3
			and ( self.packomatIsAIControlled or self:getIsActiveForInput(false) )
			and self.attacherJoint                       ~= nil
			and self.attacherJoint.lowerDistanceToGround ~= nil
			and self.kvernelandHeightControlIndex        ~= nil
			and self.attacherVehicle                     ~= nil 
			and self.attacherVehicle.attacherJoints[self.attacherVehicleJointDescIndex].lowerAlpha > 1E-3
			and self.attacherVehicle.packomatBase        == nil then
			
		local eps   = 1E-3
		local delta = 5E-2

		local x,y,z = getWorldTranslation(self.kvernelandHeightControlIndex);
		local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
		
		local updateHeight = true
		local diff = self.kvernelandHeightControlHeight - y + terrainHeight

		if math.abs( diff ) > eps then
			self.packomatBase.jointChanged = true
			local jointDescIndex = self.attacherVehicleJointDescIndex
			local lowerAlpha = self.attacherVehicle.attacherJoints[jointDescIndex].lowerAlpha
			--print(tostring(diff).." "..tostring(y-terrainHeight).." "..tostring(lowerAlpha))
			local jointDesc = self.attacherVehicle.attacherJoints[jointDescIndex]
			--local upperAlpha, lowerAlpha = Vehicle.calculateAttacherJointMoveUpperLowerAlpha( self.attacherVehicle, jointDesc, self )
			self.attacherVehicle.attacherJoints[jointDescIndex].lowerAlpha = math.min(math.max( lowerAlpha - math.min(math.max(diff,-delta),delta) * 0.1, 0), 1)
			self.attacherVehicle.attacherJoints[jointDescIndex].moveAlpha  = self.attacherVehicle.attacherJoints[jointDescIndex].lowerAlpha
			self.attacherVehicle.attacherJoints[jointDescIndex].jointFrameInvalid = true;     
			setRotation(jointDesc.rotationNode, Utils.vector3ArrayLerp(jointDesc.minRot, jointDesc.maxRot, jointDesc.moveAlpha))
		end
	end
end;


function PackomatBase:updateAnimations(force)
	local updateJoinFrames = false;


	for i=1,table.getn(self.rotation) do
		if      self.rotation[i].alpha ~= nil 
				and ( force
					 or self.rotation[i].lastAlpha == nil 
					 or math.abs( self.rotation[i].lastAlpha - self.rotation[i].alpha ) > 1E-4 ) then
			self.rotation[i].lastAlpha = self.rotation[i].alpha
			
			if self.rotation[i].testMoving then
				self.isRotating = true
				if i == self.isPloughTurningRotation then
					self.isPloughTurning=true;
				end
				--print("R"..tostring(i))
			end

			local newRot = {}
			for k=1,3 do
				newRot[k] = self.rotation[i].minRot[k] + self.rotation[i].alpha * ( self.rotation[i].maxRot[k] - self.rotation[i].minRot[k] )
			end
			
			setRotation(self.rotation[i].node, unpack(newRot));
			
			updateJoinFrames = true;
		end
	end

	for i=1,table.getn(self.translation) do
		if      self.translation[i].alpha ~= nil 
				and ( force
					 or self.translation[i].lastAlpha == nil 
					 or math.abs( self.translation[i].lastAlpha - self.translation[i].alpha ) > 1E-4 ) then
			self.translation[i].lastAlpha = self.translation[i].alpha
	
			if self.translation[i].testMoving then
				self.isRotating = true
				--print("T"..tostring(i))
			end			
			
			local newTrans = {}
			for k=1,3 do
				newTrans[k] = self.translation[i].minTrans[k] + self.translation[i].alpha * ( self.translation[i].maxTrans[k] - self.translation[i].minTrans[k] )
			end

			setTranslation(self.translation[i].node, unpack(newTrans));
		
			updateJoinFrames = true;
		end
	end

	for i=1, table.getn(self.rotParts) do
		if      self.rotParts[i].alpha ~= nil 
				and ( force
					 or self.rotParts[i].lastAlpha == nil 
					 or math.abs( self.rotParts[i].lastAlpha - self.rotParts[i].alpha ) > 1E-4 ) then
			self.rotParts[i].lastAlpha = self.rotParts[i].alpha
			
			isRotating = true;
			if self.rotParts[i].testMoving then
				self.isRotating = true
			end

			for _,part in pairs( self.rotParts[i].parts ) do
				local newRot = {}
				for k=1,3 do
					newRot[k] = part.minRot[k] + self.rotParts[i].alpha * ( part.maxRot[k] - part.minRot[k] )
				end
			
				setRotation(part.index, unpack(newRot));
				
				updateJoinFrames = true;
			end;
		end;
	end;
	
	if updateJoinFrames then
		for _,joint in pairs(self.componentJoints) do
			setJointFrame(joint.jointIndex, 0, joint.jointNode);				
		end;
	end;
end

function PackomatBase:draw()
  if self:getIsActiveForInput(true) then
		if not self.isRotating then
			g_currentMission:addHelpButtonText(g_i18n:getText("Turn_plough"), InputBinding.IMPLEMENT_EXTRA)
		end
    if self.ploughLimitToField then
      g_currentMission:addHelpButtonText(g_i18n:getText("allow_create_fields"), InputBinding.IMPLEMENT_EXTRA3)
    else
      g_currentMission:addHelpButtonText(g_i18n:getText("limit_to_fields"), InputBinding.IMPLEMENT_EXTRA3)
    end
		if self.smallWidth>0 then
			g_currentMission:addHelpButtonText( string.format( g_i18n:getText("Packomat_BIG"), 100*(1-self.smallWidth) ), InputBinding.Packomat_BIG);
		end
		if self.smallWidth<1 then
			g_currentMission:addHelpButtonText( string.format( g_i18n:getText("Packomat_SMALL"), 100*(1-self.smallWidth) ), InputBinding.Packomat_SMALL);
		end
		if self.kvernelandHeightControlHeight~= nil then
			local diff = self.kvernelandHeightControlHeight - self.kvernelandHeightBaseHeight
		  if self.kvernelandHeightControlHeight > self.kvernelandHeightMinHeight then
				g_currentMission:addHelpButtonText( string.format( g_i18n:getText("Packomat_DOWN"), diff ), InputBinding.Packomat_DOWN);
			end
			if self.kvernelandHeightControlHeight < self.kvernelandHeightMaxHeight then
				g_currentMission:addHelpButtonText( string.format( g_i18n:getText("Packomat_UP"), diff ), InputBinding.Packomat_UP);
			end
		end
		if not self.cultivatorHidden then
			if self.cultivator > 0.5 then
				g_currentMission:addHelpButtonText(g_i18n:getText("Packomat_CULTIVATOR_DOWN"), InputBinding.Packomat_CULTIVATOR_DOWN);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("Packomat_CULTIVATOR_UP"), InputBinding.Packomat_CULTIVATOR_UP);
			end
		end
		if not self.isLowering and not self.isRotating then --"fold_OBJECT"
			if self.transport then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("unfold_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2)
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("fold_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2)
			end
		end;
	end;
	if self.showFieldNotOwnedWarning then
    g_currentMission:addWarning(g_i18n:getText("You_dont_own_this_field"))
  end
end

function PackomatBase:onLeave()
  if self.deactivateOnLeave then
    PackomatBase.onDeactivate(self);
  else
    PackomatBase.onDeactivateSounds(self)
  end;
  Utils.setEmittingState(self.groundParticleSystems, false)
  Utils.setEmittingState(self.groundParticleSystems1, false)
	Utils.setEmittingState(self.groundParticleSystems2, false)
end;

function PackomatBase:onDeactivate()
  PackomatBase.onDeactivateSounds(self)
end;

function PackomatBase:onDeactivateSounds()
 if self.ploughSoundEnabled then
        stopSample(self.ploughSound);
        self.ploughSoundEnabled = false;
    end;
    if self.cultivatorSoundEnabled then
        stopSample(self.cultivatorSound);
        self.cultivatorSoundEnabled = false;
    end;
	 if self.ploughTurnSoundEnabled then
        stopSample(self.ploughTurnSound);
        self.ploughTurnSoundEnabled = false;
    end;
end;
function PackomatBase:setJointRotLimit(nodei, up, down, speed, value, axle, dt)

	if self.arm[nodei] == nil then
		self.arm[nodei] = {0}; 
	end; 
	x, y, z = getRotation(nodei);
	rot = {x,y,z};	
	newRotLimit = {}; 
	newRotLimit[nodei] = {0,0,0};
	newRotLimit[nodei] = Utils.getMovedLimitedValues(self.arm[nodei], {down}, {up}, 1, speed * 2, dt, value);
	if math.abs(newRotLimit[nodei][1] - self.arm[nodei][1]) > 0.001 then
		local joint = nodei;
		setJointRotationLimit(joint.jointIndex, axle, true, Utils.degToRad(-newRotLimit[nodei][1]), Utils.degToRad(newRotLimit[nodei][1]));
	end;
	self.arm[nodei] = newRotLimit[nodei];			
end;
function PackomatBase:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end;

function PackomatBase:setStateEvent(level1, value, noEventSend, noForward)
	
  if value== true then
    value = "true"
  elseif value==false then
    value = "false"
	elseif value==nil then
		value = "nil"
  elseif value ~= "true" and value ~= "false" then
    value = string.format("%f", value)
  end
	
	PackomatBaseEvent.sendEvent(self, level1, value, noEventSend, noForward);
    	
	if value== "true" then
    value = true
  elseif value=="false" then
    value = false
	elseif value=="nil" then
		value = nil
  elseif value ~= true and value ~= false then
    value = value * 1.0
  end
	
	if self[level1] ~= value then
		if     level1 == "transport" then	
			self:onPackomatTransport( value, noEventSend )	
		elseif level1 == "isLowering" then	
			self:onPackomatLowering( value, noEventSend )	
		elseif level1 == "smallWidth" then	
			self:onPackomatSmallWidth( value, noEventSend )	
		elseif level1 == "rotateLeftToMax" then	
			self:onPackomatRotate( value, noEventSend )	
		elseif level1 == "cultivator" then	
			self:onPackomatCultivator( value, noEventSend )	
		end
	end
	
	self[level1]= value;
	
	if noForward == nil or not noForward then
		for _,implement in pairs(self.attachedImplements) do
			if      implement.object               ~= nil 
					and implement.object.setStateEvent ~= nil
					and implement.object.packomatBase  ~= nil then
				implement.object.setStateEvent( implement.object, level1, value, true, true )
			end
		end

		if      self.attacherVehicle               ~= nil 
				and self.attacherVehicle.setStateEvent ~= nil
				and self.attacherVehicle.packomatBase  ~= nil then
			self.attacherVehicle.setStateEvent( self.attacherVehicle, level1, value, true, true )
		end	
	end	
end;

function PackomatBase:setPloughLimitToField(ploughLimitToField, noEventSend)
  if self.ploughLimitToField ~= ploughLimitToField then
    if noEventSend == nil or noEventSend == false then
      if g_server ~= nil then
        g_server:broadcastEvent(PloughLimitToFieldEvent:new(self, ploughLimitToField), nil, nil, self)
      else
        g_client:getServerConnection():sendEvent(PloughLimitToFieldEvent:new(self, ploughLimitToField))
      end
    end
    self.ploughLimitToField = ploughLimitToField
  end
end

function PackomatBase:aiRotateLeft()
	if not self.rotateLeftToMax then
		self:setStateEvent("rotateLeftToMax", not self.rotateLeftToMax ) --self.rotateLeftToMax
	end
end
function PackomatBase:aiRotateRight()
	if self.rotateLeftToMax then
		self:setStateEvent("rotateLeftToMax", not self.rotateLeftToMax ) --self.rotateLeftToMax
	end
end
function PackomatBase:aiInvertsMarkerOnTurn(turnLeft)
	if turnLeft then
		return self.rotateLeftToMax ~= true
	else
		return self.rotateLeftToMax == true
	end
end
function PackomatBase:aiTurnOn()
  self.ploughLimitToField = true
	self.packomatIsAIControlled = true

	self:setStateEvent("transport", false)
	self:setStateEvent("smallWidth", 0.2)
end
function PackomatBase:aiTurnOff()
	self.packomatIsAIControlled = nil
end
function PackomatBase:onSetLowered(lowered)
	if      self.attacherVehicle              ~= nil 
			and self.attacherVehicle.packomatBase == nil then
		self:setStateEvent("isLowering", lowered, false, true)
	end
end
function PackomatBase:onAttached(attacherVehicle, jointDescIndex)
	self.attacherVehicleJointDescIndex = jointDescIndex
	self.onAttachedTime = self.time
	self.attacherJoint.lowerDistanceToGround = self.packomatBase.lowerDistanceToGround
	self.packomatBase.deselectAfterLoad = true	
end
function PackomatBase:onDetach(attacherVehicle, jointDescIndex)
	self.attacherVehicleJointDescIndex = nil
	self.onAttachedTime = nil
end

function PackomatBase:onPackomatTransport( value, noEventSend )
end
function PackomatBase:onPackomatLowering( value, noEventSend ) 
	self.testPosition = { getWorldTranslation( self.directionPlough ) }
	if      self.attacherVehicle               ~= nil 
			and self.attacherVehicle.setStateEvent ~= nil
			and self.attacherVehicle.packomatBase  ~= nil then
		self.isLoweringTime = 3000 + self.time
	else
		self.isLoweringTime = self.time
	end
end
function PackomatBase:onPackomatRotate( value, noEventSend )   
end
function PackomatBase:onPackomatSmallWidth( value, noEventSend )   
	--self.checkDirectionTime = self.time;
end
function PackomatBase:onPackomatCultivator( value, noEventSend )   
end

function PackomatBase:setblend1Visibility(visibility)
	if visibility then
		self.cultivatorHidden = false
	else
		self.cultivatorHidden = true
	end
end

function PackomatBase:readUpdateStream(streamId, timestamp, connection)
  if connection:getIsServer() then
    self.ploughHasGroundContact = streamReadBool(streamId)
    self.showFieldNotOwnedWarning = streamReadBool(streamId)
  end
end
function PackomatBase:writeUpdateStream(streamId, connection, dirtyMask)
  if not connection:getIsServer() then
    streamWriteBool(streamId, self.ploughHasGroundContact)
    streamWriteBool(streamId, self.showFieldNotOwnedWarning)
  end
end
function PackomatBase:readStream(streamId, connection)  
	self.transport = streamReadBool(streamId);	
	self.isLowering = streamReadBool(streamId);	
	self.rotateLeftToMax = streamReadBool(streamId)
	self.ploughTurnSoundEnabled = streamReadBool(streamId)
	self.smallWidth = streamReadFloat32(streamId)
	self.kvernelandHeightControlHeight = streamReadFloat32(streamId)
	self.cultivator = streamReadFloat32(streamId)
end

function PackomatBase:writeStream(streamId, connection)
	streamWriteBool(streamId, self.transport);	
	streamWriteBool(streamId, self.isLowering);	
	streamWriteBool(streamId, self.rotateLeftToMax);
	streamWriteBool(streamId, self.ploughTurnSoundEnabled)
	streamWriteFloat32(streamId, self.smallWidth)
	streamWriteFloat32(streamId, self.kvernelandHeightControlHeight)
	streamWriteFloat32(streamId, self.cultivator)
end;


PackomatBaseEvent = {};
PackomatBaseEvent_mt = Class(PackomatBaseEvent, Event);

InitEventClass(PackomatBaseEvent, "PackomatBaseEvent");

function PackomatBaseEvent:emptyNew()  
    local self = Event:new(PackomatBaseEvent_mt );
    self.className="PackomatBaseEvent";
    return self;
end;

function PackomatBaseEvent:new(object, level1, value, noFwd) 
    self.object = object;
    self.level1 = level1;
    self.value = value;
		self.noFwd = Utils.getNoNil( noFwd, false )

    return self;
end;

function PackomatBaseEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self.level1 = streamReadString(streamId);
    self.value = streamReadString(streamId);
		self.noFwd = streamReadBool(streamId);
    self:run(connection);
end;

function PackomatBaseEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteString(streamId, self.level1 );
    streamWriteString(streamId, self.value );
		streamWriteBool(  streamId, self.noFwd );
end;

function PackomatBaseEvent:run(connection)
    self.object:setStateEvent(self.level1, self.value, true, self.noFwd);
    if not connection:getIsServer() then  
      g_server:broadcastEvent(PackomatBaseEvent:new(self.object, self.level1, self.value), nil, connection, self.object);
    end;
end;

function PackomatBaseEvent.sendEvent(object, level1, value, noEventSend, noFwd)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then 
			g_server:broadcastEvent(PackomatBaseEvent:new(object, level1, value, noFwd), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(PackomatBaseEvent:new(object, level1, value, noFwd));
		end;
	end;
end;

------------------------------------------------------------------------
-- getSaveAttributesAndNodes
------------------------------------------------------------------------
function PackomatBase:getSaveAttributesAndNodes(nodeIdent)

	local attributes = ""

	attributes = attributes.." PackomatT=\"" .. tostring(self.transport      ) .. "\""
	attributes = attributes.." PackomatW=\"" .. tostring(self.smallWidth     ) .. "\""
	attributes = attributes.." PackomatL=\"" .. tostring(self.rotateLeftToMax) .. "\""
	attributes = attributes.." PackomatC=\"" .. tostring(self.cultivator     ) .. "\""
	attributes = attributes.." PackomatH=\"" .. tostring(self.kvernelandHeightControlHeight) .. "\""
	
	for i=1,table.getn(self.rotation) do
		if self.rotation[i].alpha ~= nil and math.abs( self.rotation[i].alpha ) > 1E-4 then
			attributes = attributes.." PackomatR"..tostring(i).."=\"" .. tostring(self.rotation[i].alpha) .. "\""
		end
	end
	
	for i=1,table.getn(self.translation) do
		if self.translation[i].alpha ~= nil and math.abs( self.translation[i].alpha ) > 1E-4 then
			attributes = attributes.." PackomatT"..tostring(i).."=\"" .. tostring(self.translation[i].alpha) .. "\""
		end
	end
	
	for i=1,table.getn(self.rotParts) do
		if self.rotParts[i].alpha ~= nil and math.abs( self.rotParts[i].alpha ) > 1E-4 then
			attributes = attributes.." PackomatP"..tostring(i).."=\"" .. tostring(self.rotParts[i].alpha) .. "\""
		end
	end
	
	return attributes
end;


------------------------------------------------------------------------
-- loadFromAttributesAndNodes
------------------------------------------------------------------------
function PackomatBase:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	local bool = nil
	
	bool = getXMLBool(xmlFile, key .. "#PackomatT")
	if bool ~= nil then
		self.transport       = bool
	end
	
	local f = getXMLFloat(xmlFile, key .. "#PackomatW")
	if f ~= nil then
		self.smallWidth      = f
	end
	
	bool = getXMLBool(xmlFile, key .. "#PackomatL")
	if bool ~= nil then
		self.rotateLeftToMax = bool
	end
	
	f = getXMLFloat(xmlFile, key .. "#PackomatC")
	if f ~= nil then
		self.cultivator      = f
	end
		
	f = getXMLFloat(xmlFile, key .. "#PackomatH")
	if f ~= nil then
		self.kvernelandHeightControlHeight = f
	end
	
	for i=1,table.getn(self.rotation) do
		local f = getXMLFloat(xmlFile, key .. "#PackomatR"..tostring(i) )
		if f ~= nil then
			self.rotation[i].alpha = f
		--self.rotation[i].target = f
		end
	end

	for i=1,table.getn(self.translation) do
		local f = getXMLFloat(xmlFile, key .. "#PackomatT"..tostring(i) )
		if f ~= nil then
			self.translation[i].alpha = f
		--self.translation[i].target = f
		end
	end
			
	for i=1,table.getn(self.rotParts) do
		local f = getXMLFloat(xmlFile, key .. "#PackomatP"..tostring(i) )
		if f ~= nil then
			self.rotParts[i].alpha = f
		--self.rotParts[i].target = f
		end
	end
			
	self:updateAnimations(true);
	self:setHydraulicDirection();
	
	return BaseMission.VEHICLE_LOAD_OK;
end

--local function printCallstack()
--	local i = 2;
--	local info;
--	print("------------------------------------------------------------------------");
--	while i <= 10 do
--		info = debug.getinfo(i);
--		if info == nil then break end
--		print(string.format("%i: %s (%i): %s", i, info.short_src, Utils.getNoNil(info.currentline,0), Utils.getNoNil(info.name,"<???>")));
--		i = i + 1;
--	end
--	if info ~= nil and info.name ~= nil and info.currentline ~= nil then
--		print("...");
--	end
--	print("------------------------------------------------------------------------");
--end
--
--local oldInputBindingHasEvent = InputBinding.hasEvent
--InputBinding.hasEvent = function(actionIndex, removeEvent)
--	if actionIndex == nil or InputBinding == nil or InputBinding.actions == nil then
--		printCallstack()
--	end
--	for _, actionData in pairs(InputBinding.actions) do
--		if actionData.isAnalogAction == nil then
--			printCallstack()
--		end
--	end	
--	return oldInputBindingHasEvent(actionIndex, removeEvent)
--end

