-- LS09 xyzspain
-- LS11 mp ready Hummel (modhoster.de) 28.07.2011
-- LS13 ready Biedens & Upsidedown (modhoster.de) 15.05.2014
PWPackomat = {};

function PWPackomat.prerequisitesPresent(specializations)
	Vehicle.registerJointType("RWPackomat")
  return true;
end;

function PWPackomat:load(xmlFile)
				---emision de particulas ruedas

	self.wheelParticleSystems = {};
  local psFile = getXMLString(xmlFile, "vehicle.wheelParticleSystems#file");
  if psFile ~= nil then
    local i=0;
    while true do
      local baseName = string.format("vehicle.wheelParticleSystems.wheelParticleSystem(%d)", i);
      local node = getXMLString(xmlFile, baseName.. "#node");
      if node == nil then
         break;
      end;
      node = Utils.indexToObject(self.components, node);
			self.wheelParticleSystems.node = node;
      if node ~= nil then
        local wheelParticleSystem = {};
        wheelParticleSystem.particleSystems = {};
        Utils.loadParticleSystem(xmlFile, wheelParticleSystem.particleSystems, "vehicle.wheelParticleSystems", node, false, nil, self.baseDirectory);
        table.insert(self.wheelParticleSystems, wheelParticleSystem);
      end;
      i = i+1;
    end;
  end;
	
	-------------	
	
  self.PWaiLeftMarker   = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index"))
  self.PWaiRightMarker  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index"))
  self.PWaiBackMarker   = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiBackMarker#index"))
  self.PWaiLeftMarker2  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker2#index"))
  self.PWaiRightMarker2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker2#index"))
  self.PWaiBackMarker2  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiBackMarker2#index"))

	----------------------------------
		---libertad bloques
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");

	self.loweringDelayTimeDown = getXMLFloat(xmlFile, "vehicle.kvernelandDelayTimer#backWheelDown") * 1000;
	self.loweringDelayTimeUp   = getXMLFloat(xmlFile, "vehicle.kvernelandDelayTimer#backWheelUp") * 1000;
	self.attacherDelayTimeDown = getXMLFloat(xmlFile, "vehicle.kvernelandDelayTimer#attacherDown") * 1000;
	self.attacherDelayTimeUp   = getXMLFloat(xmlFile, "vehicle.kvernelandDelayTimer#attacherUp") * 1000;
	
	self.transport = true
	
	local baseName = "vehicle.attacherJoints.attacherJoint(0)"
	local index = getXMLString(xmlFile, baseName .. "#index")
	if index ~= nil then	
		local rotationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#rotationNode"))
		if rotationNode ~= nil then
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName .. "#minRot"))
			local rx, ry, rz = getRotation(rotationNode)
			self.attacherMinRot = { Utils.getNoNilRad(x, rx),
															Utils.getNoNilRad(y, ry),
															Utils.getNoNilRad(z, rz) }
		end
	end
	
	self.attacherMinRotXOffset = 0
	self.attacherMinRotXTransp = 0
	self.pwIsLowering          = false
	self.pwLowerAttacher       = false
	self.pwTransportTimer      = nil
	
end;

function PWPackomat:delete()
	for k=1, 2 do
		Utils.deleteParticleSystem(self.wheelParticleSystems[k].particleSystems);
	end;	
end;
function PWPackomat:mouseEvent(posX, posY, isDown, isUp, button)
end;
function PWPackomat:keyEvent(unicode, sym, modifier, isDown)
end;
function PWPackomat:update(dt)

	if self.pwTransportTimer ~= nil then
		self.isRotating = true
		if self.time > self.pwTransportTimer then
			self.pwTransportTimer = nil
			if not self.transport then
				self:setStateEvent("rotateLeftToMax", not self.rotateLeftToMax ) 
			end
			self:setStateEvent("transport", not self.transport)
		end
	end
	
	if      self:getIsActiveForInput()  
			and InputBinding.hasEvent (InputBinding.IMPLEMENT_EXTRA4)
			and self.attacherVehicle                     ~= nil 
			and self.attacherVehicleJointDescIndex       ~= nil
			and not self.isRotating then 
		if self.isLowering then
			self.pwTransportTimer = self.time + self.loweringDelayTimeUp + self.attacherDelayTimeUp
			self.attacherVehicle:setJointMoveDown(self.attacherVehicleJointDescIndex,false)
		else
			self.pwTransportTimer = self.time
		end
	end
	
	if self.attacherVehicle == nil then
		self.rotParts[1].target = 0
		self.rotation[19].target = 0
		self.rotParts[2].target = 0
	elseif self.transport then
		self.rotParts[1].target = 1
		self.rotation[19].target = 0
		self.rotParts[2].target = 0
	else
		self.rotParts[1].target = -0.5 + 1.5 * self.smallWidth
		self.rotation[19].target = 0.5 + self.smallWidth
		self.rotParts[2].target = 1
	end
		
	self.aiLeftMarker  = self.PWaiLeftMarker
	self.aiRightMarker = self.PWaiRightMarker
	self.aiBackMarker  = self.PWaiBackMarker
	self.pwJointFrameInvalid = false
	
	local jointDescIndex = 0
	local implement      = nil
	
	for _,impl in pairs(self.attachedImplements) do
		if      impl.object               ~= nil 
				and impl.object.setStateEvent ~= nil
				and impl.object.packomatBase  ~= nil then
			implement          = impl
			self.aiLeftMarker  = self.PWaiLeftMarker2 
			self.aiRightMarker = self.PWaiRightMarker2
			self.aiBackMarker  = self.PWaiBackMarker2
			jointDescIndex     = impl.jointDescIndex
			break
		end
	end

	self.pwIsLowering = self.isLowering
	self.pwLowerAttacher = self.isLowering

	if self.attacherVehicle then
	 ---prueba
		if self.pwIsLowering then
			if self.time <= self.isLoweringTime + self.loweringDelayTimeDown then
				self.pwIsLowering = false
			end
			if self.time <= self.isLoweringTime + self.attacherDelayTimeDown then
				self.pwLowerAttacher = false
			end
		else
			if self.time <= self.isLoweringTime + self.loweringDelayTimeUp   then
				self.pwIsLowering = true
			end
			if self.time <= self.isLoweringTime + self.attacherDelayTimeUp   then
				self.pwLowerAttacher = true
			end
		end
		
		if implement ~= nil and implement.object.isLowering ~= self.pwIsLowering then
			implement.object.setStateEvent( implement.object, "isLowering", self.pwIsLowering, false, true )
		end
		
		if jointDescIndex > 0 then
			if self.attacherJoints[jointDescIndex].moveDown ~= self.pwLowerAttacher then
				self:setJointMoveDown(jointDescIndex, self.pwLowerAttacher)
			end
			
			if PWPackomat.updateAttacherJoint( self, implement, self.attacherJoints[jointDescIndex], dt ) then
				self.attacherJoints[jointDescIndex].jointFrameInvalid = true
			end			
		end
	
		if not self.pwIsLowering then
			self.translation[2].max = false;
			self.translation[3].max = false;
			self.rotation[7].target=0;
			self.rotation[8].target=0;
			self.rotation[9].target=0;
		else 
			self.translation[2].max = true;
			self.translation[3].max = true;
			self.rotation[7].target= 1 + 2 * ( self.kvernelandHeightBaseHeight - self.kvernelandHeightControlHeight );
			self.rotation[8].target= 1 + 2 * ( self.kvernelandHeightBaseHeight - self.kvernelandHeightControlHeight );
			self.rotation[9].target= 1 + 2 * ( self.kvernelandHeightBaseHeight - self.kvernelandHeightControlHeight );
		end
	else
		self.translation[2].max = false;
		self.translation[3].max = false;
		self.rotation[7].target=0;
		self.rotation[8].target=0;
		self.rotation[9].target=0;
	end
	
	if self.transport then
		self.rotation[16].target = 1
	elseif self.cultivator > 0.5 or self.cultivatorHidden then
		self.rotation[16].target = 0
	elseif  implement ~= nil 
	    and implement.object ~= nil
			and implement.object.cultivator <= 0.5 
			and not implement.object.cultivatorHidden then
		self.rotation[16].target = 0
	else
		self.rotation[16].target = 0
	end
	
	if self.transport or not self.rotateLeftToMax then	
		-- left part
		self.rotation[2].max=false;
		self.rotation[4].max=false;
		self.rotation[10].max=false;
		self.rotation[12].max=false;
		self.rotation[15].max=false;
		self.rotation[17].max=false
	end

	if self.transport or self.rotateLeftToMax then	
		-- right part
		self.rotation[1].max=false;
		self.rotation[3].max=false;
		self.rotation[13].max=false;
		self.rotation[11].max=false;
		self.rotation[14].max=false;
		self.rotation[18].max=false
	end
			
	if not self.transport then
    if self.rotateLeftToMax then			
			self.rotation[2].max=true;
			self.rotation[4].max=true;
			self.rotation[10].max=true;
			self.rotation[12].max=true;
			self.rotation[17].max=true;
		
			if self.cultivator > 0.5 then
				self.rotation[14].max=false;
				self.rotation[15].max=true;
			else
				self.rotation[14].max=false;
				self.rotation[15].max=false;
			end;  
	  else
			self.rotation[1].max=true;
			self.rotation[3].max=true;
			self.rotation[13].max=true;
			self.rotation[11].max=true;
			self.rotation[18].max=true;
			
			if self.cultivator > 0.5 then
				self.rotation[14].max=true;
				self.rotation[15].max=false;
			else
				self.rotation[14].max=false;
				self.rotation[15].max=false;
			end;
		end;
	end

	self.translation[5].max = not self.rotateLeftToMax;
	self.translation[6].max = not self.rotateLeftToMax;
	self.translation[7].max = not self.rotateLeftToMax;
	self.translation[8].max = not self.rotateLeftToMax;
	self.translation[9].max = not self.rotateLeftToMax;
	self.translation[10].max= not self.rotateLeftToMax;
	
		---particulas ruedas

	local dens = 0; local dens1; local dens2; local dens3;
	local x,y,z = getWorldTranslation(self.wheels[1].repr);
	local x1,y1,z1 = getWorldTranslation(self.wheels[2].repr);
	local x2,y2,z2 = getWorldTranslation(self.wheels[2].repr);
	local id = g_currentMission.terrainDetailId;
	local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
	dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
	dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
	dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
	if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
		dens = dens1+dens2+dens3;
	end;
	if dens > 0 and self.lastSpeed*self.speedDisplayScale*3600 > 4 then
		for k=1, 2 do
			Utils.setEmittingState(self.wheelParticleSystems[k].particleSystems, self.wheels[k].hasGroundContact);
		end;
	else
		for i=1, table.getn(self.wheelParticleSystems) do
			Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, false);
		end;
	end;
end;

function PWPackomat:updateAttacherJoint(implement, jointDesc, dt)

	if self.pwIsLowering and not self.pwLowerAttacher then
		self.attacherMinRotXOffset = math.min( math.max( self.attacherMinRotXOffset + dt, -2000 ), 2000 )
	elseif not self.pwIsLowering and self.pwLowerAttacher then
		self.attacherMinRotXOffset = math.min( math.max( self.attacherMinRotXOffset - dt, -2000 ), 2000 )
	elseif self.attacherMinRotXOffset > 0 then
		self.attacherMinRotXOffset = math.max( self.attacherMinRotXOffset - dt, 0 )
	elseif self.attacherMinRotXOffset < 0 then
		self.attacherMinRotXOffset = math.min( self.attacherMinRotXOffset + dt, 0 )
	end
			
	if self.transport then
		self.attacherMinRotXTransp = math.min( math.max( self.attacherMinRotXTransp - dt, -1000 ), 0 )
	else                                                                   
		self.attacherMinRotXTransp = math.min( math.max( self.attacherMinRotXTransp + dt, -1000 ), 0 )
	end
	
	newMinRot = self.attacherMinRot[1] + math.rad( ( self.attacherMinRotXOffset + self.attacherMinRotXTransp ) * 0.005 );
	
	if math.abs( jointDesc.minRot[1] - newMinRot ) > 0.001 then
		jointDesc.minRot[1] = newMinRot
		if jointDesc.moveAlpha < 0.999 then
			setRotation(jointDesc.rotationNode, Utils.vector3ArrayLerp(jointDesc.minRot, jointDesc.maxRot, jointDesc.moveAlpha))
			return true
		end
	end
	
	return false
end;

function PWPackomat:draw()
	if      self:getIsActiveForInput()  
			and self.attacherVehicle                     ~= nil 
			and self.attacherVehicleJointDescIndex       ~= nil
			and self.isLowering 
			and not self.isRotating then 
		g_currentMission:addHelpButtonText(g_i18n:getText("IMPLEMENT_EXTRA4"), InputBinding.IMPLEMENT_EXTRA4);
	end;
end;

function PWPackomat:onAttach(attacherVehicle, jointDescIndex)
	self.fixAttacher = true; 
	self.rotation[5].max=true;
	self.rotation[6].max=true;
	self.translation[1].max = true;
	self.translation[4].max = true;
	self.aiTractorTurnRadiusBackup      = attacherVehicle.aiTractorTurnRadius
	attacherVehicle.aiTractorTurnRadius = 10
end;
function PWPackomat:onDetach(attacherVehicle, jointDescIndex)
  self.ploughLimitToField=true;
	self.rotation[14].max=false;
	self.rotation[15].max=false;
	self:setStateEvent("isLowering",false)
	self.translation[1].max = false;
	self.translation[4].max = false;
	self.rotation[5].max=false;
	self.rotation[6].max=false;
	
	if self.aiTractorTurnRadiusBackup ~= nil then
		attacherVehicle.aiTractorTurnRadius = self.aiTractorTurnRadiusBackup
		self.aiTractorTurnRadiusBackup      = nil
	end
	
	PackomatBase.onLeave( self )

	for i=1, table.getn(self.wheelParticleSystems) do
		Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, false);
	end;
end;

function PWPackomat:aiRaise()
	if not self.transport then
		self:setStateEvent("transport",true)
	end
end;

function PWPackomat:aiLower()
	if self.transport then
		self:setStateEvent("transport",false)
	end	
end;

function PWPackomat:attachImplement(implement)
	if self.isRealistic and RealisticVehicle.realSetBackAttacherJointValues ~= nil then
		RealisticVehicle.realSetBackAttacherJointValues( self.attacherJoints[implement.jointDescIndex] )
	end
	self.attacherJoints[implement.jointDescIndex].realBaseMoveTime = self.attacherJoints[implement.jointDescIndex].moveTime
end


--******************************************************************************
local oldGetDriveDirection = AIVehicleUtil.getDriveDirection
--******************************************************************************
function PWPackomat.getDriveDirection(refNode, x, y, z)
  local lx, _, lz = worldToLocal(refNode, x, y, z)
  local length = Utils.vector2Length(lx, lz)
  if length > 0.1 then
    length = 1 / length
    lx = lx * length
    lz = lz * length
	else
		lx = 0
		lz = 1
  end
	if lz < 0 then
		lz = -lz
	end
  return lx, lz
end

--******************************************************************************
function PWPackomat.getRelativeYRotation(root,node)
	local x, y, z = worldDirectionToLocal(node, localDirectionToWorld(root, 0, 0, 1))
	local dot = z
	dot = dot / Utils.vector2Length(x, z)
	local angle = math.acos(dot)
	if x < 0 then
		angle = -angle
	end
	return angle
end

--******************************************************************************
function PWPackomat:aiTurnOn()
	
	local vehicle = self:getRootAttacherVehicle()
	
	if vehicle ~= nil then
		vehicle.pwPackomat = self
		AIVehicleUtil.getDriveDirection = PWPackomat.getDriveDirection
		
		self.aiSteeringSpeedBackup     = vehicle.aiSteeringSpeed

		self.waitForTurnTimeoutBackup  = vehicle.waitForTurnTimeout
		vehicle.waitForTurnTimeout     = 200
	
		self.turnTimeoutBackup         = vehicle.turnTimeout
		vehicle.turnTimeout            = vehicle.turnTimeout + vehicle.turnTimeout

		self.frontMarkerDistanceScaleBackup = vehicle.frontMarkerDistanceScale
		vehicle.frontMarkerDistanceScale    = 0.75 * vehicle.frontMarkerDistanceScale
	end
end

--******************************************************************************
function PWPackomat:aiTurnOff()

	local vehicle = self:getRootAttacherVehicle()
	
	if vehicle ~= nil then
	  vehicle.pwPackomat = nil
		AIVehicleUtil.getDriveDirection = oldGetDriveDirection
		
		if self.aiSteeringSpeedBackup ~= nil then
			vehicle.aiSteeringSpeed = self.aiSteeringSpeedBackup 
			self.aiSteeringSpeedBackup = nil
		end
		
		if self.waitForTurnTimeoutBackup ~= nil then
			vehicle.waitForTurnTimeout = self.waitForTurnTimeoutBackup
			self.waitForTurnTimeoutBackup = nil
		end
		
		if self.turnTimeoutBackup ~= nil then
			vehicle.turnTimeout = self.turnTimeoutBackup
			self.turnTimeoutBackup = nil
		end
		
		if self.frontMarkerDistanceScaleBackup ~= nil then
			vehicle.frontMarkerDistanceScale = self.frontMarkerDistanceScaleBackup
			self.frontMarkerDistanceScaleBackup = nil
		end
	end
end

--******************************************************************************
function PWPackomat.preUpdateAIMovement( self, dt )

	if self.pwPackomat ~= nil then	
		if self.turnStage == 0 then
			self.pwPackomat.lastDir = nil
		elseif self.pwPackomat.lastDir == nil then
			self.pwPackomat.lastPos = { getWorldTranslation( self.aiTractorDirectionNode ) }
			self.pwPackomat.lastDir = { localDirectionToWorld( self.aiTractorDirectionNode, 1, 0, 0 ) }
		end
		self.aiToolExtraTargetMoveBack = 6
		if self.turnStage == 5 and self.pwPackomat.lastDir ~= nil then
			local x,y,z = getWorldTranslation( self.aiTractorDirectionNode )
			local dot   = math.abs((x-self.pwPackomat.lastPos[1]) * self.pwPackomat.lastDir[1] + (z-self.pwPackomat.lastPos[3]) * self.pwPackomat.lastDir[3])
			local toolAngle = 0
			if self.articulatedAxis == nil then
				toolAngle = math.abs(math.deg(PWPackomat.getRelativeYRotation( self.aiTractorDirectionNode, self.pwPackomat.steeringAxleNode )))
			end
			local width = 4
			if self.pwPackomat.aiLeftMarker == self.pwPackomat.PWaiLeftMarker2 then
				width = 6
			end			
			if dot < width + 2 or ( dot < width + 3.5 and toolAngle < 45 ) then
				self.aiToolExtraTargetMoveBack = 20
			else
				self.aiToolExtraTargetMoveBack = 0
			end
		else
			self.pwPackomat.lastDot = nil
		end
	end
	
end

AITractor.updateAIMovement = Utils.prependedFunction( AITractor.updateAIMovement, PWPackomat.preUpdateAIMovement )

--******************************************************************************
function PWPackomat.newDriveInDirection( self, superFunc, dt, steeringAngleLimit, acceleration, slowAcceleration, slowAngleLimit, allowedToDrive, moveForwards, lx, lz, ... )

	if lz ~= nil and lz > 0 and self.pwPackomat ~= nil and self.articulatedAxis == nil then
		local toolAngle = math.abs(math.deg(PWPackomat.getRelativeYRotation( self.aiTractorDirectionNode, self.pwPackomat.steeringAxleNode )))
		--self.aiSteeringSpeed = math.min(math.max( 0.1*math.abs(79-toolAngle), 0.1),1) * self.pwPackomat.aiSteeringSpeedBackup
		if toolAngle > 80 then
			lz = 0.978
		end
	end
	
	superFunc( self, dt, steeringAngleLimit, acceleration, slowAcceleration, slowAngleLimit, allowedToDrive, moveForwards, lx, lz, ... )	
end

AIVehicleUtil.driveInDirection = Utils.overwrittenFunction( AIVehicleUtil.driveInDirection, PWPackomat.newDriveInDirection )
