
--
-- @author  Fendt-Heinz
-- @date  27/02/2010
--

maehbalken = {};

function maehbalken.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function maehbalken :load(xmlFile)
	local numschutzs = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.schutzs#count"), 0);
    self.schutzs = {};
    for i=1, numschutzs do
        local schutznamei = string.format("vehicle.schutzs.schutz%d", i);
        self.schutzs[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, schutznamei .. "#index"));
        setVisibility(self.schutzs[i], true);
    end;
	self.schutzsActive = true;
	
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;

    local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
    if mowerSound ~= nil and mowerSound ~= "" then
        mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
        self.mowerSound = createSample("mowerSound");
        self.mowerSoundEnabled = false;
        loadSample(self.mowerSound, mowerSound, false);
        self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
        self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
    end;

    local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
        self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
    end;

    self.isTurnedOn = false;
    self.wasToFast = false;
	
	
	self.schneidwerk = {};
    self.schneidwerk.index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.schneidwerk#index"));
    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.schneidwerk#minRot"));
    self.schneidwerk.minRot = {};
    self.schneidwerk.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.schneidwerk.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.schneidwerk.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.schneidwerk#maxRot"));
    self.schneidwerk.maxRot = {};
    self.schneidwerk.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.schneidwerk.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.schneidwerk.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    self.schneidwerk.rotSpeed = Utils.getNoNil(getXMLString(xmlFile,  "vehicle.schneidwerk#rotSpeed"), 2)*1000;
	
	
	self.konsole = {};
    self.konsole.index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.konsole#index"));
    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.konsole#minRot"));
    self.konsole.minRot = {};
    self.konsole.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.konsole.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.konsole.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.konsole#maxRot"));
    self.konsole.maxRot = {};
    self.konsole.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.konsole.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.konsole.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    self.konsole.rotSpeed = Utils.getNoNil(getXMLString(xmlFile,  "vehicle.konsole#rotSpeed"), 2)*1000;
end;



function maehbalken:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym==Input.KEY_4 then
      self.schneidwerkAus = not self.schneidwerkAus;
    end;
	
	if isDown and sym==Input.KEY_5 then
      self.konsoleAus = not self.konsoleAus;
    end;

end;


function maehbalken:update(dt)
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.EMPTY_GRAIN) then
			self.schutzsActive = not self.schutzsActive;
		end;
	
		for k, schutz in pairs(self.schutzs) do
			setVisibility(schutz, self.schutzsActive);
		end;
	end;
	
	
	self.wasToFast = false;
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            self.isTurnedOn = not self.isTurnedOn;
        end;
    end;

    if self:getIsActive() then

        if self.isTurnedOn then
            local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
            if not toFast then
                local x,y,z = getWorldTranslation(self.groundReferenceNode);
                local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                if terrainHeight+self.groundReferenceThreshold >= y then
                    local foldAnimTime = self.foldAnimTime;
                    for k, cuttingArea in pairs(self.cuttingAreas) do
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                            Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
                        end;
                    end;
                end;
            end;

            if not self.mowerSoundEnabled and self:getIsActiveForSound() then
                setSamplePitch(self.mowerSound, self.mowerSoundPitchOffset);
                playSample(self.mowerSound, 0, self.mowerSoundVolume, 0);
                self.mowerSoundEnabled = true;
            end;

            self.wasToFast = toFast;

        else
            if self.mowerSoundEnabled then
                stopSample(self.mowerSound);
                self.mowerSoundEnabled = false;
            end;
        end;

    end;
	
	
	if self.schneidwerk ~= nil then
		local x, y, z = getRotation(self.schneidwerk.index);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.schneidwerk.maxRot, self.schneidwerk.minRot, 3, self.schneidwerk.rotSpeed, dt, self.schneidwerkAus);
		setRotation(self.schneidwerk.index, unpack(newRot));
	end;
	
	if self.konsole ~= nil then
		local x, y, z = getRotation(self.konsole.index);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.konsole.maxRot, self.konsole.minRot, 3, self.konsole.rotSpeed, dt, self.konsoleAus);
		setRotation(self.konsole.index, unpack(newRot));
	end;

end;

function maehbalken:draw()
    if self.isTurnedOn then
        g_currentMission:adExtraPrintText("");
    else
        g_currentMission:adExtraPrintText("");
    end;
	
	if self.schneidwerkAus then
        g_currentMission:adExtraPrintText("");
	else
        g_currentMission:adExtraPrintText("");
	end;
	if self.konsoleAus then
        g_currentMission:adExtraPrintText("");
	else
        g_currentMission:adExtraPrintText("");
	end;

    if self.wasToFast then
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
    end;
end;



function maehbalken:onEnter()

end;



function maehbalken:onLeave()
	for k, schutz in pairs(self.schutzs) do
		setVisibility(schutz, false);
	end;
	
	if self.deactivateOnLeave then
        Mower.onDeactivate(self);
    else
        Mower.onDeactivateSounds(self)
    end;
end;



function maehbalken:delete()
    if self.mowerSound ~= nil then
        delete(self.mowerSound);
    end;
end;

function maehbalken:onDeactivate()
    maehbalken.onDeactivateSounds(self)

    self.isTurnedOn = false;
end;

function maehbalken:onDeactivateSounds()
    if self.mowerSoundEnabled then
        stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;
    end;
end;


function maehbalken:mouseEvent(posX, posY, isDown, isUp, button)

end;



function key_convert(key)


end;



