--
-- NewHollandTrailerAddon
-- Specialization for NewHollandTrailerAddon
--
-- @author  	(Flagsystems) Manuel Leithner
-- @version 	v1.0
-- @date  		13/05/11
-- @history:	v1.0 - Initial version
--

NewHollandTrailerAddon = {};

function NewHollandTrailerAddon.prerequisitesPresent(specializations)
    return true;
end;

function NewHollandTrailerAddon:load(xmlFile)
	self.setCutterAttached = SpecializationUtil.callSpecializationsFunction("setCutterAttached");	

	self.jointsBackup = self.attacherJoints;
	self.attacherJoints = {};
	self.cutterInRange = nil;	
	self.cutterInRangeIndex = nil;
	self.attachedCutter = nil;	
end;

function NewHollandTrailerAddon:delete()
end;

function NewHollandTrailerAddon:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NewHollandTrailerAddon:keyEvent(unicode, sym, modifier, isDown)
end;

function NewHollandTrailerAddon:readStream(streamId, timestamp, connection)
    self:setCutterAttached(streamReadBool(streamId),true);
end;

function NewHollandTrailerAddon:writeStream(streamId, connection, dirtyMask)
    streamWriteBool(streamId, self.attachedCutter ~= nil);
end;

function NewHollandTrailerAddon:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then			
			if InputBinding.hasEvent(InputBinding.FIX_CUTTER) then
				if self.cutterInRange ~= nil then
					self:setCutterAttached(true);
				else
					if self.attachedCutter ~= nil then
						self:setCutterAttached(false);
					end;
				end;
			end;
		end;
	end;
end;

function NewHollandTrailerAddon:updateTick(dt)
	if self:getIsActive() then
		self.cutterInRange = nil;
		self.cutterInRangeIndex = nil;
		if self.attachedCutter == nil then		
			self.attacherJoints = self.jointsBackup;
			local cutter, index, vehicle = g_currentMission:getAttachableInRange(self,3);
			if cutter ~= nil then
				if self.attacherJoints[index].jointType == Vehicle.JOINTTYPE_CUTTER then
					self.cutterInRange = cutter; 
					self.cutterInRangeIndex = index;
				end;
			end;
			self.attacherJoints = {};
		end;
	end;
end;

function NewHollandTrailerAddon:draw()
	if self.cutterInRange ~= nil then
		g_currentMission.hudAttachmentOverlay:render();
		g_currentMission:addHelpButtonText(g_i18n:getText("ATTACH_CUTTER"), InputBinding.FIX_CUTTER);
	else
		if self.attachedCutter ~= nil then
			g_currentMission:addHelpButtonText(g_i18n:getText("DETACH_CUTTER"), InputBinding.FIX_CUTTER);
		end;
	end;
end;

function NewHollandTrailerAddon:setCutterAttached(doAttach, noEventSend)
	CutterFixationEvent.sendEvent(self, doAttach, noEventSend);
	
	if doAttach then
		self.attacherJoints = self.jointsBackup;
		g_currentMission.attachableInMountRange = self.cutterInRange;
		g_currentMission.attachableInMountRangeVehicle = self;
		g_currentMission.attachableInMountRangeIndex = self.cutterInRangeIndex;
		self:attachImplement(g_currentMission.attachableInMountRange, g_currentMission.attachableInMountRangeIndex, true);
		self.attachedCutter = self.attachedImplements[1].object;
		self.attachedCutter.allowsDetaching = false;
		
		if self.attachedCutter.fruitObjects ~= nil then
			local fruit = self.attachedCutter.fruitObjects;
			setRotation(fruit.node1, 0, fruit.node1Rot, 0);
			setRotation(fruit.node2, 0, fruit.node2Rot, 0);
		end;
	else		
		if self.attachedCutter ~= nil then
			if self.attachedCutter.fruitObjects ~= nil then
				local fruit = self.attachedCutter.fruitObjects;
				setRotation(fruit.node1, 0, 0, 0);
				setRotation(fruit.node2, 0, 0, 0);
			end;
			self.attachedCutter.allowsDetaching = true;
			self:detachImplement(1, true);
			self.attachedCutter = nil;
			self.attacherJoints = {};
		end;
	end;
end;
