Trappe = {};

function Trappe.prerequisitesPresent(specializations)
    return true
end;

function Trappe:load(xmlFile)
	self.toggleUnloadingState = SpecializationUtil.callSpecializationsFunction("toggleUnloadingState");   
    self.findTrailerRaycastCallback = Combine.findTrailerRaycastCallback;
    self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);
	
    self.pipeParticleSystem = {};
    self.pipeParticleSystemindex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pipeParticleSystem#index"));
    Utils.loadParticleSystem(xmlFile, self.pipeParticleSystem, "vehicle.pipeParticleSystem", self.pipeParticleSystemindex, false, nil, self.baseDirectory);
	
	
	self.trailerPosition = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.trailerPosition#index"));	
	self.grainUnloading = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainUnloading"), 10);	
	self.allowDoorOpen = true;
	self.pipeParticleActivated = false;	
	self.sowingMachineFound = 0;
end;

function Trappe:delete()
end;

function Trappe:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Trappe:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_n then
		self.Go.trappe = not self.Go.trappe; 
		self.Done.trappe = true; 
	end;
end;

function Trappe:update(dt)
	if self.Go.trappe ~= nil and self.Done.trappe then
		self:anim("trappe", false); 
	end; 	
	self.pipeParticleActivated = false;
	self.trailerFound = 0;
	self.sowingMachineFound = 0;
    if self.fillLevel > 0 and self.attacherVehicle ~= nil then	
        self.pipeParticleActivated = true;
		self.Go.trappe = true; 
		self.Done.trappe = true; 
        self.trailerFound = 0;
        local x,y,z = getWorldTranslation(self.trailerPosition);
        raycastAll(x, y, z, 4, -6, -6, "findTrailerRaycastCallback", 10, self);		
        local trailer = g_currentMission.objectToTrailer[self.trailerFound];
		local sowingMachine = nil;		
		if self.sowingMachineFound ~= 0 then	
			local implements = g_currentMission.attachables;
			for i=0, table.getn(implements) do
				if implements[i] ~= nil then
					if implements[i].rootNode == self.sowingMachineFound then
						sowingMachine = implements[i];
					end;
				end;			
			end;
		end;				
        if (self.trailerFound == 0 or not trailer:allowFillType(self.currentFillType)) and (self.sowingMachineFound == 0 or not sowingMachine:allowFillType(sowingMachine.FILLTYPE_WHEAT)) then
            self.pipeParticleActivated = false;
			self.Go.trappe = false;
        else
	    local deltaLevel = self.grainUnloading;
		if sowingMachine ~= nil then
			deltaLevel = math.min(deltaLevel, sowingMachine.capacity - sowingMachine.fillLevel);
		elseif trailer ~= nil then
			deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
		else
			deltaLevel = 0;
		end;

	    self.fillLevel = self.fillLevel-deltaLevel;
	        if self.fillLevel <= 0.0 then
	            deltaLevel = deltaLevel+self.fillLevel;
	            self.fillLevel = 0.0;
	            pipeParticleActivated = false;
	        end;
	        if deltaLevel == 0 then
	            self.pipeParticleActivated = false;
	        end;
	        self:setFillLevel(self.fillLevel, self.currentFillType);
			if sowingMachine ~= nil then
				sowingMachine:setFillLevel(sowingMachine.fillLevel+deltaLevel, sowingMachine.FILLTYPE_WHEAT);
			elseif trailer ~= nil then
				trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentFillType);
			end;
        end;	
    end;

	if self.pipeParticleActivated then
		Utils.setEmittingState(self.pipeParticleSystem, true);
	else
		Utils.setEmittingState(self.pipeParticleSystem, false);
	end;
end;

function Trappe:draw()
end;
function Trappe:setFillLevel(fillLevel, fillType)
	Trailer.setFillLevel(self, fillLevel, fillType);
end;

function Trappe:findTrailerRaycastCallback(transformId, x, y, z, distance)
    self.trailerFound = 0;
	self.sowingMachineFound = 0;
    if getUserAttribute(transformId, "vehicleType") == 2 then
        self.trailerFound = transformId;
    end;
	
	if getUserAttribute(transformId, "sowingMachine") then
		self.sowingMachineFound = transformId;
	end;
	
    return false;
end;

function Trappe:anim(varName, loopCheck)	
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
		end;
	end;
end; 