--
-- Vario1200
-- Specialization for Vario1200
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		03/09/11
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--

Vario1200 = {};

function Vario1200.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Vario1200:load(xmlFile)
	
	self.foldCameras = SpecializationUtil.callSpecializationsFunction("foldCameras");
	
	self.vario1200 = {};
	self.vario1200.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vario#index"));
	self.vario1200.fixpoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vario#fixpoint"));
	self.vario1200.maxTrans = {Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.vario#maxTrans"))};
	self.vario1200.minTrans = {getTranslation(self.vario1200.node)};
	self.vario1200.offset = 10;
	self.vario1200.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.vario#speed"), 11);
	self.vario1200.speedScaleTime = 5000;
	self.vario1200.speedScaleBackup = self.reelSpeedScale;
	self.vario1200.rollSpeedBackup = self.rollNodes[1].speed;
	self.vario1200.visNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vario#visNode"));
	self.vario1200.visTransAttach = getXMLFloat(xmlFile, "vehicle.vario#visTrans");
	local x,y,z = getTranslation(self.vario1200.visNode);
	self.vario1200.visTransDetach = y;
	self.doJointUpdateVis = false;
	self.reelSpeedScale = 0;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.speed = 0;
	end;
	
	self.blades = {};
	local vertical = {};
	vertical.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blades#vertical"));
	vertical.max = getXMLFloat(xmlFile, "vehicle.blades#vertMax");
	vertical.speed = getXMLFloat(xmlFile, "vehicle.blades#vertSpeed") * 1000;	
	vertical.dir = 1;
	local horizontal = {};
	horizontal.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blades#horizontal"));
	horizontal.max = getXMLFloat(xmlFile, "vehicle.blades#horizMax");
	horizontal.speed = getXMLFloat(xmlFile, "vehicle.blades#horizSpeed") * 1000;
	horizontal.dir = 1;
	
	self.blades.vertical = vertical;
	self.blades.horizontal = horizontal;
	
	self.specialJoint = {};
	self.specialJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.specialJoint#node"));
	self.specialJoint.backup = self.attacherJoint.node;
	
	self.vario1200.isExtended = false;
	self.vario1200.lastFruit = FRUITTYPE_UNKNOWN;
end;

function Vario1200:postLoad(xmlFile)
	self.mouseControlsIconsBackup = self.mouseControlsIcons;
	self.mouseControlsIcons = {};
	for _, tool in pairs(self.movingTools) do
		tool.isActive = false;
	end;
end;

function Vario1200:delete()
end;

function Vario1200:readStream(streamId, connection)
end;

function Vario1200:writeStream(streamId, connection)
end;

function Vario1200:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Vario1200:keyEvent(unicode, sym, modifier, isDown)
end;

function Vario1200:update(dt)

	Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastCutterAreaBiggerZero));

	if self.isServer and self.doJointUpdateVis and self.attacherVehicle ~= nil then
		if self:getIsAnimationPlaying("onAttach") then
			local implement = self.attacherVehicle:getImplementByObject(self);
			if implement ~= nil then
				local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				setJointFrame(jointDesc.jointIndex, 0, jointDesc.jointTransform);
			end;
		else
			self.doJointUpdateVis = false;
		end;
	end;
	
	if self:getIsActive() and self.reelStarted then
		if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing ~= nil then
			if not self.attacherVehicle.allowsThreshing then
				self.lastAreaBiggerZero = false;
				if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
					self:raiseDirtyFlags(self.cutterGroundFlag);
					self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
				end;
			end;
		end;
	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.vario1200.speed, 1.3));
	
		local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.vario1200.speedScaleBackup * percent}, {0}, 1, self.vario1200.speedScaleTime, dt, false);
		self.reelSpeedScale = speedScale[1];
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.vario1200.rollSpeedBackup * percent}, {0}, 1, self.vario1200.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
		
		if self.blades.vertical.node ~= nil then
			local _,y,_ = getTranslation(self.blades.vertical.node);
			if y < 0.005 or y > (self.blades.vertical.max - 0.005) then
				self.blades.vertical.dir = math.abs(self.blades.vertical.dir - 1);
			end;
			local newTrans = Utils.getMovedLimitedValues({y}, {self.blades.vertical.max}, {0}, 1, self.blades.vertical.speed / percent, dt, self.blades.vertical.dir ~= 0);
			setTranslation(self.blades.vertical.node, 0, unpack(newTrans), 0);
		end;
		if self.blades.horizontal.node ~= nil then
			local x,_,_ = getTranslation(self.blades.horizontal.node);
			if x < 0.005 or x > (self.blades.horizontal.max - 0.005) then
				self.blades.horizontal.dir = math.abs(self.blades.horizontal.dir - 1);
			end;
			local newTrans = Utils.getMovedLimitedValues({x}, {self.blades.horizontal.max}, {0}, 1, self.blades.horizontal.speed / percent, dt, self.blades.horizontal.dir ~= 0);
			setTranslation(self.blades.horizontal.node, unpack(newTrans), 0, 0);
		end;
	else
		if self.reelSpeedScale ~= 0 or self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.vario1200.speed, 1.5));
			
			local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.vario1200.speedScaleBackup * percent}, {0}, 1, self.vario1200.speedScaleTime*1.5, dt, true);
			self.reelSpeedScale = speedScale[1];
			rotate(self.reelNode, -dt*self.reelSpeed*self.reelSpeedScale, 0, 0);
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.vario1200.rollSpeedBackup * percent}, {0}, 1, self.vario1200.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
			
			local atx, aty, atz = getRotation(self.reelNode);
			for i=1, self.spikesCount do
				local spike = getChildAt(self.spikesRootNode, i-1);
				setRotation(spike, -atx, aty, atz);
			end;
		end;
	end;
end;

function Vario1200:updateTick(dt)
end;

function Vario1200:draw()	
end;

function Vario1200:onSelect()
	self.mouseControlsIcons = self.mouseControlsIconsBackup;
	for _, tool in pairs(self.movingTools) do
		tool.isActive = true;
	end;
end;

function Vario1200:onDeselect()
	self.mouseControlsIcons = {};
	for _, tool in pairs(self.movingTools) do
		tool.isActive = false;
	end;
end;

function Vario1200:onAttach(attacherVehicle)
	if attacherVehicle.allowsThreshing ~= nil then
		self:playAnimation("onAttach", 1, nil, true);
		self.doJointUpdateVis = true;
	end;
end;

function Vario1200:onDetach()	
	Cutter.updateExtraObjects(self);
	self:foldCameras(false);
	
	self:playAnimation("onAttach", -1000, nil, true);
end;

function Vario1200:foldCameras(reverse, speed)
	if speed == nil then
		speed = 1;
	end;
	local direction = -1;
	if reverse then
		direction = 1;
	end;

	local animTimeLadder = nil;
	if self:getIsAnimationPlaying("openCams") then			
		animTimeLadder = self:getAnimationTime("openCams");
	end;
	self:playAnimation("openCams", direction*speed, animTimeLadder, true);
end;

local oldUpdateExtraObjects = Cutter.updateExtraObjects;
Cutter.updateExtraObjects = function(self)
	oldUpdateExtraObjects(self);
	
	if self.vario1200 ~= nil and self.vario1200.lastFruit ~= fruitType then
		if fruitType == FruitUtil.FRUITTYPE_RAPE then
			if not self.vario1200.isExtended then
				setTranslation(self.vario1200.node, unpack(self.vario1200.maxTrans));
				self.vario1200.isExtended = true;
			end;		
		else
			if self.vario1200.isExtended then
				setTranslation(self.vario1200.node, unpack(self.vario1200.minTrans));
				self.vario1200.isExtended = false;
			end;		
		end;
		self.vario1200.lastFruit = fruitType;
	end;
end;
