--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu k�nnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.72, 0.38, 0.02, "Key Num 0: Info On");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.72, 0.38, 0.02, "Key Num 0: Info Off");
		renderText(0.72, 0.59, 0.025, "- Claas Jaguar 900 Cargo Info -");
		renderText(0.72, 0.56, 0.02, "Key Num 7: Left door open/close");
		renderText(0.72, 0.54, 0.02, "Key Num 1: Blinker links");
		renderText(0.72, 0.52, 0.02, "Key Num 2: Warnblinker");
		renderText(0.72, 0.50, 0.02, "Key Num 3: Blinker rechts");
		renderText(0.72, 0.48, 0.02, "Key y: Rotate bunkr");
        renderText(0.72, 0.46, 0.02, "Key n : Wiper");
		renderText(0.72, 0.43, 0.022, "- by Tonda CZ -");

	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;



