-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ClaasPUAreaEvent = {};
ClaasPUAreaEvent_mt = Class(ClaasPUAreaEvent, Event);

InitEventClass(ClaasPUAreaEvent, "ClaasPUAreaEvent");

function ClaasPUAreaEvent:emptyNew()
    local self = Event:new(ClaasPUAreaEvent_mt);
    return self;
end;

function ClaasPUAreaEvent:new(cuttingAreas, fruitType)
    local self = ClaasPUAreaEvent:emptyNew()
    self.cuttingAreas = cuttingAreas;
    self.fruitType = fruitType;
    return self;
end;

function ClaasPUAreaEvent:readStream(streamId, connection)
    local numAreas = streamReadUIntN(streamId, 4);
    local fruitType = streamReadUIntN(streamId, FruitUtil.sendNumBits);

    local params = g_currentMission.areaCompressionParams;
    local paramsRelative = g_currentMission.areaRelativeCompressionParams;
    for i=1, numAreas do
        local x = Utils.readCompressedWorldPosition(streamId, params);
        local z = Utils.readCompressedWorldPosition(streamId, params);
        local x1 = x + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local z1 = z + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local x2 = x + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local z2 = z + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
    end;
end;

function ClaasPUAreaEvent:writeStream(streamId, connection)
    local numAreas = table.getn(self.cuttingAreas);
    streamWriteUIntN(streamId, numAreas, 4);
    streamWriteUIntN(streamId, self.fruitType, FruitUtil.sendNumBits);

    local params = g_currentMission.areaCompressionParams;
    local paramsRelative = g_currentMission.areaRelativeCompressionParams;
    for i=1, numAreas do
        local d = self.cuttingAreas[i];
        Utils.writeCompressedWorldPosition(streamId, d[1], params);
        Utils.writeCompressedWorldPosition(streamId, d[2], params);
        Utils.writeCompressedWorldPosition(streamId, d[3] - d[1], paramsRelative);
        Utils.writeCompressedWorldPosition(streamId, d[4] - d[2], paramsRelative);
        Utils.writeCompressedWorldPosition(streamId, d[5] - d[1], paramsRelative);
        Utils.writeCompressedWorldPosition(streamId, d[6] - d[2], paramsRelative);
    end
end;

function ClaasPUAreaEvent:run(connection)
    print("Error: Do not run ClaasPUAreaEvent locally");
end;

function ClaasPUAreaEvent.runLocally(cuttingAreas, fruitType)
	
    local numAreas = table.getn(cuttingAreas);

    local params = g_currentMission.areaCompressionParams;
    local paramsRelative = g_currentMission.areaRelativeCompressionParams;

    local volumeSum = 0;
    local areaSum = 0;
    for i=1, numAreas do
        local d = cuttingAreas[i];
        local x = Utils.simWriteCompressedWorldPosition(d[1], params);
        local z = Utils.simWriteCompressedWorldPosition(d[2], params);
        local x1 = x + Utils.simWriteCompressedWorldPosition(d[3] - d[1], paramsRelative);
        local z1 = z + Utils.simWriteCompressedWorldPosition(d[4] - d[2], paramsRelative);
        local x2 = x + Utils.simWriteCompressedWorldPosition(d[5] - d[1], paramsRelative);
        local z2 = z + Utils.simWriteCompressedWorldPosition(d[6] - d[2], paramsRelative);

        local area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);

        if area > 0 then
            -- now that we removed the windrow, maybe there is some hidden drygrass to grow (set it to growth state 1 if there is some)
            if fruitType == FruitUtil.FRUITTYPE_GRASS then
                Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 1);
            end
            areaSum = areaSum + area;
			volumeSum = areaSum
        end
		
    end;
    return volumeSum, areaSum;
end;
