

ClaasV900 = {};

function ClaasV900.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function ClaasV900:load(xmlFile)
	
	self.foldCameras = SpecializationUtil.callSpecializationsFunction("foldCameras");
	
	self.ClaasV900 = {};
	
	self.ClaasV900.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.vario#speed"), 11);
	self.ClaasV900.speedScaleTime = 5000;
	self.ClaasV900.speedScaleBackup = self.reelSpeedScale;
	self.ClaasV900.rollSpeedBackup = self.rollNodes[1].speed;
	
	self.reelSpeedScale = 0;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.speed = 0;
	end;
	
	
	
	self.ClaasV900.lastFruit = FRUITTYPE_UNKNOWN;
end;

function ClaasV900:delete()
end;

function ClaasV900:readStream(streamId, connection)
end;

function ClaasV900:writeStream(streamId, connection)
end;

function ClaasV900:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ClaasV900:keyEvent(unicode, sym, modifier, isDown)
end;

function ClaasV900:update(dt)

	Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastAreaBiggerZero and self.particleSystemsVisible));

	
	
	if self:getIsActive() and self.reelStarted then
		if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing ~= nil then
			if not self.attacherVehicle.allowsThreshing then
				self.lastAreaBiggerZero = false;
				if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
					self:raiseDirtyFlags(self.cutterGroundFlag);
					self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
				end;
			end;
		end;
	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.ClaasV900.speed, 1.3));
	
		local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.ClaasV900.speedScaleBackup * percent}, {0}, 1, self.ClaasV900.speedScaleTime, dt, false);
		self.reelSpeedScale = speedScale[1];
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.ClaasV900.rollSpeedBackup * percent}, {0}, 1, self.ClaasV900.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
		
		
	else
		if self.reelSpeedScale ~= 0 or self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.ClaasV900.speed, 1.5));
			
			local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.ClaasV900.speedScaleBackup * percent}, {0}, 1, self.ClaasV900.speedScaleTime*1.5, dt, true);
			self.reelSpeedScale = speedScale[1];
			rotate(self.reelNode, -dt*self.reelSpeed*self.reelSpeedScale, 0, 0);
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.ClaasV900.rollSpeedBackup * percent}, {0}, 1, self.ClaasV900.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
			
			local atx, aty, atz = getRotation(self.reelNode);
			for i=1, self.spikesCount do
				local spike = getChildAt(self.spikesRootNode, i-1);
				setRotation(spike, -atx, aty, atz);
			end;
		end;
	end;
end;

function ClaasV900:updateTick(dt)
	
end;

function ClaasV900:draw()	
end;

function ClaasV660900:onAttach(attacherVehicle)
	
end;

function ClaasV900:onDetach()
	self:setFruitType(FruitUtil.FRUITTYPE_UNKNOWN);	
	Cutter.updateExtraObjects(self);
	
end;

