Godet = {};

  
function Godet.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Godet:load(xmlFile)

        self.groundContactReport = SpecializationUtil.callSpecializationsFunction("groundContactReport");
        self.contactReportNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.contactReportNode#index"));
       if self.contactReportNode == nil then
            self.contactReportNode = self.components[1].node;
        end;

        self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
        self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
        self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel;
        self.aiTerrainDetailChannel2 = g_currentMission.cultivatorChannel;
        self.GodetHasGroundContact = false;
        self.GodetHasContactReport = false;
        self.translationMax = false;
        self.GodetContactReportsActive = false;
        self.GodetLimitToField = false;
        self.GodetGroundContactFlag = self.nextDirtyFlag;
        self.nextDirtyFlag = self.GodetGroundContactFlag*2;
        
        self.fillremplissage = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillremplissage"), 500);
        
        

        
end;
  
function Godet:delete()

       Godet.removeContactReports(self);
   end;
 
   function Godet:readStream(streamId, connection)
   end;
 
   function Godet:writeStream(streamId, connection)
   end;
 

   function Godet:readUpdateStream(streamId, timestamp, connection)
       if connection:getIsServer() then
           self.GodetHasGroundContact = streamReadBool(streamId);
       end;
   end;

   function Godet:writeUpdateStream(streamId, connection, dirtyMask)
      if not connection:getIsServer() then
          streamWriteBool(streamId, self.GodetHasGroundContact);
       end;
   end;
   function Godet:mouseEvent(posX, posY, isDown, isUp, button)
   end;
 
   function Godet:keyEvent(unicode, sym, modifier, isDown)

   end;
 
   function Godet:update(dt)
   end;
 
   function Godet:updateTick(dt)

   
          if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
        self.translationMax = not self.translationMax;
     end;
      end;
   
              if self.isServer then



               local hasGroundContact = self.GodetHasContactReport;
               if not hasGroundContact then
                   if self.groundReferenceNode ~= nil then
                       local x,y,z = getWorldTranslation(self.groundReferenceNode);
                       local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                       if terrainHeight+self.groundReferenceThreshold >= y then
                           hasGroundContact = true;
                       end;
                   end;
               end;

               if self.GodetHasGroundContact ~= hasGroundContact then
                   self:raiseDirtyFlags(self.GodetGroundContactFlag);
               end;
               self.GodetHasGroundContact = hasGroundContact;
           end;
                      local hasGroundContact = self.GodetHasGroundContact;

           if hasGroundContact then
                if self.movingDirection == -1 then
                if self.fillLevel ~= self.capacity then
                  if self.translationMax then
                   if self.isServer then
                          local cuttingAreasSend = {};
                          for k, cuttingArea in pairs(self.cuttingAreas) do
                               if self:getIsAreaActive(cuttingArea) then
                                   local x,y,z = getWorldTranslation(cuttingArea.start);
                                   local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                                   local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                                   --Utils.updatePloughArea(x, z, x1, z1, x2, z2, not self.PloughLimitToField);
                                   table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                               end;
                           end;
                           if (table.getn(cuttingAreasSend) > 0) then
 
                               PloughAreaEvent.runLocally(cuttingAreasSend, limitToField);
                               g_server:broadcastEvent(PloughAreaEvent:new(cuttingAreasSend, limitToField));
                               local usage = self.fillremplissage * dt*0.001;
                               local usedFruitType = FruitUtil.FRUITTYPE_SAND;
                               local usedFillType = FruitUtil.fruitTypeToFillType[usedFruitType];                                                                             
                               self:setFillLevel(self.fillLevel + usage, usedFillType);
                               


                           end;
                       end;
                       end;
                        end;
                        end;
                        end;

               
   end;
 
   function Godet:draw()
   
    if self.translationMax then
    g_currentMission:addExtraPrintText("Touche x: desactiver terrassement");
    else
    g_currentMission:addExtraPrintText("Touche x: activer terrassement");
    end;
   end;
 

   function Godet:onAttach(attacherVehicle)

       Godet.addContactReports(self);

   end;
   function Godet:onDetach()


       if self.deactivateOnDetach then
           Godet.removeContactReports(self);
       end;

   end;
 
   function Godet:onActivate()
   end;
 
   function Godet:onDeactivate()
   end;
 
   function Godet:onDeactivateSounds()
   end;
 
   function Godet:aiRotateLeft()
   end;
 
   function Godet:aiRotateRight()
   end;
 
   function Godet:aiTurnOn()
   end;
 
   function Godet:aiTurnOff()
   end;
 
   function Godet:aiInvertsMarkerOnTurn(turnLeft)
   end;
 
   function Godet:addContactReports()
       if not self.GodetContactReportsActive then
           addContactReport(self.contactReportNode, 0.0001, "groundContactReport", self);

           self.GodetContactReportsActive = true;
       end;
   end;

   function Godet:removeContactReports()
       if self.GodetContactReportsActive then
           removeContactReport(self.contactReportNode);
           self.GodetHasContactReport = false;
           self.GodetContactReportsActive = false;
       end;
   end;
 
function Godet:groundContactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)

       if otherObjectId == g_currentMission.terrainRootNode then

           self.GodetHasContactReport = isStart or normalForce > 0 or tangentialForce > 0;
       end;

end;
   function Godet:setRotationMax(rotationMax, noEventSend)
   end;