--
-- spudsBox
-- Specialization for spuds box
--
-- @author  PeterJ - euroDZN
-- @date  08/09/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

spudsBox = {};

function spudsBox.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Shovel, specializations);
end;

function spudsBox:load(xmlFile)
	
	self.tipSideFix = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.shovel#tipSideFix"));
end;

function spudsBox:delete()
end;
  
function spudsBox:readStream(streamId, connection)
end;

function spudsBox:writeStream(streamId, connection)
end;

function spudsBox:mouseEvent(posX, posY, isDown, isUp, button)
end;

function spudsBox:keyEvent(unicode, sym, modifier, isDown)
end;

function spudsBox:update(dt)
	if self:getIsActive() then
		if self.tipSideFix ~= nil and self.operateTipSideFix then
			if self.attacherVehicle.flipTipSide then
				setRotation(self.tipSideFix, 0, math.rad(180),0);
			else
				setRotation(self.tipSideFix, 0,0,0);
			end;
			self.operateTipSideFix = false;
		end;
	end;
end;

function spudsBox:draw()
end;

function spudsBox:onAttach()
	self.operateTipSideFix = true;
end; 	

function spudsBox:onDetach()
end;