--
-- BogballeBM1250
-- Class for Bogballe BM1250
--
-- @author  PeterJ - euroDZN
-- @date  15/08/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

BogballeBM1250 = {};

function BogballeBM1250.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function BogballeBM1250:load(xmlFile)

	---- fix pto of attached tools ----
	self.PTOfix = {};		
	self.PTOfix.joint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.powerShaft#joint"));
	if self.PTOfix.joint ~= nil then
		local x,y,z = getTranslation(self.PTOfix.joint);
		self.ptoJointPosition = {x,y,z};
		
		local i=0;
		while true do
			local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
			local index = getXMLString(xmlFile, baseName.. "#index");
			if index == nil then
				break;
			end;		
			local joint = self.attacherJoints[i+1];
			local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#ptoOutputNode"));
			if shaftAttacher ~= nil then
				joint.powerShaftAttacher = shaftAttacher;
			end;
			i = i + 1;
		end;
	end;
	self.PTOfix.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.powerShaft#index"));
	self.PTOfix.transPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.powerShaft#transPart"));
	self.PTOfix.refPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.powerShaft#fixPoint"));
	if self.PTOfix.index ~= nil then
		local ax, ay, az = getWorldTranslation(self.PTOfix.transPart);
		local bx, by, bz = getWorldTranslation(self.PTOfix.refPoint);		
		self.PTOfix.refDist = Utils.vector3Length(ax-bx, ay-by, az-bz);
		setVisibility(self.PTOfix.index, false);
	end;

	---- hydraulic hose ----
	self.hose = {};		
	self.hose.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.implementLinks.hose#index"));
	local x,y,z = getRotation(self.hose.node);
	self.hose.rot = {x,y,z};
	self.hose.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.implementLinks.hose#scalePart"));
	self.hose.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.implementLinks.hose#fixPoint"));
	if self.hose.node ~= nil and self.hose.part ~= nil then
		local ax, ay, az = getWorldTranslation(self.hose.part);
		local bx, by, bz = getWorldTranslation(self.hose.fixPoint);		
		self.hose.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.useHose = true;
	end;
	self.attacherVehicleHose = nil;
	
	---- support anim ----
	self.supportLegAnim = getXMLString(xmlFile, "vehicle.supportLeg#animationName");
	self.colJointAnim = getXMLString(xmlFile, "vehicle.colJointAnim#animationName");
	self.numOfImplements = 0;
end;

function BogballeBM1250:delete()
end;

function BogballeBM1250:keyEvent(unicode, sym, modifier, isDown)
end;

function BogballeBM1250:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
--[[function BogballeBM1250:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local animTime = getXMLFloat(xmlFile, key.."#supportAnimTime");
	if animTime ~= nil then
		BogballeBM1250.setAnimTime(self, animTime)
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function BogballeBM1250:getSaveAttributesAndNodes(nodeIdent)
	if self.supportLegAnim ~= nil then
		local animTime = self:getAnimationTime(self.supportLegAnim);
		local attributes = 'supportAnimTime="'..animTime..'"';
		return attributes, nil;
	end;
end;]]

function BogballeBM1250:update(dt)
	if self:getIsActive() then
		if self.PTOfix.joint ~= nil then
			for i=1, table.getn(self.attacherVehicle.attachedImplements) do
				if self.attacherVehicle.attachedImplements[i].object == self then			
					local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
					local joint = self.attacherVehicle.attacherJoints[index];
					if self.doJointSearch then
						if joint.ptoOutput ~= nil then
							link(joint.ptoOutput.node, self.PTOfix.joint);
							setTranslation(self.PTOfix.joint, 0,0,0);
						elseif joint.powerShaftAttacher ~= nil then
							link(joint.powerShaftAttacher, self.PTOfix.joint);
							setTranslation(self.PTOfix.joint, 0,0,0);
						end;
						if joint.hydrahoseAttacher ~= nil then
							self.attacherVehicleHose = joint.hydrahoseAttacher;
						else
							local implement = self.attacherVehicle:getImplementByObject(self);
							local attacherJoint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
							if attacherJoint.topArm ~= nil then
								local hydraJointNode = createTransformGroup("hydraJointNode");
								link(attacherJoint.topArm.rotationNode, hydraJointNode);
								setTranslation(hydraJointNode, -0.2, 0, 0);
								self.attacherVehicleHose = hydraJointNode;
							else	
								local hydraJointNode = createTransformGroup("hydraJointNode");
								link(joint.jointTransform, hydraJointNode);
								setTranslation(hydraJointNode, -0.4, 0.7, 0.2);
								self.attacherVehicleHose = hydraJointNode;
							end;
						end;
						self.doJointSearch = false;
					end;
				end;
			end;
		end;
		if self.PTOfix.index ~= nil and self.PTOfix.joint ~= nil then		
			local ax, ay, az = getWorldTranslation(self.PTOfix.index);
			local bx, by, bz = getWorldTranslation(self.PTOfix.joint);
			local x, y, z = worldDirectionToLocal(getParent(self.PTOfix.index), bx-ax, by-ay, bz-az);
			setDirection(self.PTOfix.index, x, y, z, 0, -1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.PTOfix.transPart, 0, 0, distance-self.PTOfix.refDist);		
		end;
		if self.attacherVehicleHose ~= nil and self.useHose then		
			local ax, ay, az = getWorldTranslation(self.hose.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehicleHose);
			local x, y, z = worldDirectionToLocal(getParent(self.hose.node), bx-ax, by-ay, bz-az);
			setDirection(self.hose.node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setScale(self.hose.part, 1, 1, distance/self.hose.distance);
		end;
	end;
end;

function BogballeBM1250:draw()
end;

function BogballeBM1250:onAttach(attacherVehicle)
	self.doJointSearch = true;
	setVisibility(getParent(self.PTOfix.index), true);
	if self.supportLegAnim ~= nil and self.playAnimation ~= nil then
		self:playAnimation(self.supportLegAnim, 1, nil, true);
	end;
end;

function BogballeBM1250:onDetach()
	link(getParent(self.PTOfix.index), self.PTOfix.joint);
	setTranslation(self.PTOfix.joint, unpack(self.ptoJointPosition));
	setVisibility(getParent(self.PTOfix.index), false);
	setRotation(self.hose.node, unpack(self.hose.rot));
	setScale(self.hose.part, 1, 1, 1);
	self.doJointSearch = false;
	if self.supportLegAnim ~= nil and self.playAnimation ~= nil then
		if self.numOfImplements < 1 then
			self:playAnimation(self.supportLegAnim, -1, nil, true);
		end;
	end;
end;
  
function BogballeBM1250:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;	
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.ptoInput ~= nil then
			if implement.object.ptoInput.node ~= nil then
				setVisibility(self.PTOfix.index, true);
				link(implement.object.ptoInput.node, self.PTOfix.index);
			end;
		end;
		self.numOfImplements = self.numOfImplements + 1;
		if self.colJointAnim ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.colJointAnim, 1, nil, true);
		end;
	end;
end;

function BogballeBM1250:detachImplement(implementIndex, noEventSend)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	if jointIndex == 1 then
		link(getParent(self.PTOfix.index), self.PTOfix.index);
		setVisibility(self.PTOfix.index, false);
		self.numOfImplements = math.max(0, self.numOfImplements - 1);
		if self.colJointAnim ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.colJointAnim, -1, nil, true);
		end;
	end;
end;

function BogballeBM1250:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

--[[function BogballeBM1250.setAnimTime(self, animTime)
	if self.supportLegAnim ~= nil then
		local animDuration = self:getAnimationDuration(self.supportLegAnim);
		local stopAnimTime = (animTime*animDuration)/animDuration;
		self:playAnimation(self.supportLegAnim, 1, nil, true);
		self:setAnimationStopTime(self.supportLegAnim, stopAnimTime);
		AnimatedVehicle.updateAnimationByName(self, self.supportLegAnim, 99999999);
		print("running here");
	end;
end;]]