-- MultiFruitUtil
-- by mor2000
-- v1.0

-- diesen Pfad anpassen, falls Script in Karte verbaut wird
-- change this path if you use the script in a map

local texturePath = "mods/Brunzdorf_3_2_Forstmod/neu/HUD/"
local userProfileAppPath = getUserProfileAppPath()

MultiFruitUtil = {}
MultiFruitUtil.printMsg = true
MultiFruitUtil.prePrint = "  [MultiFruitUtil] "
MultiFruitUtil.addedFruitTypes = {}

-- Farben
-- colors

MultiFruitUtil.fruitMapColor={}
MultiFruitUtil.fruitMapColor["wheat"]={1.000,1.000,0.063,1}
MultiFruitUtil.fruitMapColor["dinkel"]={0.839,0.776,0.063,1}
MultiFruitUtil.fruitMapColor["triticale"]={1.000,1.000,0.420,1}
MultiFruitUtil.fruitMapColor["greenwheat"]={0.871,0.969,0.388,1}
MultiFruitUtil.fruitMapColor["barley"]={1.000,0.518,0.161,1}
MultiFruitUtil.fruitMapColor["rye"]={0.839,0.388,0.129,1}
MultiFruitUtil.fruitMapColor["oat"]={1.000,0.710,0.451,1}
MultiFruitUtil.fruitMapColor["rape"]={0.678,0.000,0.000,1}
MultiFruitUtil.fruitMapColor["sunflower"]={1.000,0.388,0.259,1}
MultiFruitUtil.fruitMapColor["millet"]={1.000,0.776,0.647,1}
MultiFruitUtil.fruitMapColor["mohn"]={1.000,0.192,0.094,1}
MultiFruitUtil.fruitMapColor["potato"]={0.192,0.322,0.647,1}
MultiFruitUtil.fruitMapColor["sugarBeet"]={0.580,0.839,0.906,1}
MultiFruitUtil.fruitMapColor["rotkohl"]={0.031,0.161,0.518,1}
MultiFruitUtil.fruitMapColor["blumkohl"]={0.741,0.776,0.871,1}
MultiFruitUtil.fruitMapColor["wirsingkohl"]={0.000,0.647,0.776,1}
MultiFruitUtil.fruitMapColor["weisskohl"]={0.388,0.451,0.710,1}
MultiFruitUtil.fruitMapColor["maize"]={0.808,0.518,0.776,1}
MultiFruitUtil.fruitMapColor["tomato"]={0.906,0.549,0.776,1}
MultiFruitUtil.fruitMapColor["cucumber"]={0.549,0.000,0.482,1}
MultiFruitUtil.fruitMapColor["onion"]={0.420,0.000,0.259,1}
MultiFruitUtil.fruitMapColor["carrot"]={0.839,0.192,0.580,1}
MultiFruitUtil.fruitMapColor["grass"]={0.070,0.550,0.000,1}
MultiFruitUtil.fruitMapColor["energieweide"]={0.580,0.839,0.224,1}
MultiFruitUtil.fruitMapColor["soybean"]={0.808,0.937,0.741,1}
MultiFruitUtil.fruitMapColor["pea"]={0.388,0.612,0.094,1}
MultiFruitUtil.fruitMapColor["erbse"]={0.388,0.612,0.094,1}
MultiFruitUtil.fruitMapColor["luzerne"]={0.678,0.871,0.388,1}
MultiFruitUtil.fruitMapColor["klee"]={0.161,0.612,0.224,1}


-- Reihenfolge
-- view order

MultiFruitUtil.viewOrder={"wheat","dinkel","triticale","greenwheat","barley","rye","oat","rape","sunflower",
			"millet","mohn","potato","sugarBeet","rotkohl","blumkohl","wirsingkohl","weisskohl","maize",
			"tomato","cucumber","onion","carrot","grass","energieweide","soybean","pea","erbse","luzerne",
			"klee"}

-- Bezeichnungen
-- names

MultiFruitUtil.nameI18N={}
MultiFruitUtil.nameI18N["wheat"]=tostring(g_i18n:getText("wheat"))
MultiFruitUtil.nameI18N["dinkel"]=tostring(g_i18n:getText("dinkel"))
MultiFruitUtil.nameI18N["triticale"]=tostring(g_i18n:getText("triticale"))
MultiFruitUtil.nameI18N["barley"]=tostring(g_i18n:getText("barley"))
MultiFruitUtil.nameI18N["rye"]=tostring(g_i18n:getText("rye"))
MultiFruitUtil.nameI18N["oat"]=tostring(g_i18n:getText("oat"))
MultiFruitUtil.nameI18N["rape"]=tostring(g_i18n:getText("rape"))
MultiFruitUtil.nameI18N["sunflower"]=tostring(g_i18n:getText("sunflower"))
MultiFruitUtil.nameI18N["millet"]=tostring(g_i18n:getText("millet"))
MultiFruitUtil.nameI18N["mohn"]=tostring(g_i18n:getText("mohn"))
MultiFruitUtil.nameI18N["potato"]=tostring(g_i18n:getText("potato"))
MultiFruitUtil.nameI18N["sugarBeet"]=tostring(g_i18n:getText("sugarBeet"))
MultiFruitUtil.nameI18N["rotkohl"]=tostring(g_i18n:getText("rotkohl"))
MultiFruitUtil.nameI18N["blumkohl"]=tostring(g_i18n:getText("blumkohl"))
MultiFruitUtil.nameI18N["wirsingkohl"]=tostring(g_i18n:getText("wirsingkohl"))
MultiFruitUtil.nameI18N["weisskohl"]=tostring(g_i18n:getText("weisskohl"))
MultiFruitUtil.nameI18N["maize"]=tostring(g_i18n:getText("maize"))
MultiFruitUtil.nameI18N["tomato"]=tostring(g_i18n:getText("tomato"))
MultiFruitUtil.nameI18N["cucumber"]=tostring(g_i18n:getText("cucumber"))
MultiFruitUtil.nameI18N["onion"]=tostring(g_i18n:getText("onion"))
MultiFruitUtil.nameI18N["carrot"]=tostring(g_i18n:getText("carrot"))
MultiFruitUtil.nameI18N["grass"]=tostring(g_i18n:getText("grass"))
MultiFruitUtil.nameI18N["soybean"]=tostring(g_i18n:getText("soybean"))
MultiFruitUtil.nameI18N["pea"]=tostring(g_i18n:getText("pea"))
MultiFruitUtil.nameI18N["erbse"]=tostring(g_i18n:getText("erbse"))
MultiFruitUtil.nameI18N["gelbbo"]=tostring(g_i18n:getText("gelbbo"))
MultiFruitUtil.nameI18N["gruenbo"]=tostring(g_i18n:getText("gruenbo"))
MultiFruitUtil.nameI18N["energieweide"]=tostring(g_i18n:getText("energieweide"))
MultiFruitUtil.nameI18N["greenwheat"]=tostring(g_i18n:getText("greenwheat"))
MultiFruitUtil.nameI18N["klee"]=tostring(g_i18n:getText("klee"))
MultiFruitUtil.nameI18N["luzerne"]=tostring(g_i18n:getText("luzerne"))

-- Icons
-- icons

MultiFruitUtil.hudOverlayFilename={}
MultiFruitUtil.hudOverlayFilename["dinkel"]=Utils.getFilename(texturePath.."hud_dinkel.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["oat"]=Utils.getFilename(texturePath.."hud_oat.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["mohn"]=Utils.getFilename(texturePath.."hud_mohn.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["rye"]=Utils.getFilename(texturePath.."hud_rye.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["sunfower"]=Utils.getFilename(texturePath.."hud_sunflower.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["triticale"]=Utils.getFilename(texturePath.."hud_triticale.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["millet"]=Utils.getFilename(texturePath.."hud_millet.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["onion"]=Utils.getFilename(texturePath.."hud_onion.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["carrot"]=Utils.getFilename(texturePath.."hud_carrot.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["tomato"]=Utils.getFilename(texturePath.."hud_tomato.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["apfel"]=Utils.getFilename(texturePath.."hud_apfel.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["greenwheat"]=Utils.getFilename(texturePath.."greenwheatHud.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["klee"]=Utils.getFilename(texturePath.."kleeHud.dds", userProfileAppPath)
MultiFruitUtil.hudOverlayFilename["luzerne"]=Utils.getFilename(texturePath.."luzerneHud.dds", userProfileAppPath)

-- Funktionen
-- functions

function MultiFruitUtil.print(str, forceMsg)
	if(MultiFruitUtil.printMsg == true or forceMsg == true)then
		print(MultiFruitUtil.prePrint..str)
	end
end

-- Basisfunktion zum Hinzufügen neuer Fruchtsorten, Anwendungsbeispiel siehe weiter unten
-- main function to add new fruittype, for examples see below
	
function MultiFruitUtil.registerFruitType(desc)
	
	if(type(desc) ~= "table" or desc.name == nil or desc.hudOverlayFilename == nil) then
		MultiFruitUtil.print("Error while registering fruit type: No name or hud file provided", true)
		return false
	end
	
	-- fill description with standard values if not provided
	desc.needsSeeding = Utils.getNoNil(desc.needsSeeding, true)
	desc.nameI18N = Utils.getNoNil(desc.nameI18N, Utils.getNoNil(MultiFruitUtil.nameI18N[desc.name], "unknown"))	
	desc.allowsSeeding = Utils.getNoNil(desc.allowsSeeding, true)
	desc.useSeedingWidth = Utils.getNoNil(desc.useSeedingWidth, false)
	desc.directionSnapAngle = Utils.getNoNil(desc.directionSnapAngle, 0)
	desc.minHarvestingGrowthState = Utils.getNoNil(desc.minHarvestingGrowthState, 4)
	desc.maxHarvestingGrowthState = Utils.getNoNil(desc.maxHarvestingGrowthState, 6)
	desc.cutState = Utils.getNoNil(desc.cutState, 8)
	desc.allowsPartialGrowthState = Utils.getNoNil(desc.allowsPartialGrowthState, 0)
	desc.pricePerLiter = Utils.getNoNil(desc.pricePerLiter, 0.9)
	desc.literPerSqm = Utils.getNoNil(desc.literPerSqm, 1.2)
	desc.seedUsagePerSqm = Utils.getNoNil(desc.seedUsagePerSqm, 0.1)
	desc.partOfEconomy = Utils.getNoNil(desc.partOfEconomy, true)
	desc.fruitMapColor = Utils.getNoNil(desc.fruitMapColor, Utils.getNoNil(MultiFruitUtil.hudOverlayFilename[desc.name],{0.1, 0.1, 0.1, 1}))

	MultiFruitUtil.print("Register fruit type: "..tostring(desc.name))

	-- register fuit type
	FruitUtil.registerFruitType(
		desc.name,
		desc.nameI18N,
		desc.needsSeeding,
		desc.allowsSeeding,
		desc.useSeedingWidth,
		desc.directionSnapAngle,
		desc.minHarvestingGrowthState,
		desc.maxHarvestingGrowthState,
		desc.cutState,
		desc.allowsPartialGrowthState,
		desc.pricePerLiter,
		desc.literPerSqm,
		desc.seedUsagePerSqm,
		desc.partOfEconomy,
		desc.hudOverlayFilename,
		desc.fruitMapColor)
	
	local fruitType = FruitUtil.fruitTypes[desc.name].index
	if(desc.allowsSeeding)then
		table.insert(MultiFruitUtil.addedFruitTypes, fruitType)
	end
		
	if(desc.hasWindrow ~= nil and desc.hasWindrow==true) then
		desc.windrowPricePerLiter = Utils.getNoNil(desc.windrowPricePerLiter, 0.04)
		desc.windrowLiterPerSqm = Utils.getNoNil(desc.windrowLiterPerSqm, 3)
		
		local name_windrow = tostring(desc.name).."_windrow"
		MultiFruitUtil.print("Register fruit type: "..name_windrow)
		FruitUtil.registerFruitTypeWindrow(fruitType, name_windrow,
				g_i18n:getText(name_windrow), desc.windrowPricePerLiter, desc.windrowLiterPerSqm,
				false, "dataS2/missions/hud_fill_straw.png")
		if(desc.forageWagonConversionTarget ~= nil)then
			FruitUtil.registerFruitTypeWindrowForageWagonConversion(
				FruitUtil.fruitTypes[desc.name].index,
				FruitUtil.fruitTypes[desc.forageWagonConversionTarget].index)
		end
	end

	return true
	
end

-- Funktion um eine Eigenschaft einer Fruchtsorte nachträglich zu ändern
-- function to change a attribute of a fruittype afterwards
	
function MultiFruitUtil.changeAttribute(fruitType, attribute, value)
	if(type(FruitUtil.fruitTypes[fruitType])=="table")then
		if(attribute=="name" or		
			attribute=="nameI18N" or
			attribute=="pricePerLiter" or
			attribute=="partOfEconomy" or
			attribute=="hudOverlayFilename")then
			if(type(Fillable.fillTypeIndexToDesc[Fillable.fillTypeNameToInt[fruitType]][attribute])~=nil)then
				Fillable.fillTypeIndexToDesc[Fillable.fillTypeNameToInt[fruitType]][attribute] = value
			end
			if(type(Fillable.fillTypeNameToDesc[fruitType][attribute])~=nil)then
				Fillable.fillTypeNameToDesc[fruitType][attribute] = value
			end	
		else
			if(type(FruitUtil.fruitTypes[fruitType][attribute])~=nil)then
				FruitUtil.fruitTypes[fruitType][attribute]=value
			end
		end
	end
end

-- Funktion zum Überprüfen ob die aktuelle Karte eine bestimmte Fruchtsorte hat
-- function to check if the map has a fruittype

function MultiFruitUtil.mapHasFruitType(fruitType)
	return g_currentMission.fruits[fruitType]~=nil
end

-- BEISPIELE für neue Fruchtsorten - die Map muss allerdings die entsprechende Vorraussetzungen haben!!
-- EXAMPLES how to add a new fruittype - the map has to have the preconditions for that!!

									
MultiFruitUtil.registerFruitType({ name = "klee",
									--cutState = 1,
									pricePerLiter = 0.9,
									literPerSqm = 1.2,
									hudOverlayFilename = Utils.getFilename(texturePath.."kleeHud.dds", userProfileAppPath),
									hasWindrow = true,
									forageWagonConversionTarget = "grass" })

MultiFruitUtil.registerFruitType({ name = "luzerne",
									--cutState = 1,
									pricePerLiter = 0.9,
									literPerSqm = 1.2,
									hudOverlayFilename = Utils.getFilename(texturePath.."luzerneHud.dds", userProfileAppPath),
									hasWindrow = true,
									forageWagonConversionTarget = "grass" })									

--[[
MultiFruitUtil.registerFruitType({ name = "greenwheat",
									pricePerLiter = 0.9,
									literPerSqm = 1.2,
									hudOverlayFilename = Utils.getFilename(texturePath.."greenwheatHud.dds", userProfileAppPath),
									hasWindrow = true,
									forageWagonConversionTarget = "grass" })
									
									
MultiFruitUtil.registerFruitType({ name = "dinkel",
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/dinkelHud.dds", userProfileAppPath),
									hasWindrow = true,
									pricePerLiter = 0.35,
									literPerSqm = 1.35,
									forageWagonConversionTarget = "wheat" } )


MultiFruitUtil.registerFruitType({ name = "oat",
									pricePerLiter = 0.9,
									literPerSqm = 1.2,
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/oatHud.dds", userProfileAppPath),
									hasWindrow = true,
									forageWagonConversionTarget = "wheat" })

MultiFruitUtil.registerFruitType({ name = "millet",
									pricePerLiter = 1.1,
									literPerSqm = 1.3,
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/milletHud.dds", userProfileAppPath),
									})

MultiFruitUtil.registerFruitType({ name = "triticale",
									pricePerLiter = 0.9,
									literPerSqm = 1.2,
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/triticaleHud.dds", userProfileAppPath),
									hasWindrow = true,
									forageWagonConversionTarget = "wheat" })
									
MultiFruitUtil.registerFruitType({ name = "rye",
									pricePerLiter = 0.9,
									literPerSqm = 1.2,
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/ryeHud.dds", userProfileAppPath),
									hasWindrow = true,
									forageWagonConversionTarget = "wheat" })
									
MultiFruitUtil.registerFruitType({ name = "soybean",
									pricePerLiter = 0.9,
									literPerSqm = 1.2,
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/soybeanHud.dds", userProfileAppPath),
									})

MultiFruitUtil.registerFruitType({ name = "sunflower",
									pricePerLiter = 0.9,
									literPerSqm = 1.2,
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/sunflowerHud.dds", userProfileAppPath),
									})

MultiFruitUtil.registerFruitType({ name = "onion",
									pricePerLiter = 0.35,
									literPerSqm = 3.2,
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/onionHud.dds", userProfileAppPath),
									})

MultiFruitUtil.registerFruitType({ name = "carrot",
									pricePerLiter = 0.35,
									literPerSqm = 3.1,
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/carrotHud.dds", userProfileAppPath),
									})

MultiFruitUtil.registerFruitType({ name = "cucumber",
									pricePerLiter = 0.1,
									literPerSqm = 1.5,
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/cucumberHud.dds", userProfileAppPath),
									})

MultiFruitUtil.registerFruitType({ name = "tomato",
									pricePerLiter = 0.1,
									literPerSqm = 1.5,
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/tomatoHud.dds", userProfileAppPath),
									})

MultiFruitUtil.registerFruitType({ name = "pea",
									pricePerLiter = 0.1,
									literPerSqm = 1.5,
									hudOverlayFilename = Utils.getFilename(texturePath.."hudfiles/peaHud.dds", userProfileAppPath),
									})
--]]

-- fügt alle neuen Fruchtsorten den Sämaschinen hinzu
-- adds all new fruittypes to the sowing machines

local OldSowingMachineLoad = SowingMachine.load

SowingMachine.load = function (self, xmlFile)
	if OldSowingMachineLoad ~= nil then
		OldSowingMachineLoad(self, xmlFile)
	end
	
	for _,index in pairs(MultiFruitUtil.addedFruitTypes) do
		if MultiFruitUtil.mapHasFruitType(index) then
			table.insert(self.seeds, index)
		end
	end
end


-- Icons
-- icons
for k,v in pairs(MultiFruitUtil.hudOverlayFilename)do
	MultiFruitUtil.changeAttribute(k,"hudOverlayFilename",v)
end

-- Farben
-- colors
for k,v in pairs(MultiFruitUtil.fruitMapColor)do
	MultiFruitUtil.changeAttribute(k,"fruitMapColor",v)
end

-- Bezeichnungen
-- names
for k,v in pairs(MultiFruitUtil.nameI18N)do
	MultiFruitUtil.changeAttribute(k,"nameI18N",v)
end
