--
-- SampleModMap
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);


function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("neu/Sky_Bumsnudel93/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function SampleModMap:loadMap01Finished(node, arguments)

   if g_currentMission.husbandries.cow ~= nil then
      g_currentMission.husbandries.cow.virtualToVisibleAnimals[1].visible = 1;
      g_currentMission.husbandries.cow.virtualToVisibleAnimals[1].virtual = 1;
      g_currentMission.husbandries.cow.virtualToVisibleAnimals[2].visible = 10;
      g_currentMission.husbandries.cow.virtualToVisibleAnimals[2].virtual = 10;
   end;
   
   if g_currentMission.husbandries.sheep ~= nil then
      g_currentMission.husbandries.sheep.virtualToVisibleAnimals[1].visible = 1;
      g_currentMission.husbandries.sheep.virtualToVisibleAnimals[1].virtual = 1;
      g_currentMission.husbandries.sheep.virtualToVisibleAnimals[2].visible = 10;
      g_currentMission.husbandries.sheep.virtualToVisibleAnimals[2].virtual = 10;
   end;
   
   if g_currentMission.husbandries.chicken ~= nil then
      g_currentMission.husbandries.chicken.virtualToVisibleAnimals[1].visible = 1;
      g_currentMission.husbandries.chicken.virtualToVisibleAnimals[1].virtual = 1;
      g_currentMission.husbandries.chicken.virtualToVisibleAnimals[2].visible = 10;
      g_currentMission.husbandries.chicken.virtualToVisibleAnimals[2].virtual = 10;
   end;

    self:loadMapXMLFile(Utils.getFilename("SampleModMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -162, -680, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -145, -352, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 514, 202, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -230, 440, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 0, -110, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 270, 380, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), - 30, 30, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("Pigs", Utils.getFilename("neu/SchweineMast/Textures/pigHUD.dds", self.baseDirectory), 340, -210, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("Beefs", Utils.getFilename("neu/SchweineMast/Textures/beefHUD.dds", self.baseDirectory), 100, -125, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("Horses", Utils.getFilename("neu/HUD/horseHUD.dds", self.baseDirectory), -790, 440, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	
	self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -140, -355, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), 113, -392, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -196, -706, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -38, -15, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -555, -55, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 90, -418, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -172, -679, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 241, 438, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -95, 11, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 35, -60, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 73, 27, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), 223, 405, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("Wald", Utils.getFilename("neu/HUD/WaldHUD.dds", self.baseDirectory), -755, -260, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	
	self.missionPDA:createMapHotspot("Wald", Utils.getFilename("neu/HUD/WaldHUD.dds", self.baseDirectory), 547, -16, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	
	self.missionPDA:createMapHotspot("Wald", Utils.getFilename("neu/HUD/WaldHUD.dds", self.baseDirectory), 790, 920, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	
	self.missionPDA:createMapHotspot("Wald", Utils.getFilename("neu/HUD/WaldHUD.dds", self.baseDirectory), -444, 473, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	
	self.missionPDA:createMapHotspot("Schnitzel", Utils.getFilename("neu/HUD/SchnitzelHUD.dds", self.baseDirectory), -540, -35, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	
	self.missionPDA:createMapHotspot("Schnitzel", Utils.getFilename("neu/HUD/SchnitzelHUD.dds", self.baseDirectory), -80, -383, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	
	self.missionPDA:createMapHotspot("Holz", Utils.getFilename("neu/HUD/HolzHUD.dds", self.baseDirectory), -580, -28, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	
	self.missionPDA:createMapHotspot("BGA", Utils.getFilename("neu/HUD/BGAHUD.dds", self.baseDirectory), 120, -250, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	

	
    SampleModMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function SampleModMap:onStartMission()
    SampleModMap:superClass().onStartMission(self);
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;