--
-- BroughallFarm
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

BroughallFarm = {}

local BroughallFarm_mt = Class(BroughallFarm, Mission00);


function BroughallFarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = BroughallFarm_mt;
    end;
    local self = BroughallFarm:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function BroughallFarm:delete()
    BroughallFarm:superClass().delete(self);
end;

function BroughallFarm:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map01.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function BroughallFarm:loadMap01Finished(node, arguments)

	self.terrainDetailAngleNumChannels = 8; -- durch die gewnschte Anzahl Channels ersetzen
	self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("BroughallFarm.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;


    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 308.94965, -602.61401, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 499.21649, -654.21411, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 325.62109, -534.04327, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- egg sellpoints
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), 329.32593, -537.27179, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -206.29616, 72.59703, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    
    -- Grass Heaps
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -232.02354, 26.16092, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -246.27888, 164.29231, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), -345.1503, 143.20316, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory),  -337.20709, 54.90174, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), -116.74316, -120.28313, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

	
    BroughallFarm:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function BroughallFarm:onStartMission()
    BroughallFarm:superClass().onStartMission(self);
end;

function BroughallFarm:mouseEvent(posX, posY, isDown, isUp, button)
    BroughallFarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function BroughallFarm:keyEvent(unicode, sym, modifier, isDown)
    BroughallFarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function BroughallFarm:update(dt)
    BroughallFarm:superClass().update(self, dt);
end;

function BroughallFarm:draw()
    BroughallFarm:superClass().draw(self);
end;