--
-- Map Function Scripts
-- by Blacky_BPG
--

---------- DEFINITIONS ----------
RolltorExtended = {};

---------- VARIABLES ----------
local RolltorExtended_mt = Class(RolltorExtended);

---------- OBJECT CLASSES ----------

---------- SPECIAL FUNCTIONS ----------
function convertNumberToAbc(str)
	replacer = {};
	replacer[1] = "x";
	replacer[2] = "h";
	replacer[3] = "w";
	replacer[4] = "p";
	replacer[5] = "a";
	replacer[6] = "k";
	replacer[7] = "z";
	replacer[8] = "r";
	replacer[9] = "v";
	replacer[10] = "m";
	str = tostring(str);
	for i=1, 10 do
		str = string.gsub(str, tostring(i-1),replacer[i]);
	end;
	str = string.gsub(str, "-","c");
	return str;
end;

---------- ONCREATE FUNCTIONS ----------
function RolltorExtended.onCreate(id)
	g_currentMission:addUpdateable(RolltorExtended:new(id));
end;

---------- NEW FUNCTIONS ----------
function RolltorExtended:new(id, customMt)
	local instance = {};
	if customMt ~= nil then
	    setmetatable(instance, customMt);
	else
	    setmetatable(instance, RolltorExtended_mt);
	end;

	instance.triggerId = id;

	instance.manualOpen = Utils.getNoNil(getUserAttribute(id, "manualOpen"), false);
	instance.syncTimer = 33;
	instance.syncTimer2 = 333;
	instance.canBeOpen = 1;
	instance.oldState = instance.canBeOpen;
	instance.playerInTrigger = false;
	if instance.manualOpen == true then
		instance.canBeOpen = 0;
		if getCollisionMask(id) ~= 15736832 then
			setCollisionMask(id,15736832);
		end;
	end;

	addTrigger(id, "triggerCallback", instance);

	instance.barriers = {};

	local door = Utils.getNoNil(getUserAttribute(id, "doorIdx"), 0);
	local barrierId = Utils.indexToObject(id, door);
	table.insert(instance.barriers, barrierId);

	instance.fieldId = Utils.getNoNil(getUserAttribute(id, "fieldId"), -1);
	if instance.fieldId == 0 then
		instance.fieldId = -1;
	end;

	instance.trafficAllowed = Utils.getNoNil(getUserAttribute(id, "trafficAllowed"), false);
	instance.AutoTimed = Utils.getNoNil(getUserAttribute(id, "AutoTimed"), false);
	instance.AutoOpen = true;
	instance.OpenTimed = Utils.getNoNil(getUserAttribute(id, "OpenTimed"), false);
	instance.OpenTime = Utils.getNoNil(getUserAttribute(id, "OpenTime"), 7.0);
	instance.CloseTime = Utils.getNoNil(getUserAttribute(id, "CloseTime"), 21.0);

	instance.randomClose = Utils.getNoNil(getUserAttribute(id, "randomClose"), false);
	instance.randomChance = Utils.getNoNil(getUserAttribute(id, "randomChance"), 25) / 2;
	instance.randomStart = 0;
	instance.randomEnd = 0;
	instance.randomActive = false;
	instance.randomRun = false;
	instance.randomText1 = Utils.getNoNil(getUserAttribute(id, "randomText1"), "default_noentry_msg");
	instance.randomText2 = Utils.getNoNil(getUserAttribute(id, "randomText2"), "default_noentry_msg");
	instance.randomText3 = Utils.getNoNil(getUserAttribute(id, "randomText3"), "default_noentry_msg");
	if instance.randomText1 == "" then
		instance.randomText1 = "default_noentry_msg";
	end;
	if instance.randomText2 == "" then
		instance.randomText2 = "default_noentry_msg";
	end;
	if instance.randomText3 == "" then
		instance.randomText3 = "default_noentry_msg";
	end;
	instance.randomActiveText = nil;

	local cSymbol = getUserAttribute(id, "CloseSymbol");
	if cSymbol ~= nil and cSymbol ~= "" then
		instance.cSymbol = Utils.indexToObject(id, cSymbol);
	end;
	local oSymbol = getUserAttribute(id, "OpenSymbol");
	if oSymbol ~= nil and oSymbol ~= "" then
		instance.oSymbol = Utils.indexToObject(id, oSymbol);
	end;

	local rul1 = getUserAttribute(id, "Rul1");
	if rul1 ~= nil and rul1 ~= "" then
		instance.rul1 = Utils.indexToObject(id, rul1);
	end;
	local rul2 = getUserAttribute(id, "Rul2");
	if rul2 ~= nil and rul2 ~= "" then
		instance.rul2 = Utils.indexToObject(id, rul2);
	end;

	if instance.rul1 ~= nil then
		setVisibility(instance.rul1, false);
	end;
	if instance.rul2 ~= nil then
		setVisibility(instance.rul2, false);
	end;

	instance.ownedByPlayer = false;

	instance.isEnabled = true;
	instance.checkIntervall = 20;
	instance.Intervall = 10;
	instance.rulTime1 = 5;
	instance.rulTime2 = 15;
	instance.rulTime3 = 10;
	instance.rulShow = 0;
	instance.ctTime = 0;

	instance.count = 0;
	instance.ccount = 0;

	instance.trans,y,z = getTranslation(instance.barriers[1]);
	instance.maxTrans = Utils.getNoNil(getUserAttribute(id, "maxX"), 14.0);
	instance.minTrans = Utils.getNoNil(getUserAttribute(id, "minX"), 0.0);

	instance.setOpenState = RolltorExtended.setOpenState;

	instance.saveName = getUserAttribute(id, "triggerName");
	if instance.saveName == nil or instance.saveName == "" then
		local x,y,z = getWorldTranslation(id);
		x = math.floor(x * 100);
		y = math.floor(y * 100);
		z = math.floor(z * 100);
		instance.saveName = convertNumberToAbc(x..y..z);
	end;
	local x, y, z = getWorldTranslation(id);
	if x < 0 then
		x = 0 - x;
	end;
	if y < 0 then
		y = 0- y;
	end;
	if z < 0 then
		z = 0 - z;
	end;
	local sId = math.floor(x * 100) + math.floor(y * 100) + math.floor(z * 100);
	sId = math.floor(sId * 3.5);
	instance.mpName = sId;
	instance.tablePos = -1;
	instance.triggerIsAdded = false;

	return instance;
end;

---------- LOAD FUNCTIONS ----------

---------- LOADMAP FUNCTIONS ----------

---------- DELETE FUNCTIONS ----------
function RolltorExtended:delete()
	if self.triggerId ~= nil then
		removeTrigger(self.triggerId);
	end;
end;

---------- DELETEMAP FUNCTIONS ----------

---------- UPDATE FUNCTIONS ----------
function RolltorExtended:update(dt)
	local y = 0;
	local z = 0;
	local override = false;
	self.trans,y,z = getTranslation(self.barriers[1]);

	if self.triggerIsAdded == false then
		if g_currentMission.barrierTriggers ~= nil then
			table.insert(g_currentMission.barrierTriggers, self);
			self.tablePos = table.getn(g_currentMission.barrierTriggers);
			self.triggerIsAdded = true;
		else
			g_currentMission.barrierTriggers = {};
			table.insert(g_currentMission.barrierTriggers, self);
			self.tablePos = table.getn(g_currentMission.barrierTriggers);
			self.triggerIsAdded = true;
		end;
	end;

	if self.Intervall >= self.checkIntervall then
		self.Intervall = 0;
	else
		self.Intervall = self.Intervall + 1;
	end;

	if self.manualOpen == true then
		if self.playerInTrigger == true and g_currentMission.player.canDrawOpen then
			if g_gui.currentGui == nil or g_gui.currentGuiName ~= "ChatDialog" then
			if InputBinding.hasEvent(InputBinding.OPEN_GATE) then
				if self.canBeOpen == 0 then
					self.canBeOpen = 2;
				else
					self.canBeOpen = 0;
				end;
				OpenTriggerManager:setOpenState(self.tablePos, self.mpName, self.canBeOpen);
			end;
			end;
		end;
	elseif self.canBeOpen ~= 1 then
		self.canBeOpen = 1;
	end;

	if self.syncTimer2 > 0 then
		self.syncTimer2 = self.syncTimer2 - 1;
	else
		if self.hasRandomSend then
			self.hasRandomSend = false;
		end;
	end;

	if self.fieldId == -1 then
		self.ownedByPlayer = true;
	else
		if self.Intervall == 1 then
			self.ownedByPlayer = false;
			if g_currentMission.fieldDefinitionBase.fieldDefs[self.fieldId].ownedByPlayer then
				self.ownedByPlayer = true;
			else
				self.ownedByPlayer = false;
			end;
		end;
	end;

	self.AutoOpen = true;
	local ctime = math.floor(g_currentMission.environment.dayTime / 3600 / 10) / 100;

	if self.AutoTimed == true or self.OpenTimed then
		if (ctime < self.OpenTime) or (ctime > self.CloseTime) then
			self.AutoOpen = false;
			self.count = 0;
			if self.cSymbol ~= nil then
				if not getVisibility(self.cSymbol) then
					setVisibility(self.cSymbol, true);
				end;
			end;
			if self.oSymbol ~= nil then
				if getVisibility(self.oSymbol) then
					setVisibility(self.oSymbol, false);
				end;
			end;
		else
			if self.OpenTimed == false then
				self.count = 1;
			end;
			if self.cSymbol ~= nil then
				if getVisibility(self.cSymbol) then
					setVisibility(self.cSymbol, false);
				end;
			end;
			if self.oSymbol ~= nil then
				if not getVisibility(self.oSymbol) then
					setVisibility(self.oSymbol, true);
				end;
			end;
		end;
	end;

	if self.randomClose then
		if self.randomActive == false and self.Intervall == 10 then
			local tActive = math.random(1, 100);
			if tActive >= (50 - self.randomChance) and tActive < (50 + self.randomChance) then
				self.randomActive = true;
				self.randomStart = math.random(0, 23);
				self.randomEnd = math.random(self.randomStart + 1, self.randomStart + 5);
				local tText = math.random(1, 9);
				if tText >= 1 and tText < 3 then
					self.randomActiveText = self.randomText1;
				elseif tText >= 3 and tText < 6 then
					self.randomActiveText = self.randomText2;
				else
					self.randomActiveText = self.randomText3;
				end;
			end;
		else
			if g_currentMission.missionDynamicInfo.isMultiplayer and g_server ~= nil then
				if not self.hasRandomSend then
					self.hasRandomSend = true;
					self.syncTimer2 = 666;
					OpenTriggerManager:setRandomState(self.mpName, self.randomActive, self.randomStart, self.randomEnd, self.randomActiveText);
				end;
			end;
			if self.randomEnd > 23.9 then
				ctime = ctime + 24;
			end;
			if (ctime < self.randomEnd) and (ctime > self.randomStart) then
				self.randomRun = true;
				if self.cSymbol ~= nil then
					if not getVisibility(self.cSymbol) then
						setVisibility(self.cSymbol, true);
					end;
				end;
				if self.oSymbol ~= nil then
					if getVisibility(self.oSymbol) then
						setVisibility(self.oSymbol, false);
					end;
				end;
			end;
			if self.randomRun == true then
				if self.count > 0 then
					local fixTime = self.randomEnd;
					if fixTime > 24 then
						fixTime = fixTime - 24;
					end;
					local msg = g_i18n:getText(self.randomActiveText).." "..tostring(fixTime).." "..g_i18n:getText("default_noentry_clock");
					g_currentMission:addWarning(msg, 0.018, 0.033);
				end;
				if ctime > self.randomEnd then
					self.randomRun = false;
					self.randomActive = false;
					self.hasRandomSend = false;
					self.randomStart = 0;
					self.randomEnd = 0;
					self.randomActiveText = nil;
				end;
			end;
		end;
	end;

	if self.randomRun == true then
		local vis1 = false;
		local vis2 = false;
		self.rulShow = self.rulShow + 1;
		if self.rulShow >= (self.rulTime1 / 2) then
			vis1 = false;
			vis2 = false;
		end;
		if self.rulShow == (self.rulTime3 / 2) then
			self.rulShow = 0;
			vis1 = true;
			vis2 = true;
		end;

		if self.rul1 ~= nil then
			setVisibility(self.rul1, vis1);
		end;
		if self.rul2 ~= nil then
			setVisibility(self.rul2, vis2);
		end;
	end;

	local old = self.trans;
	if self.ownedByPlayer == true and self.AutoOpen == true and self.randomRun == false and self.canBeOpen > 0 then
		if self.count > 0 or self.canBeOpen > 1 then
			if self.trans < self.maxTrans then
				self.trans = self.trans + dt*0.0015;
			end;
			if self.trans > self.maxTrans then
				self.trans = self.maxTrans;
			end;
		else
			if self.trans > self.minTrans then
				self.trans = self.trans - dt*0.001;
			end;
			if self.trans < self.minTrans then
				self.trans = self.minTrans;
			end;
		end;
	else
		if self.trans > self.minTrans then
			self.trans = self.trans - dt*0.001;
		end;
		if self.trans < self.minTrans then
			self.trans = self.minTrans;
		end;
	end;

	if old ~= self.trans then
		local vis1 = false;
		local vis2 = false;
		self.rulShow = self.rulShow + 1;
		if self.rulShow >= self.rulTime1 then
			vis1 = true;
			vis2 = false;
		end;
		if self.rulShow >= self.rulTime3 then
			vis2 = true;
			vis1 = true;
		end;
		if self.rulShow == self.rulTime2 then
			self.rulShow = 0;
			vis1 = false;
			vis2 = true;
		end;

		if self.rul1 ~= nil then
			setVisibility(self.rul1, vis1);
		end;
		if self.rul2 ~= nil then
			setVisibility(self.rul2, vis2);
		end;
		for i=1, table.getn(self.barriers) do
			setTranslation(self.barriers[i], self.trans, y, z);
		end;
	else
		if self.randomRun == false then
			if self.rul1 ~= nil then
				if getVisibility(self.rul1) then
					setVisibility(self.rul1, false);
				end;
			end;
			if self.rul2 ~= nil then
				if getVisibility(self.rul2) then
					setVisibility(self.rul2, false);
				end;
			end;
		end;
	end;
end;

---------- TRIGGER CALLBACK FUNCTIONS ----------
function RolltorExtended:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if g_currentMission ~= nil then
		local pName = nil;
		if g_currentMission.player ~= nil then
			pName = g_currentMission.player.controllerName;
			if g_currentMission.player.rootNode == otherId then
				if onEnter and self.isEnabled then
					if self.manualOpen == true then
						self.playerInTrigger = true;
						g_currentMission.player.canDrawOpen = true;
					end;
					self.count = self.count + 1;
				elseif onLeave then
					g_currentMission.player.canDrawOpen = false;
					self.playerInTrigger = false;
					self.count = self.count - 1;
					if self.count <= 0 then
						g_currentMission.player.canDrawOpen = false;
						self.playerInTrigger = false;
						self.count = 0;
					end;
				end;
			end;
		end;

		local vehicle = g_currentMission.nodeToVehicle[otherId];
		if vehicle ~= nil then
			local canBe = true;
			if SpecializationUtil.hasSpecialization(TrafficVehicle, vehicle.specializations) or SpecializationUtil.hasSpecialization(PathVehicle, vehicle.specializations) then
				if not self.trafficAllowed then
					canBe = false;
				end;
			end;
			if canBe then
				if vehicle.isControlled ~= nil and pName ~= nil and pName == vehicle.controllerName then
					if onEnter and self.isEnabled then
						self.count = self.count + 1;
						self.ccount = self.ccount + 1;
						if self.manualOpen == true then
							self.playerInTrigger = true;
							vehicle.canDrawOpen = true;
							g_currentMission.player.canDrawOpen = true;
						end;
					elseif onLeave then
						self.count = self.count - 1;
						self.ccount = self.ccount - 1;
						if self.ccount <= 0 then
							vehicle.canDrawOpen = false;
							self.playerInTrigger = false;
							g_currentMission.player.canDrawOpen = false;
							self.ccount = 0;
						end;
						if self.count <= 0 then
							vehicle.canDrawOpen = false;
							self.playerInTrigger = false;
							g_currentMission.player.canDrawOpen = false;
							self.count = 0;
						end;
					end;
				else
					if onEnter and self.isEnabled then
						self.count = self.count + 1;
					elseif onLeave then
						self.count = self.count - 1;
						if self.count <= 0 then
							self.count = 0;
							vehicle.canDrawOpen = false;
							self.playerInTrigger = false;
							g_currentMission.player.canDrawOpen = false;
						end;
					end;
				end;
			end;
		end;
	end;
end;

---------- OTHER FUNCTIONS ----------
function RolltorExtended:setOpenState(state)
	if state ~= nil then
		self.canBeOpen = state;
	end;
end;

---------- DRAW FUNCTIONS ----------

---------- SPECIFIC FUNCTIONS ----------

---------- ALL OTHER FUNCTIONS ----------

---------- NETWORK FUNCTIONS ----------

---------- EVENT FUNCTIONS COMPLETE ----------

---------- APPEND FUNCTIONS PROCEDURES ----------

---------- CREATE AND LISTENER CALLS ----------
g_onCreateUtil.addOnCreateFunction("RolltorExtendedOnCreate", RolltorExtended.onCreate);
