--
-- BritishFarmStyle
--
-- @author  Mike LSNG
-- @date  16/12/13
--
-- Copyright (C) LS-NG Modteam, www.ls-nextgeneration.com

BritishFarmStyle = {}

local BritishFarmStyle_mt = Class(BritishFarmStyle, Mission00);


function BritishFarmStyle:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = BritishFarmStyle_mt;
    end;
    local self = BritishFarmStyle:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function BritishFarmStyle:delete()
    BritishFarmStyle:superClass().delete(self);
end;

function BritishFarmStyle:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("BFS.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function BritishFarmStyle:loadMap01Finished(node, arguments)

		self.terrainDetailAngleNumChannels = 8;
		
		self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("BritishFarmStyle.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;
	


    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 360.70819091797, 130.72476196289, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 558.35876464844, -397.30874633789, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 563.22253417969, -371.51538085938, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 502.15167236328, -447.41516113281, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 377.27075195313, 102.758644104, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -141.74, -4.28, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 468.45, -38.48, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), -7.0815320014954, 22.114839553833, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Cows1", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 240.48, -286.03, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), -144.8505859375, -104.40886688232, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 36.506481170654, 24.11456489563, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

	-- egg sellpoints
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), 354.57794189453, 114.78565979004, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -8.1806364059448, 72.564743041992, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -62.73205947876, 32.246990203857, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
	
    -- spinnery
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), 522.05004882813, -269.60223388672, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    BritishFarmStyle:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function BritishFarmStyle:onStartMission()
    BritishFarmStyle:superClass().onStartMission(self);
end;

function BritishFarmStyle:mouseEvent(posX, posY, isDown, isUp, button)
    BritishFarmStyle:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function BritishFarmStyle:keyEvent(unicode, sym, modifier, isDown)
    BritishFarmStyle:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function BritishFarmStyle:update(dt)
    BritishFarmStyle:superClass().update(self, dt);
end;

function BritishFarmStyle:draw()
    BritishFarmStyle:superClass().draw(self);
end;