
-- Specialization for Power
--
-- @author  Manuel Leithner
-- @date  26/07/09
--modification by xyzspain 

X_Form= {};

function X_Form.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function X_Form:load(xmlFile)
	 print("X_Form X_Form load");
	 ---light
	self.powerLight = {};		
	self.powerLight.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerLight#index"));
	local x,y,z = getRotation(self.powerLight.node);
	self.powerLight.rot = {x,y,z};
	
	self.powerLight.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerLight#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerLight.node);
	local bx, by, bz = getWorldTranslation(self.powerLight.fixPoint);		
	self.powerLight.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	self.powerLight.doScale = true;
	self.attacherVehiclePowerLight = nil;
	self.doJointSearch = false;
	--- visible rollo cable o conexion 
	
	self.visibilityPowerLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visibilityPowerLight#index"));	
	setVisibility(self.visibilityPowerLight,false);	

	
	-----brake
	self.powerBrake = {};		
	self.powerBrake.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerBrake#index"));
	local x,y,z = getRotation(self.powerBrake.node);
	self.powerBrake.rot = {x,y,z};
	
	self.powerBrake.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerBrake#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerBrake.node);
	local bx, by, bz = getWorldTranslation(self.powerBrake.fixPoint);		
	self.powerBrake.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	self.powerBrake.doScale = true;
	self.attacherVehiclePowerBrake = nil;
	self.doJointSearch = false;
	--- visible rollo cable o conexion 
	
	self.visibilityPowerBrake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visibilityPowerBrake#index"));	
	setVisibility(self.visibilityPowerBrake,false);	
	
-----Hidraulic
	self.powerHidraulic = {};		
	self.powerHidraulic.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerHidraulic#index"));
	local x,y,z = getRotation(self.powerHidraulic.node);
	self.powerHidraulic.rot = {x,y,z};
	
	self.powerHidraulic.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerHidraulic#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerHidraulic.node);
	local bx, by, bz = getWorldTranslation(self.powerHidraulic.fixPoint);		
	self.powerHidraulic.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	self.powerHidraulic.doScale = true;
	self.attacherVehiclePowerHidraulic = nil;
	self.doJointSearch = false;
	--- visible rollo cable o conexion 
	
	self.visibilityPowerHidraulic = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visibilityPowerHidraulic#index"));	
	setVisibility(self.visibilityPowerHidraulic,false);	

-----Hidraulic2
	self.powerHidraulic2 = {};		
	self.powerHidraulic2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerHidraulic2#index"));
	local x,y,z = getRotation(self.powerHidraulic2.node);
	self.powerHidraulic2.rot = {x,y,z};
	
	self.powerHidraulic2.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerHidraulic2#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerHidraulic2.node);
	local bx, by, bz = getWorldTranslation(self.powerHidraulic2.fixPoint);		
	self.powerHidraulic2.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	self.powerHidraulic2.doScale = true;
	self.attacherVehiclePowerHidraulic2 = nil;
	self.doJointSearch = false;
	--- visible rollo cable o conexion 
	
	self.visibilityPowerHidraulic2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visibilityPowerHidraulic2#index"));	
	setVisibility(self.visibilityPowerHidraulic2,false);	

-----Hidraulic3
	self.powerHidraulic3 = {};		
	self.powerHidraulic3.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerHidraulic3#index"));
	local x,y,z = getRotation(self.powerHidraulic3.node);
	self.powerHidraulic3.rot = {x,y,z};
	
	self.powerHidraulic3.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerHidraulic3#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerHidraulic3.node);
	local bx, by, bz = getWorldTranslation(self.powerHidraulic3.fixPoint);		
	self.powerHidraulic3.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	self.powerHidraulic3.doScale = true;
	self.attacherVehiclePowerHidraulic3 = nil;
	self.doJointSearch = false;
	--- visible rollo cable o conexion 
	
	self.visibilityPowerHidraulic3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visibilityPowerHidraulic3#index"));	
	setVisibility(self.visibilityPowerHidraulic3,false);	





	--- visible attach
	
	self.visibility1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visibilityAttach#index1"));
	self.visibility2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visibilityAttach#index2"));
	setVisibility(self.visibility1,false);
	setVisibility(self.visibility2,false);
	
	---visible dettach
	self.visibilityDettach = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visibilityDettach#index"));
	setVisibility(self.visibilityDettach,true);
	
	
	
end;

function Power_visio:delete()
end;

function Power_visio:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Power_visio:keyEvent(unicode, sym, modifier, isDown)
end;

function Power_visio:update(dt)
	
	if self.doJointSearch then
		for i=1, table.getn(self.attacherVehicle.attachedImplements) do
					if self.attacherVehicle.attachedImplements[i].object == self then			
				local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];
				if joint.powerLightAttacher == nil then
				setVisibility(self.visibilityPowerLight,false);
				end;
				if joint.powerLightAttacher ~= nil then
					self.attacherVehiclePowerLight = joint.powerLightAttacher;
				setVisibility(self.visibilityPowerLight,true);	
					
				break;	
				end;
					
			end;
		end;
		for j=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[j].object == self then			
				local index = self.attacherVehicle.attachedImplements[j].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];
				if joint.powerBrakeAttacher == nil then
				setVisibility(self.visibilityPowerBrake,false);
				
				end;
				if joint.powerBrakeAttacher ~= nil then
					self.attacherVehiclePowerBrake = joint.powerBrakeAttacher;
				setVisibility(self.visibilityPowerBrake,true);	
				
				break;	
				end;
					
			end;
		end;
		
		for k=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[k].object == self then			
				local index = self.attacherVehicle.attachedImplements[k].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];
				if joint.powerHidraulicAttacher == nil then
				setVisibility(self.visibilityPowerHidraulic,false);
				
				end;
				if joint.powerHidraulicAttacher ~= nil then
					self.attacherVehiclePowerHidraulic = joint.powerHidraulicAttacher;
				setVisibility(self.visibilityPowerHidraulic,true);	
				
				break;	
				end;
					
			end;
		end;
		for l=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[l].object == self then			
				local index = self.attacherVehicle.attachedImplements[l].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];
				if joint.powerHidraulic2Attacher == nil then
				setVisibility(self.visibilityPowerHidraulic2,false);
				
				end;
				if joint.powerHidraulic2Attacher ~= nil then
					self.attacherVehiclePowerHidraulic2 = joint.powerHidraulic2Attacher;
				setVisibility(self.visibilityPowerHidraulic2,true);	
				
				break;	
				end;
					
			end;
		end;
		
		for m=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[m].object == self then			
				local index = self.attacherVehicle.attachedImplements[m].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];
				if joint.powerHidraulic3Attacher == nil then
				setVisibility(self.visibilityPowerHidraulic3,false);
				
				end;
				if joint.powerHidraulic3Attacher ~= nil then
					self.attacherVehiclePowerHidraulic3 = joint.powerHidraulic3Attacher;
				setVisibility(self.visibilityPowerHidraulic3,true);	
				
				break;	
				end;
					
			end;
		end;
		
		
		
		self.doJointSearch = false;
	end;
	
	if self:getIsActive() then		
			
		if self.attacherVehiclePowerLight ~= nil then		
			local ax, ay, az = getWorldTranslation(self.powerLight.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerLight);
			local x, y, z = worldDirectionToLocal(getParent(self.powerLight.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerLight.node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				if self.powerLight.doScale then
				local xScale, yScale, zScale = getScale(self.powerLight.node);
				local newScale = zScale * (distance / self.powerLight.distance);
				setScale(self.powerLight.node, 1, 1, newScale);
				end;	
		end;
		if self.attacherVehiclePowerBrake ~= nil then		
			local ax, ay, az = getWorldTranslation(self.powerBrake.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerBrake);
			local x, y, z = worldDirectionToLocal(getParent(self.powerBrake.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerBrake.node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				if self.powerBrake.doScale then
				local xScale, yScale, zScale = getScale(self.powerBrake.node);
				local newScale = zScale * (distance / self.powerBrake.distance);
				setScale(self.powerBrake.node, 1, 1, newScale);
				end;	
		end;
		if self.attacherVehiclePowerHidraulic ~= nil then	
	
			local ax, ay, az = getWorldTranslation(self.powerHidraulic.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerHidraulic);
			local x, y, z = worldDirectionToLocal(getParent(self.powerHidraulic.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerHidraulic.node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				if self.powerHidraulic.doScale then
				local xScale, yScale, zScale = getScale(self.powerHidraulic.node);
				local newScale = zScale * (distance / self.powerHidraulic.distance);
				setScale(self.powerHidraulic.node, 1, 1, newScale);
				end;	
		end;
		if self.attacherVehiclePowerHidraulic2 ~= nil then		
			local ax, ay, az = getWorldTranslation(self.powerHidraulic2.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerHidraulic2);
			local x, y, z = worldDirectionToLocal(getParent(self.powerHidraulic2.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerHidraulic2.node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				if self.powerHidraulic2.doScale then
				local xScale, yScale, zScale = getScale(self.powerHidraulic2.node);
				local newScale = zScale * (distance / self.powerHidraulic2.distance);
				setScale(self.powerHidraulic2.node, 1, 1, newScale);
				end;	
		end;
		
		if self.attacherVehiclePowerHidraulic3 ~= nil then		
			local ax, ay, az = getWorldTranslation(self.powerHidraulic3.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerHidraulic3);
			local x, y, z = worldDirectionToLocal(getParent(self.powerHidraulic3.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerHidraulic3.node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				if self.powerHidraulic3.doScale then
				local xScale, yScale, zScale = getScale(self.powerHidraulic3.node);
				local newScale = zScale * (distance / self.powerHidraulic3.distance);
				setScale(self.powerHidraulic3.node, 1, 1, newScale);
				end;	
		end;
		
		
	end;
	
end;

function Power_visio:draw()
end;


function Power_visio:onAttach(attacherVehicle)
	self.doJointSearch = true;
	setVisibility(self.visibilityDettach,false);
	setVisibility(self.visibility1,true);
	setVisibility(self.visibility2,true);
end;

function Power_visio:onDetach()
	setVisibility(self.visibility1,false);
	setVisibility(self.visibility2,false);
	setVisibility(self.visibilityDettach,true);
	
	
	 setScale(self.powerLight.node, 1, 1, 1);
	setRotation(self.powerLight.node, unpack(self.powerLight.rot));
	self.attacherVehiclePowerLight = nil;
	setVisibility(self.visibilityPowerLight,false);
	
	 setScale(self.powerBrake.node, 1, 1, 1);
	setRotation(self.powerBrake.node, unpack(self.powerBrake.rot));
	self.attacherVehiclePowerBrake = nil;
	setVisibility(self.visibilityPowerBrake,false);
	
		 setScale(self.powerHidraulic.node, 1, 1, 1);
	setRotation(self.powerHidraulic.node, unpack(self.powerHidraulic.rot));
	self.attacherVehiclePowerHidraulic = nil;
	setVisibility(self.visibilityPowerHidraulic,false);
	
		
		 setScale(self.powerHidraulic2.node, 1, 1, 1);
	setRotation(self.powerHidraulic2.node, unpack(self.powerHidraulic2.rot));
	self.attacherVehiclePowerHidraulic2 = nil;
	setVisibility(self.visibilityPowerHidraulic2,false);
	
		
		 setScale(self.powerHidraulic3.node, 1, 1, 1);
	setRotation(self.powerHidraulic3.node, unpack(self.powerHidraulic3.rot));
	self.attacherVehiclePowerHidraulic3 = nil;
	setVisibility(self.visibilityPowerHidraulic3,false);
	
	
end;




