--
-- ManuelleFeldgrenze.lua
--
-- @author  Alex2009
-- @website www.alex2009.de
-- @date    19.02.2013
--
--Modifikation erst nach rcksprache mit dem Autor(Alex2009) erlaubt.
--Modification allowed only after consultation with the author(Alex2009).

ManuelleFeldgrenze = {};
function ManuelleFeldgrenze.prerequisitesPresent(specializations)
    return true;
end;

function ManuelleFeldgrenze:load(xmlFile)
    if self.ploughLimitToField ~= nil then
        self.ploughLimitToField = true;
    end;
    if self.cultivatorLimitToField ~= nil then
        self.cultivatorLimitToField = true;
    end;
    if self.safeMode ~= nil then
        self.safeMode = true;
    end;
end;

function ManuelleFeldgrenze:delete()
end;

function ManuelleFeldgrenze:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ManuelleFeldgrenze:keyEvent(unicode, sym, modifier, isDown)
end;

function ManuelleFeldgrenze:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TRUNFIELDONOFF) then
            if self.ploughLimitToField ~= nil then
                self.ploughLimitToField = not self.ploughLimitToField;
                ManuelleFeldgrenzeSystemUpdateEvent.sendEvent(self, self.ploughLimitToField);
            end;
            if self.cultivatorLimitToField ~= nil then
                self.cultivatorLimitToField = not self.cultivatorLimitToField;
                ManuelleFeldgrenzeSystemUpdateEvent.sendEvent(self, self.cultivatorLimitToField);
            end;
            if self.safeMode ~= nil then
                self.safeMode = not self.safeMode;
                ManuelleFeldgrenzeSystemUpdateEvent.sendEvent(self, self.safeMode);
            end;
		end;
	end;
end;

function ManuelleFeldgrenze:updateTick(dt)
end;

function ManuelleFeldgrenze:onLeave()
end;

function ManuelleFeldgrenze:draw()
    if self.ploughLimitToField ~= nil then
        if self.ploughLimitToField then
            g_currentMission:addHelpButtonText(g_i18n:getText("TURNFIELDON"),InputBinding.TRUNFIELDONOFF);
        else
            g_currentMission:addHelpButtonText(g_i18n:getText("TURNFIELDOFF"),InputBinding.TRUNFIELDONOFF);
        end;
    end;
    
    if self.cultivatorLimitToField ~= nil then
        if self.cultivatorLimitToField then
            g_currentMission:addHelpButtonText(g_i18n:getText("TURNFIELDON"),InputBinding.TRUNFIELDONOFF);
        else
            g_currentMission:addHelpButtonText(g_i18n:getText("TURNFIELDOFF"),InputBinding.TRUNFIELDONOFF);
        end;
    end;
    
    if self.safeMode ~= nil then
        if self.safeMode then
            g_currentMission:addHelpButtonText(g_i18n:getText("TURNFIELDON"),InputBinding.TRUNFIELDONOFF);
        else
            g_currentMission:addHelpButtonText(g_i18n:getText("TURNFIELDOFF"),InputBinding.TRUNFIELDONOFF);
        end;
    end;
end;

--------------------------------------------------------Event----------------------------------------------------------------
ManuelleFeldgrenzeSystemUpdateEvent = {};
ManuelleFeldgrenzeSystemUpdateEvent_mt = Class(ManuelleFeldgrenzeSystemUpdateEvent, Event);

InitEventClass(ManuelleFeldgrenzeSystemUpdateEvent, "ManuelleFeldgrenzeSystemUpdateEvent");

function ManuelleFeldgrenzeSystemUpdateEvent:emptyNew()
    local self = Event:new(ManuelleFeldgrenzeSystemUpdateEvent_mt);
    self.className="ManuelleFeldgrenzeSystemUpdateEvent";
    return self;
end;

function ManuelleFeldgrenzeSystemUpdateEvent:new(vehicle, FieldActive)
    local self = ManuelleFeldgrenzeSystemUpdateEvent:emptyNew()
    self.vehicle = vehicle;
	self.FieldActive = FieldActive;
    return self;
end;

function ManuelleFeldgrenzeSystemUpdateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.FieldActive = streamReadBool(streamId);
    self:run(connection);
end;

function ManuelleFeldgrenzeSystemUpdateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.FieldActive);
end;

function ManuelleFeldgrenzeSystemUpdateEvent:run(connection)
    if self.vehicle.ploughLimitToField ~= nil then
        self.vehicle.ploughLimitToField = self.FieldActive;
    end;
    if self.vehicle.cultivatorLimitToField ~= nil then
        self.vehicle.cultivatorLimitToField = self.FieldActive;
    end;
    if self.vehicle.safeMode ~= nil then
        self.vehicle.safeMode = not self.vehicle.safeMode;
    end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(ManuelleFeldgrenzeSystemUpdateEvent:new(self.vehicle, self.FieldActive), nil, connection, self.vehicle);
    end;
end;

function ManuelleFeldgrenzeSystemUpdateEvent.sendEvent(vehicle, FieldActive, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ManuelleFeldgrenzeSystemUpdateEvent:new(vehicle, FieldActive), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ManuelleFeldgrenzeSystemUpdateEvent:new(vehicle, FieldActive));
		end;
	end;
end;
