--
-- Bomford Triblade 3000
-- Class for bomford triblade
--
-- @author  PeterJ - FS-UK modteam
-- @date  14/11/2012
--
-- Copyright (C) FS-UK modteam, Confidential, All Rights Reserved.
  

bomfTopper = {};
  
function bomfTopper.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;
  
function bomfTopper:load(xmlFile)
  
	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
  
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
	self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
	if self.groundReferenceNode == nil then
		self.groundReferenceNode = self.components[1].node;
	end;

	if self.isClient then
		local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
		if mowerSound ~= nil and mowerSound ~= "" then
			mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
			self.mowerSound = createSample("mowerSound");
			self.mowerSoundEnabled = false;
			loadSample(self.mowerSound, mowerSound, false);
			self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
			self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
		end;
	end;
  
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
	for i=1, numCuttingAreas do
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
		self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
		self.cuttingAreas[i].grassParticleSystemIndex = getXMLInt(xmlFile, areanamei .. "#particleSystemIndex");
	end;
	
	self.animation = {};
	self.animation.animCharSet = 0;
	self.animationEnabled = false;

	local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));

	if rootNode ~= nil then
		self.animation.animCharSet = getAnimCharacterSet(rootNode);
		if self.animation.animCharSet ~= 0 then
			self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.animation#animationClip"));
			if self.animation.clip >= 0 then
				assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
				self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#speedScale"), 1);
				setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
				setAnimTrackLoopState(self.animation.animCharSet, 0, true);
			end;
		end;
	end;
  
	self.isTurnedOn = false;
	self.wasToFast = false;

	self.mowerGroundFlag = self.nextDirtyFlag;
	self.nextDirtyFlag = self.mowerGroundFlag*2;
	
	self.printPTOWarningTime = 0;

	self.mowerParticleSystems = {};
	local i = 0;
	while true do
        local namei = string.format("vehicle.particleSystems.particleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		else
			self.mowerParticleSystems.index = nodei;
		end; 
        Utils.loadParticleSystem(xmlFile, self.mowerParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
	end;

	self.mowerParticleSystemFlag = self:getNextDirtyFlag();
	
	self.strapAnimNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strapAnim#index"));
	self.strapAnimMin = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.strapAnim#min"), 0.0);
	self.strapAnimMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.strapAnim#max"), 0.0);
	self.strapAnimSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.strapAnim#speed"), 0.0);
	self.operateStrapAnim = false;
	self.strapScale = 1.01;
	
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	self.saveMinRpm = 0; 

	self.lastArea = 0;
	self.lastAreaBiggerZero = self.lastArea > 0;
	
end;

function bomfTopper:delete()
	Utils.deleteParticleSystem(self.mowerParticleSystems);
	if self.mowerSound ~= nil then
		delete(self.mowerSound);
	end;
end;
  
function bomfTopper:readStream(streamId, connection)
	local turnedOn = streamReadBool(streamId);
	self:setIsTurnedOn(turnedOn, true);
	self.lastAreaBiggerZero = streamReadBool(streamId);
end;
  
function bomfTopper:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isTurnedOn);
	streamWriteBool(streamId, self.lastAreaBiggerZero);
end;

function bomfTopper:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		self.lastAreaBiggerZero = streamReadBool(streamId);
	end;
end;
  
function bomfTopper:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.lastAreaBiggerZero);
	end;
end;
  
function bomfTopper:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function bomfTopper:keyEvent(unicode, sym, modifier, isDown)
end;
  
function bomfTopper:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			if self.PTOId then
				self.printPTOWarningTime = self.time + 1500;
			else
				self:setIsTurnedOn(not self.isTurnedOn);
			end;
		end;
	end;
end;
  
function bomfTopper:updateTick(dt)
	if self.movingDirection > 0 then
		setRotation(self.mowerParticleSystems.index, 0, 0, 0);
	else
		setRotation(self.mowerParticleSystems.index, 0, 180, 0);
	end;
	self.wasToFast = false;
	self.lastArea = 0;
	if self:getIsActive() then
		if not self.attacherVehicle.isMotorStarted then
			self:setIsTurnedOn(false);
		end;
		if self.PTOId then
			self:setIsTurnedOn(false);
		end;
		local isKeyEvent = false;
		if self.isTurnedOn then
			isKeyEvent = true;
		else
			isKeyEvent = false;
		end;
		self:setVehicleRpmUp(dt, isKeyEvent);
		if self.isTurnedOn then
			local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
			if not toFast and self:isLowered(false) then
				if self.isServer then
					local x,y,z = getWorldTranslation(self.groundReferenceNode);
					local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
					if terrainHeight+self.groundReferenceThreshold >= y then
						local foldAnimTime = self.foldAnimTime;
						local totalArea = 0;
						local cuttingAreasSend = {};
						for k, cuttingArea in pairs(self.cuttingAreas) do
							if self:getIsAreaActive(cuttingArea) then
								local x,y,z = getWorldTranslation(cuttingArea.start);
								local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
								local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
								table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
							end;
						end;
						if (table.getn(cuttingAreasSend) > 0) then
							totalArea = BomfordAreaEvent.runLocally(cuttingAreasSend);
							self.lastArea = totalArea;
							self.lastAreaBiggerZero = (self.lastArea > 0);
						end;
						if totalArea > 0 then
							if (table.getn(cuttingAreasSend) > 0) then
								g_server:broadcastEvent(BomfordAreaEvent:new(cuttingAreasSend));
							end;
						end;				
					end;
				end;
			end;
			if self.isClient then
				if not self.mowerSoundEnabled and self:getIsActiveForSound() then
					setSamplePitch(self.mowerSound, self.mowerSoundPitchOffset);
					playSample(self.mowerSound, 0, self.mowerSoundVolume, 0);
					self.mowerSoundEnabled = true;
				end;
			end;
			self.wasToFast = toFast;

		else
			if self.isClient then
				if self.mowerSoundEnabled then
					stopSample(self.mowerSound);
					self.mowerSoundEnabled = false;
				end;
			end;
		end;
		if self.isTurnedOn and self.movingDirection ~= 0 and self.lastAreaBiggerZero and self:isLowered(false) then
			Utils.setEmittingState(self.mowerParticleSystems, true);
		else
			Utils.setEmittingState(self.mowerParticleSystems, false);
		end;		
	end;

	if self.strapAnimNode ~= nil then
		if self.operateStrapAnim then
			if self.strapFolding then
				if self.strapScale < self.strapAnimMax then
					self.strapScale = self.strapScale + self.strapAnimSpeed;
				elseif  self.strapScale > self.strapAnimMax then
					self.operateStrapAnim = false;
				end;
			else
				if self.strapScale > self.strapAnimMin then
					self.strapScale = self.strapScale - self.strapAnimSpeed;
				elseif  self.strapScale < self.strapAnimMin then
					self.operateStrapAnim = false;
				end;
			end;
			setScale(self.strapAnimNode, 1, self.strapScale, 1);
		end;
	end;
end;
  
function bomfTopper:draw()
	if self.isClient then
		if self.attacherVehicle.isMotorStarted then
			if self.isTurnedOn then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
			end;
		end;
		if self.wasToFast then
			g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
		end;
		if self.printPTOWarningTime > self.time then
			g_currentMission:addWarning(g_i18n:getText("turnON_Error"), 0.018, 0.033);
		end;
	end;
end;

function bomfTopper:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function bomfTopper:onAttach(attacherVehicle)
	self.operateStrapAnim = true;
	self.strapFolding = false;
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function bomfTopper:onDetach()
	if self.deactivateOnDetach then
		bomfTopper.onDeactivate(self);
	else
		bomfTopper.onDeactivateSounds(self)
	end;
	if self.mowerParticleSystems ~= nil then
		Utils.setEmittingState(self.mowerParticleSystems, false);
	end;
	self.operateStrapAnim = true;
	self.strapFolding = true;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function bomfTopper:onLeave()
	if self.deactivateOnLeave then
		bomfTopper.onDeactivate(self);
	else
		bomfTopper.onDeactivateSounds(self)
	end;
	if self.mowerParticleSystems ~= nil then
		Utils.setEmittingState(self.mowerParticleSystems, false);
	end; 
end;
  
function bomfTopper:onDeactivate()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	bomfTopper.onDeactivateSounds(self)
	self.isTurnedOn = false;
	if self.mowerParticleSystems ~= nil then
		Utils.setEmittingState(self.mowerParticleSystems, false);
	end;
end;
  
function bomfTopper:onDeactivateSounds()
	if self.isClient then
		if self.mowerSoundEnabled then
			stopSample(self.mowerSound);
			self.mowerSoundEnabled = false;
		end;
	end;
end;
  
function bomfTopper:setIsTurnedOn(turnedOn, noEventSend)
	SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
	self.isTurnedOn = turnedOn;
	
	if not turnedOn then
		if self.animationEnabled then
			disableAnimTrack(self.animation.animCharSet, 0);
			self.animationEnabled = false;
		end;
	else
		if not self.animationEnabled then
			enableAnimTrack(self.animation.animCharSet, 0);
			self.animationEnabled = true;
		end;
	end;
end;

function bomfTopper:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -1000);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;
