--
-- 
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v0.9
-- @date:       2013-05-19
-- 
--
placeableBollard = {};
placeableBollard.currentModDirectory = g_currentModDirectory;

placeableBollard_mt = Class(placeableBollard, Placeable);
InitObjectClass(placeableBollard, "placeableBollard");

function placeableBollard:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, placeableBollard_mt);
    registerObjectClassName(self, "placeableBollard");
	
	self.numObjectClasses = 0;
	self.objectClasses = {};
	
    return self;
end;

function placeableBollard:delete()
    placeableBollard:superClass().delete(self);
	
    unregisterObjectClassName(self);
	
	for _, class in pairs(self.objectClasses) do
		class:delete();
	end;
end;

function placeableBollard:deleteFinal()
    placeableBollard:superClass().deleteFinal(self);
end;

function placeableBollard:readStream(streamId, connection)
    placeableBollard:superClass().readStream(self, streamId, connection);
	
	for _, class in pairs(self.objectClasses) do
		class:readStream(streamId, connection);
	end;
end;

function placeableBollard:writeStream(streamId, connection)
    placeableBollard:superClass().writeStream(self, streamId, connection);
	
	for _, class in pairs(self.objectClasses) do
		class:writeStream(streamId, connection);
	end;
end;

function placeableBollard:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
	if not placeableBollard:superClass().load(self, xmlFilename, x, y, z, rx, ry, rz, moveMode, initRandom) then
		return false;
	end;
	
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
	
	local i = 0;
	while true do
		local key = string.format("placeable.types.animation(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		
		local triggerIndex = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, key .. "#triggerIndex"));
		if triggerIndex ~= nil then
			local node = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, key .. "#index"));
			
			if node ~= nil then
				local animCharSet = getAnimCharacterSet(node);
				
				if animCharSet ~= nil then
					local name = Utils.getNoNil(getXMLString(xmlFile, key .. "#name"), "");
					local clip = getAnimClipIndex(animCharSet, getXMLString(xmlFile, key .. "#clip"));
					
					if clip ~= nil then
						assignAnimTrackClip(animCharSet, 0, clip);
						
						if getAnimTrackAssignedClip(animCharSet, 0) then
							local loop = Utils.getNoNil(getXMLBool(xmlFile, key .. "#loop"), false);
							local fa = Utils.getNoNil(getXMLBool(xmlFile, key .. "#loopFinish"), false);
							local speedScale = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#speedScale"), 15);
							local duration = getAnimClipDuration(animCharSet, clip);
							local cas;
							setAnimTrackLoopState(animCharSet, 0, loop);
							
							if g_client then
								local animSound = getXMLString(xmlFile, key .. ".sound#file");
								if animSound ~= nil and animSound ~= "" then
									animSound = Utils.getFilename(animSound, placeableBollard.currentModDirectory);
									local soundVolume = Utils.getNoNil(getXMLFloat(xmlFile, key .. ".sound#volume"), 1);
									local soundRadius = Utils.getNoNil(getXMLFloat(xmlFile, key .. ".sound#outerRadius"), 50);
									local soundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, key .. ".sound#innerRadius"), 10);
									cas = createAudioSource("clientAnimationSound" .. i, animSound, soundRadius, soundInnerRadius, soundVolume, 0);
									
									link(node, cas);
									setVisibility(cas, false);
								end;
							end;
							
							self.numObjectClasses = self.numObjectClasses + 1;
							self.objectClasses[self.numObjectClasses] = AdditionalMapFeaturesClass:new(name, triggerIndex, node, animCharSet, clip, loop, fa, speedScale, duration, cas);
						end;
					end;
					
					i = i + 1;
				end;
			else	
				break;
			end;
		else
			break;
		end;
	end;
	
	local i = 0;
	while true do
		local key = string.format("placeable.types.light(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		
		local triggerIndex = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, key .. "#triggerIndex"));
		if triggerIndex ~= nil then
			local node = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, key .. "#index"));
			if node ~= nil then
				local name = Utils.getNoNil(getXMLString(xmlFile, key .. "#name"), "");
				setVisibility(node, false);
				
				self.numObjectClasses = self.numObjectClasses + 1;
				self.objectClasses[self.numObjectClasses] = AdditionalMapFeaturesClass:new(name, triggerIndex, node);
				
				i = i + 1;
			else
				break;
			end;
		else
			break;
		end;
	end;
	
    delete(xmlFile);
    return true;
end;

function placeableBollard:loadFromAttributesAndNodes(xmlFile, tag, resetVehicles)
	if not placeableBollard:superClass().loadFromAttributesAndNodes(self, xmlFile, tag, resetVehicles) then
		return false;
	end;
	
	for i, class in pairs(self.objectClasses) do
		local key = tag .. string.format(".AdditionalMapFeaturesClass(%d)", i - 1);
		local state = getXMLBool(xmlFile, key .. "#activated");
		local animTime = getXMLFloat(xmlFile, key .. "#animTime");
		
		class:loadFromAttributes(state, animTime, resetVehicles);
	end;
	
	return true;
end;

function placeableBollard:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = placeableBollard:superClass().getSaveAttributesAndNodes(self, nodeIdent);
	
	for i, class in pairs(self.objectClasses) do
		if i > 1 then
			nodes = nodes .. "\n";
		end;
		nodes = nodes .. nodeIdent .. '<AdditionalMapFeaturesClass ' .. class:getSaveAttributes() .. ' />';
	end;
	
	return attributes, nodes;
end;

function placeableBollard:update(dt)
	for _, class in pairs(self.objectClasses) do
		if class.update ~= nil then
			class:update(dt);
		end;
	end;
end;

registerPlaceableType("placeableBollard", placeableBollard);


