--
-- AdditionalMapFeaturesClass
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v1.0
-- @date:       2013-05-20
-- 
--
AdditionalMapFeaturesClass = {};
AdditionalMapFeaturesClass_mt = Class(AdditionalMapFeaturesClass);

function AdditionalMapFeaturesClass:new(name, triggerIndex, node, animCharSet, clip, loop, fa, speedScale, duration, cas, customMt)
	local self = {};
	
	if customMt ~= nil then
		setmetatable(self, customMt);
	else
		setmetatable(self, AdditionalMapFeaturesClass_mt);
	end;
	
	self.isEnabled = true;
	
	self.name = name;
	self.trigger = triggerIndex;
	self.node = node;
	self.animCharSet = animCharSet;
	
	if self.animCharSet ~= nil then
		self.clip = clip;
		self.loop = loop;
		self.fa = fa;
		self.speedScale = speedScale;
		self.duration = duration;
		self.cas = cas;
		
		self.curTime = 0;
		self.lastTime = 0;
		self.trackActivated = false;
		
		if self.cas ~= nil then
			self.casEnabled = false;
		end;
	end;
	
	self.activated = false;
	self.playerInRange = false;
	self.vehiclesInRange = {};
	
	addTrigger(self.trigger, "triggerCallback", self);
	
    return self;
end;

function AdditionalMapFeaturesClass:delete()
	if self.trigger ~= nil then
		removeTrigger(self.trigger);
	end;
end;

function AdditionalMapFeaturesClass:readStream(streamId, connection)
	self:setActivationStatus(streamReadBool(streamId), true);
	
	if self.animCharSet ~= nil then
		self.curTime = streamReadFloat32(streamId);
	end;
end;

function AdditionalMapFeaturesClass:writeStream(streamId, connection)
	streamWriteBool(streamId, self.activated);
	
	if self.animCharSet ~= nil then
		streamWriteFloat32(streamId, self.curTime);
	end;
end;

function AdditionalMapFeaturesClass:loadFromAttributes(activated, curTime, resetVehicles)
	if activated ~= nil then
		self:setActivationStatus(activated, true);
	end;
	
	if curTime ~= nil then
		self.curTime = curTime;
		setAnimTrackTime(self.animCharSet, 0, self.curTime)
	end;
end;

function AdditionalMapFeaturesClass:getSaveAttributes()
	local save = 'activated="' .. tostring(self.activated) .. '"';
	
	if self.curTime ~= nil then
		save = save .. ' curTime="' .. self.curTime .. '"'
	end;
	
	return save;
end;

function AdditionalMapFeaturesClass:update(dt)
	if self:getCanInteract() and g_client then
		if g_gui.currentGui == nil and not g_currentMission.isPlayerFrozen then
			if InputBinding.hasEvent(InputBinding.Toggle_Bollard) then
				self:setActivationStatus(not self.activated);
			end;
		end;
		
		if self.animCharSet == nil then
			if self.activated then
				if g_i18n:hasText("PLACE_ON") then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PLACE_ON"), self.name), InputBinding.Toggle_Bollard);
				end;
			else
				if g_i18n:hasText("PLACE_OFF") then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PLACE_OFF"), self.name), InputBinding.Toggle_Bollard);
				end;
			end;
		
		else
			if self.activated then
				if g_i18n:hasText("PLACE_ACTIVATED") then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PLACE_ACTIVATED"), self.name), InputBinding.Toggle_Bollard);
				end;
			else
				if g_i18n:hasText("PLACE_DEACTIVATED") then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PLACE_DEACTIVATED"), self.name), InputBinding.Toggle_Bollard);
				end;
			end;
		end;
	end;
	
	if self.animCharSet == nil then
		if getVisibility(self.node) ~= self.activated then
			setVisibility(self.node, self.activated);
		end;
	else
		local animationEnabled = isAnimTrackEnabled(self.animCharSet, 0);
		if animationEnabled then
			if g_client then
				if not self.casEnabled and self.cas ~= nil then
					setVisibility(self.cas, true);
					self.casEnabled = true;
				end;
			end;
		else
			if self.casEnabled and self.cas ~= nil then
				setVisibility(self.cas, false);
				self.casEnabled = false;
			end;
		end;
	
		if self.loop then
			local direction = self.speedScale;
			local stop = false;
			if not self.activated then
				if self.fa then
					if self.curTime <= 1 then
						stop = true;
					end;
				else
					stop = true;
				end;
			end;
			if not stop then
				self.curTime = self.curTime + direction;
				
				if self.curTime > self.duration then
					self.curTime = 0;
				end;
			end;
			
			if stop then
				disableAnimTrack(self.animCharSet, 0);
				self.trackActivated = false;
			end;
		else
			if self.activated then
				if self.curTime < self.duration then
					self.curTime = self.curTime + self.speedScale;
				else
					self.curTime = self.duration;
					disableAnimTrack(self.animCharSet, 0);
					self.trackActivated = false;
				end;
			else
				if self.curTime > 0 then
					self.curTime = self.curTime - self.speedScale;
				else
					self.curTime = 0;
					disableAnimTrack(self.animCharSet, 0);
					self.trackActivated = false;
				end;
			end;
		end;
		
		if self.lastTime ~= self.curTime then
			if not self.trackActivated then
				enableAnimTrack(self.animCharSet, 0);
				self.trackActivated = true;
			end;
			
			setAnimTrackTime(self.animCharSet, 0, self.curTime, false);
			self.lastTime = self.curTime;
		end;
	end;
end;

function AdditionalMapFeaturesClass:setActivationStatus(bool, noEventSend)
	self.activated = bool;
	
	setActivationStatusEvent.sendEvent(self, bool, noEventSend);
end;

function AdditionalMapFeaturesClass:getCanInteract()
	if g_currentMission.controlPlayer and self.playerInRange then
		return true;
	end;
	
	if not g_currentMission.controlPlayer then
		for vehicle in pairs(self.vehiclesInRange) do
			if vehicle:getIsActiveForInput(false) then
				return true;
			end;
		end;
	end;
	
	return false;
end;

function AdditionalMapFeaturesClass:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if self.isEnabled then
		if (onEnter or onLeave) then
			if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
				if onEnter then
					self.playerInRange = true;
				else
					self.playerInRange = false;
				end;
			else
				local vehicle = g_currentMission.nodeToVehicle[otherId];
				if vehicle ~= nil then
					if onEnter then
						if self.vehiclesInRange[vehicle] == nil then
							self.vehiclesInRange[vehicle] = true;
						end;
					else
						if self.vehiclesInRange[vehicle] then
							self.vehiclesInRange[vehicle] = nil;
						end;
					end;
				end;
			end;
		end;
	end;
end;


setActivationStatusEvent = {};
setActivationStatusEvent_mt = Class(setActivationStatusEvent, Event);

InitEventClass(setActivationStatusEvent, "setActivationStatusEvent");

function setActivationStatusEvent:emptyNew()
    local self = Event:new(setActivationStatusEvent_mt);
    self.className = "setActivationStatusEvent";
    return self;
end;

function setActivationStatusEvent:new(object, activated)
    local self = setActivationStatusEvent:emptyNew()
    self.object = object;
	self.activated = activated;
    return self;
end;

function setActivationStatusEvent:readStream(streamId, connection)
    local activated = streamReadInt32(streamId);
    self.object = networkGetObject(activated);
	self.activated = streamReadBool(streamId);
    self:run(connection);
end;

function setActivationStatusEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.activated);
end;

function setActivationStatusEvent:run(connection)
	self.object:setActivationStatus(self.activated, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(setActivationStatusEvent:new(self.object, self.activated), nil, connection, self.object);
	end;
end;

function setActivationStatusEvent.sendEvent(object, activated, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setActivationStatusEvent:new(object, activated), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(setActivationStatusEvent:new(object, activated));
		end;
	end;
end;