--
-- Bockowo1992
--
-- Copyright (C) BOCIEK and POLISHMODS Team, All Rights Reserved.

Bockowo1992 = {}

local Bockowo1992_mt = Class(Bockowo1992, Mission00);

function Bockowo1992:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Bockowo1992_mt;
    end;
    local self = Bockowo1992:superClass():new(baseDirectory, mt);
    return self;
end;

function Bockowo1992:delete()
    Bockowo1992:superClass().delete(self);
end;

function Bockowo1992:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- ladowanie krow
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- ladowanie minimapki
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    Bockowo1992:superClass().load(self);
end
function Bockowo1992:loadFinished()
    Bockowo1992:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function Bockowo1992:mouseEvent(posX, posY, isDown, isUp, button)
    Bockowo1992:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Bockowo1992:keyEvent(unicode, sym, modifier, isDown)
    Bockowo1992:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Bockowo1992:update(dt)
    Bockowo1992:superClass().update(self, dt);
end;

function Bockowo1992:draw()
    Bockowo1992:superClass().draw(self);
end;
