-- www.schwabenmodding.bplaced.net 
-- thanks to Desperados93 for some Ideas from the "schiebetor" LUA and also Giants Software for the "barriers" Script.

doorsStallScheune = {};
  
local doorsStallScheune_mt = Class(doorsStallScheune);
  
function doorsStallScheune.onCreate(id)
    g_currentMission:addUpdateable(doorsStallScheune:new(id));
end;
  
function doorsStallScheune:new(id, customMt) 
    local instance = {};
    if customMt ~= nil then
        setmetatable(instance, customMt);
    else
        setmetatable(instance, doorsStallScheune_mt);
    end;
  
    instance.triggerId = id;
    addTrigger(id, "triggerCallback", instance);
  	  
	instance.doorsStallScheune = {};
	local door = getChildAt(id, 0);
	if door ~= nil then
	    table.insert(instance.doorsStallScheune, door);
	else
	    print("doorsStallScheune: Error, Doorindex is nil, please add Doorindex.")
	end;
       
    instance.isEnabled = true;
    self.count = 0; 
    self.trans = 0;
    self.maxTrans = getUserAttribute(id, "maxTrans");
    self.minTrans = getUserAttribute(id, "minTrans"); 
    return instance;
end;
  
function doorsStallScheune:delete()
    removeTrigger(self.triggerId);
end;
  
function doorsStallScheune:update(dt)     
    local old = self.trans;
    if self.count > 0 then
	    if self.maxTrans > self.minTrans then
			if self.trans < self.maxTrans then
				self.trans = self.trans + dt*0.001;    
			end;
		elseif self.maxTrans < self.minTrans then
			if self.trans > self.maxTrans then
				self.trans = self.trans - dt*0.001;    
			end;		
		end;
    else
	    if self.maxTrans > self.minTrans then
			if self.trans > self.minTrans then
				self.trans = self.trans - dt*0.001;    
			end;
		elseif self.maxTrans < self.minTrans then
			if self.trans < self.minTrans then
				self.trans = self.trans + dt*0.001;    
			end;	
		end;	
    end;    
    if old ~= self.trans then
        for i=1, table.getn(self.doorsStallScheune) do
            setTranslation(self.doorsStallScheune[i], self.trans, 0, 0);
        end;
    end;     
end;
  
function doorsStallScheune:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
    if onEnter and self.isEnabled then
        self.count = self.count + 1;
    elseif onLeave then
        self.count = self.count - 1;
    end; 
end;
    
g_onCreateUtil.addOnCreateFunction("doorsStallScheuneOnCreate", doorsStallScheune.onCreate);

