--
-- whitesBucket
-- This is the specialization for whites implements
--
-- @author  PeterJ - euroDZN
-- @date  16/07/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.


whitesBucket = {};

function whitesBucket.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Foldable, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function whitesBucket:load(xmlFile)

	self.autoClose = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.foldingParts#autoClose"), false);
	if self.autoClose then
		self.autoOperate = true;
	end;

end;
	
function whitesBucket:delete()
end;

function whitesBucket:mouseEvent(posX, posY, isDown, isUp, button)
end;

function whitesBucket:keyEvent(unicode, sym, modifier, isDown)
end;

function whitesBucket:update(dt)
end;

function whitesBucket:updateTick(dt)

	if self:getIsActive() then
		if self.autoClose then
			if self.fillLevel >= self.capacity then
				if self.autoOperate then
					self:setFoldState(-self.turnOnFoldDirection, false);
					self.autoOperate = false;
				end;
			else
				self.autoOperate = true;
			end;
		end;	
	end;
end;

function whitesBucket:draw()
end;