--
-- keulmacTrailer
-- This is the specialization for keulmac trailer
--
-- @author  PeterJ - euroDZN
-- @date  16/07/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.


keulmacTrailer = {};

function keulmacTrailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function keulmacTrailer:load(xmlFile)

	self.setMoveRamp = SpecializationUtil.callSpecializationsFunction("setMoveRamp");
	self.rampAnimation = getXMLString(xmlFile, "vehicle.ramp#animationName");
	self.rampAnimDuration = self:getAnimationDuration(self.rampAnimation);
	self.isRampDown = false;
	self.rampStartAnimTime = 0;
	
	self.contacTriggerCallback = keulmacTrailer.contacTriggerCallback;
	self.contactNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ramp#contactNode"));
	addContactReport(self.contactNode, 0.0001, "contacTriggerCallback", self);
	
end;

function keulmacTrailer:delete()
end;

function keulmacTrailer:readStream(streamId, connection)
	self:setMoveRamp(streamReadBool(streamId), true);	
end;

function keulmacTrailer:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isRampDown);	
end;

function keulmacTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function keulmacTrailer:keyEvent(unicode, sym, modifier, isDown)
end;
  
function keulmacTrailer:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local animTime = getXMLFloat(xmlFile, key.."#rampAnimTime");
		if animTime == nil then
			animTime = self.rampStartAnimTime;
		end;
		keulmacTrailer.setAnimTime(self, animTime)
		if animTime < 0.5 then
			self.isRampDown = false;
		else
			self.isRampDown = true;
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function keulmacTrailer:getSaveAttributesAndNodes(nodeIdent)
	local animTime = self:getAnimationTime(self.rampAnimation);
	local attributes = 'rampAnimTime="'..animTime..'"';
	return attributes, nil;
end;
  
function keulmacTrailer:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:setMoveRamp(not self.isRampDown);
		end;
	end;
end;

function keulmacTrailer:updateTick(dt)	
end;

function keulmacTrailer:draw()
	if self:getIsActive() then
		if self.isRampDown then
			g_currentMission:addHelpButtonText(g_i18n:getText("liftRamp"), InputBinding.IMPLEMENT_EXTRA2);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("lowerRamp"), InputBinding.IMPLEMENT_EXTRA2);
		end;
	end;
end;

function keulmacTrailer:setMoveRamp(isRampDown,noEventSend)
	setMoveRampEvent.sendEvent(self, isRampDown, noEventSend);
	self.isRampDown = isRampDown;
	if self.isRampDown then
		if self.rampAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rampAnimation, 1, nil, true);
		end;
	else
		if self.rampAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rampAnimation, -1, nil, true);
		end;
	end;	
end;

function keulmacTrailer:contacTriggerCallback(objectId, otherObjectId, isStart, normalForce, tangentialForce)
	if isStart then
		if self.contactNode == objectId then
			self:stopAnimation(self.rampAnimation, true);
		end;
	end;
end;

function keulmacTrailer.setAnimTime(self, animTime)
	if self.rampAnimation ~= nil then
		self.rampAnimTime = animTime;
		local stopAnimTime = (self.rampAnimTime*self.rampAnimDuration)/self:getAnimationDuration(self.rampAnimation);
		self:playAnimation(self.rampAnimation, 1, nil, true);
		self:setAnimationStopTime(self.rampAnimation, stopAnimTime);
		AnimatedVehicle.updateAnimationByName(self, self.rampAnimation, 99999999);
	end;
end;

setMoveRampEvent = {};
setMoveRampEvent_mt = Class(setMoveRampEvent, Event);

InitEventClass(setMoveRampEvent, "setMoveRampEvent");

function setMoveRampEvent:emptyNew()
    local self = Event:new(setMoveRampEvent_mt);
    self.className="setMoveRampEvent";
    return self;
end;

function setMoveRampEvent:new(vehicle, isRampDown)
    local self = setMoveRampEvent:emptyNew()
    self.vehicle = vehicle;
	self.isRampDown = isRampDown;
    return self;
end;

function setMoveRampEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRampDown = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function setMoveRampEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isRampDown);
end;

function setMoveRampEvent:run(connection)   
	self.vehicle:setMoveRamp(self.isRampDown, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(setMoveRampEvent:new(self.vehicle, self.isRampDown), nil, connection, self.vehicle);
    end;
end;

function setMoveRampEvent.sendEvent(vehicle, isRampDown, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setMoveRampEvent:new(vehicle, isRampDown), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setMoveRampEvent:new(vehicle, isRampDown));
		end;
	end;
end;
