--
-- hydraulic hose
-- Specialization for hydraulic hose joint
--
-- @author  PeterJ - euroDZN
-- @date  02/06/2012
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

hydraulicHose = {};

function hydraulicHose.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function hydraulicHose:load(xmlFile)
	
	---- hydraulic hose ----
	self.hose = {};		
	self.hose.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicHose#index"));
	self.hose.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicHose#scalePart"));
	self.hose.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicHose#fixPoint"));
	self.hose.connector = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicHose#connector"));
	self.hose.detached = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicHose#detached"));
	if self.hose.node ~= nil and self.hose.part ~= nil then
		local ax, ay, az = getWorldTranslation(self.hose.part);
		local bx, by, bz = getWorldTranslation(self.hose.fixPoint);		
		self.hose.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		setVisibility(self.hose.node, false);
		setVisibility(self.hose.detached, true);
	end;
	self.attacherVehicleHose = nil;
	
	self.doJointSearch = false;
end;

function hydraulicHose:delete()
end;

function hydraulicHose:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hydraulicHose:keyEvent(unicode, sym, modifier, isDown)
end;

function hydraulicHose:update(dt)

	if self.doJointSearch then
		for i=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[i].object == self then			
				local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];
				if joint.hydrahoseAttacher ~= nil then
					self.attacherVehicleHose = joint.hydrahoseAttacher;
					link(self.attacherVehicleHose, self.hose.connector);
					setTranslation(self.hose.connector, 0, 0, 0);
					--setRotation(self.hose.connector, math.rad(0, 0, 0));
					setVisibility(self.hose.node, true);
				else
					setVisibility(self.hose.node, false);
				end;
			end;
		end;
		self.doJointSearch = false;
	end;
	if self:getIsActive() then
		if self.attacherVehicleHose ~= nil then		
			local ax, ay, az = getWorldTranslation(self.hose.node);
			local bx, by, bz = getWorldTranslation(self.hose.connector);
			local x, y, z = worldDirectionToLocal(getParent(self.hose.node), bx-ax, by-ay, bz-az);
			setDirection(self.hose.node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setScale(self.hose.part, 1, 1, distance/self.hose.distance);
		end;
	end;
end;

function hydraulicHose:draw()
end;

function hydraulicHose:onAttach(attacherVehicle)
	self.doJointSearch = true;
	setVisibility(self.hose.detached, false);
end;

function hydraulicHose:onDetach()
	setVisibility(self.hose.node, false);
	setVisibility(self.hose.detached, true);
	self.attacherVehicleHose = nil;
	unlink(self.hose.connector);
end;

