--
-- bobcatCrawler
-- This is the specialization for Bobcat T180 crawler
--
-- @author  PeterJ - euroDZN
-- @date  28/05/2014
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.
  
bobcatCrawler = {};
  
function bobcatCrawler.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;
  
function bobcatCrawler:load(xmlFile)

	bobcatCrawler.loadCrawlers(self, xmlFile);

	self.rot1 = 0;
	self.rot2 = 0;
end;

function bobcatCrawler:loadCrawlers(xmlFile)
	self.crawlers = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.crawlers.crawler(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local speedRefNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#speedRefNode")), node);
		local scrollSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#scrollSpeed"), 1);
		local shaderParameterName = Utils.getNoNil(getXMLString(xmlFile, key.."#shaderParameterName"), "scrollPosition");
		local shaderParameterComponent = Utils.getNoNil(getXMLInt(xmlFile, key.."#shaderParameterComponent"), 1);
		local scrollLength = Utils.getNoNil(getXMLFloat(xmlFile, key.."#scrollLength"), 1);
		if node ~= nil then
			local rotatingParts = {};
			local j = 0;
			while true do
				local keyRotation = key..string.format(".rotatingPart(%d)", j);
				if not hasXMLProperty(xmlFile, keyRotation) then
					break;
				end;
				local rotationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, keyRotation.."#index"));
				local speedScale = getXMLFloat(xmlFile, keyRotation.."#speedScale");
				if speedScale == nil then
					speedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, keyRotation.."#radius"), 1);
				end;
				if rotationNode ~= nil then
					table.insert(rotatingParts, {node=rotationNode, speedScale=speedScale});
				end;
				j = j + 1;
			end;
			table.insert(self.crawlers, {node=node, scrollSpeed=scrollSpeed, scrollPosition=0, scrollLength=scrollLength, shaderParameterName=shaderParameterName, shaderParameterComponent=shaderParameterComponent, speedRefNode=speedRefNode, rotatingParts=rotatingParts});
		end;
		i = i + 1;
	end;
end;

function bobcatCrawler:delete()
end;

function bobcatCrawler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function bobcatCrawler:keyEvent(unicode, sym, modifier, isDown)
end;

function bobcatCrawler:update(dt)
	if self:getIsActive() then
		for k, wheel in pairs(self.wheels) do
			local rot1,_,_ = getRotation(self.wheels[3].driveNode);
			local rot2,_,_ = getRotation(self.wheels[4].driveNode);
			if self.rot1 ~= rot1 or self.rot2 ~= rot2 then
				for _, crawler in pairs(self.crawlers) do
					local newX, newY, newZ = getWorldTranslation(crawler.speedRefNode);
					if crawler.lastPosition == nil then
						crawler.lastPosition = {newX, newY, newZ};
					end;
					local dx, dy, dz = worldDirectionToLocal(crawler.speedRefNode, newX-crawler.lastPosition[1], newY-crawler.lastPosition[2], newZ-crawler.lastPosition[3]);
					local movingDirection = 0;
					if dz > 0.0001 then
						movingDirection = 1;
					elseif dz < -0.0001 then
						movingDirection = -1;
					end;
					local movedDistance = Utils.vector3Length(dx, dy, dz);
					crawler.lastPosition[1] = newX;
					crawler.lastPosition[2] = newY;
					crawler.lastPosition[3] = newZ;
					crawler.scrollPosition = (crawler.scrollPosition + movedDistance*movingDirection*crawler.scrollSpeed) % crawler.scrollLength;
					if crawler.shaderParameterComponent == 1 then
						setShaderParameter(crawler.node, crawler.shaderParameterName, crawler.scrollPosition,0,0,0, false);
					else
						setShaderParameter(crawler.node, crawler.shaderParameterName, 0,crawler.scrollPosition,0,0, false);
					end;
					for _, rotatingPart in pairs(crawler.rotatingParts) do
						rotate(rotatingPart.node, rotatingPart.speedScale * movedDistance * movingDirection, 0, 0);
					end;
				end;
			end;
			self.rot1 = rot1;
			self.rot2 = rot2;
		end;
	end;
end;

function bobcatCrawler:draw()
end;

function bobcatCrawler:developmentReloadFromXML(xmlFile)
	bobcatCrawler.loadCrawlers(self, xmlFile);
end;