--
-- IgnitionKeyAnim
-- Specialization class for MF 1200 and 1250 animated keyring
--
-- @author  PeterJ - euroDZN
-- @date  16/03/2014
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

KeyAnim = {};

function KeyAnim.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function KeyAnim:load(xmlFile)
	
	self.ignitionKeyAnim = getXMLString(xmlFile, "vehicle.ignitionKey#animationName");
	self.ignitionKeyHeatAnim = getXMLString(xmlFile, "vehicle.ignitionKey#heatAnimationName");
end;

function KeyAnim:delete()
end;

function KeyAnim:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KeyAnim:keyEvent(unicode, sym, modifier, isDown)
end;

function KeyAnim:update(dt)
end;

function KeyAnim:draw()
end;

function KeyAnim:onLeave()
	if self.deactivateMI == nil then
		self:playAnimation(self.ignitionKeyHeatAnim, -1, nil, true);
	end;
end;

function KeyAnim:onEnter()
	if self.deactivateMI == nil then
		self:playAnimation(self.ignitionKeyHeatAnim, 1, nil, true);
	end;
end;

function KeyAnim:setManualIgnitionMode(ignition, noEventSend)
	if self.ignitionMode == 0 then
		self:playAnimation(self.ignitionKeyHeatAnim, 1, nil, true);
	elseif self.ignitionMode == 1 then
		self:playAnimation(self.ignitionKeyAnim, 1, nil, true);
	elseif self.ignitionMode == 2 then
		self:playAnimation(self.ignitionKeyHeatAnim, -1, nil, true);
	end;
end;