--
-- FixAttacher
-- attacherJoint is on right position
--
-- Ersteller: fruktor Edit: Brndi
-- 
-- Datum 14/01/13
--

FixAttacher = {};

function FixAttacher.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function FixAttacher:load(xmlFile)	
	self.doJointSearchCylindered = false;
end;

function FixAttacher:delete()
end;

function FixAttacher:readStream(streamId, connection)
end;

function FixAttacher:writeStream(streamId, connection)
end;

function FixAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FixAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function FixAttacher:update(dt)
end;

function FixAttacher:updateTick(dt)

	if self.doJointSearchCylindered then
		if self.attacherVehicle ~= nil then
			for k,v in pairs(self.attacherVehicle.attachedImplements) do
				if v.object == self then
					local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
					self.vehicleJoint = joint;
					self.doJointSearchCylindered = false;
					break;
				end;
			end;
		end;
		self.doJointSearchCylindered = false;
	end;
	   
    if self.vehicleJoint ~= nil	then
        setJointFrame(self.vehicleJoint.jointIndex, 1, self.attacherJoint.node);
	end;
	
end;

function FixAttacher:onAttach()
	self.doJointSearchCylindered = true;
end;

function FixAttacher:onDetach()
	self.vehicleJoint = nil;
end;

function FixAttacher:draw()
end;