sieczkarniaEvent = {};
sieczkarniaEvent_mt = Class(sieczkarniaEvent, Event);

InitEventClass(sieczkarniaEvent, "sieczkarniaEvent");

function sieczkarniaEvent:emptyNew()
    local self = Event:new(sieczkarniaEvent_mt);
    self.className="sieczkarniaEvent";
    return self;
end;

function sieczkarniaEvent:new(object, isActive)
    local self = sieczkarniaEvent:emptyNew()
    self.object = object;
	self.isActive = isActive;
    return self;
end;

function sieczkarniaEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isActive = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function sieczkarniaEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isActive);
end;

function sieczkarniaEvent:run(connection)
	self.object:setsieczkarniaActive(self.isActive, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(sieczkarniaEvent:new(self.object, self.isActive), nil, connection, self.object);
    end;	
end;

function sieczkarniaEvent.sendEvent(sieczkarnia, isActive)
	if g_server ~= nil then
		g_server:broadcastEvent(sieczkarniaEvent:new(sieczkarnia, isActive), nil, nil, sieczkarnia);
	else
		g_client:getServerConnection():sendEvent(sieczkarniaEvent:new(sieczkarnia, isActive));
	end;
end;

